/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.netbinox;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.DirBundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.MRUBundleFileList;
import org.eclipse.osgi.baseadaptor.bundlefile.ZipBundleFile;
import org.netbeans.core.netigso.spi.BundleContent;
import org.netbeans.core.netigso.spi.NetigsoArchive;
import org.netbeans.modules.netbinox.EmptyBundleFile;
import org.netbeans.modules.netbinox.ModuleEntry;
import org.netbeans.modules.netbinox.NetbinoxFactory;
import org.netbeans.modules.netbinox.RootEntry;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;

final class JarBundleFile
extends BundleFile
implements BundleContent {
    private BundleFile delegate;
    private static Map<Long, File> usedIds;
    private final MRUBundleFileList mru;
    private final BaseData data;
    private final NetigsoArchive archive;

    JarBundleFile(File base, BaseData data, NetigsoArchive archive, MRUBundleFileList mru, boolean isBase) {
        super(base);
        long id = isBase ? data.getBundleID() : (long)(100000 + base.getPath().hashCode());
        boolean assertOn = false;
        if (!$assertionsDisabled) {
            assertOn = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertOn) {
            File prev;
            if (usedIds == null) {
                usedIds = new HashMap<Long, File>();
            }
            if ((prev = usedIds.put(id, base)) != null && !prev.equals(base)) {
                NetbinoxFactory.LOG.log(Level.WARNING, "same id: {0} for {1} and {2}", new Object[]{id, base, prev});
            }
        }
        this.archive = archive.forBundle(id, (BundleContent)this);
        this.data = data;
        this.mru = mru;
    }

    private synchronized BundleFile delegate(String who, String what) {
        if (this.delegate == null) {
            NetbinoxFactory.LOG.log(Level.FINE, "opening {0} because of {1} needing {2}", new Object[]{this.data.getLocation(), who, what});
            try {
                this.delegate = new ZipBundleFile(this.getBaseFile(), this.data, this.mru){

                    protected boolean checkedOpen() {
                        try {
                            return this.getZipFile() != null;
                        }
                        catch (IOException ex) {
                            File bf = new File(this.getBaseFile().getPath());
                            if (bf.isDirectory()) {
                                try {
                                    JarBundleFile.this.delegate = (BundleFile)new DirBundleFile(bf, false);
                                    return false;
                                }
                                catch (IOException dirEx) {
                                    NetbinoxFactory.LOG.log(Level.WARNING, "Cannot create DirBundleFile for " + bf, dirEx);
                                }
                            }
                            NetbinoxFactory.LOG.log(Level.WARNING, "Cannot open bundle delegate {0}", bf);
                            if (!bf.isFile() || !bf.canRead()) {
                                JarBundleFile.this.delegate = EmptyBundleFile.EMPTY;
                                return false;
                            }
                            return super.checkedOpen();
                        }
                    }
                };
            }
            catch (IOException ex) {
                NetbinoxFactory.LOG.log(Level.WARNING, "Error creating delegate for {0} because of {1}", new Object[]{this.getBaseFile(), this.data.getLocation()});
                this.delegate = EmptyBundleFile.EMPTY;
            }
        }
        return this.delegate;
    }

    public File getBaseFile() {
        final File file = super.getBaseFile();
        class VFile
        extends File {
            public VFile() {
                super(file2.getPath());
            }

            @Override
            public boolean isDirectory() {
                return false;
            }

            @Override
            public boolean isFile() {
                return true;
            }

            @Override
            public boolean exists() {
                return true;
            }

            @Override
            public File getAbsoluteFile() {
                return this;
            }

            @Override
            public long lastModified() {
                return JarBundleFile.this.data.getLastModified();
            }
        }
        return new VFile();
    }

    public File getFile(String file, boolean bln) {
        byte[] exists = this.getCachedEntry(file);
        if (exists == null) {
            return null;
        }
        BundleFile d = this.delegate("getFile", file);
        return d == null ? null : d.getFile(file, bln);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] resource(String name) throws IOException {
        BundleEntry u = this.findEntry("resource", name);
        if (u == null) {
            return null;
        }
        InputStream is = u.getInputStream();
        if (is == null) {
            return new byte[0];
        }
        byte[] arr = null;
        try {
            int len;
            int toRead;
            arr = new byte[is.available()];
            int pos = 0;
            while ((toRead = arr.length - pos) != 0 && (len = is.read(arr, pos, toRead)) != -1) {
                pos += len;
            }
            if (pos != arr.length) {
                throw new IOException("Not read enough: " + pos + " should have been: " + arr.length);
            }
        }
        finally {
            is.close();
        }
        NetbinoxFactory.LOG.log(Level.FINE, "Loaded {1} bytes for {0}", new Object[]{name, arr.length});
        return arr;
    }

    private BundleEntry findEntry(String why, String name) {
        BundleFile d;
        BundleEntry u;
        if (!name.equals("META-INF/MANIFEST.MF") && this.data != null && this.data.getLocation() != null && this.data.getLocation().startsWith("netigso://")) {
            String cnb = this.data.getLocation().substring(10);
            for (ModuleInfo mi : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
                URL url;
                if (!mi.getCodeNameBase().equals(cnb)) continue;
                if (!mi.isEnabled() || (url = mi.getClassLoader().getResource(name)) == null) break;
                return new ModuleEntry(url, name);
            }
        }
        if ("/".equals(name)) {
            return new RootEntry(this);
        }
        while ((u = (d = this.delegate(why, name)).getEntry(name)) == null && d != this.delegate) {
        }
        return u;
    }

    private byte[] getCachedEntry(String name) {
        try {
            return this.archive.fromArchive(name);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public BundleEntry getEntry(String name) {
        if (!this.archive.isActive()) {
            return this.delegate("inactive", name).getEntry(name);
        }
        byte[] arr = this.getCachedEntry(name);
        if (arr == null && !name.equals("/")) {
            return null;
        }
        return new CachingEntry(arr, name);
    }

    public Enumeration<String> getEntryPaths(String prefix) {
        BundleFile d = this.delegate("getEntryPaths", prefix);
        if (d == null) {
            return Collections.enumeration(Collections.emptyList());
        }
        return d.getEntryPaths(prefix);
    }

    public synchronized void close() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    public void open() throws IOException {
        if (this.delegate != null) {
            this.delegate.open();
        }
    }

    public boolean containsDir(String path) {
        return path.endsWith("/") && this.getEntry(path) != null;
    }

    private class CachingEntry
    extends BundleEntry {
        private final String name;
        private final int size;
        private final Reference<byte[]> arr;

        public CachingEntry(byte[] arr, String name) {
            this.size = arr.length;
            this.name = name;
            this.arr = new SoftReference<byte[]>(arr);
        }

        public InputStream getInputStream() throws IOException {
            byte[] data = this.arr.get();
            this.arr.clear();
            if (data == null) {
                data = JarBundleFile.this.getCachedEntry(this.name);
            }
            if (data == null) {
                throw new FileNotFoundException();
            }
            return new ByteArrayInputStream(data);
        }

        public long getSize() {
            return this.size;
        }

        public String getName() {
            return this.name;
        }

        public long getTime() {
            return JarBundleFile.this.getBaseFile().lastModified();
        }

        public URL getLocalURL() {
            return JarBundleFile.this.findEntry("getLocalURL", this.name).getLocalURL();
        }

        public URL getFileURL() {
            return JarBundleFile.this.findEntry("getFileURL", this.name).getFileURL();
        }
    }
}

