/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolOptions;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.modules.lsp.client.bindings.AbstractNavigatorPanel;
import org.netbeans.modules.lsp.client.bindings.Icons;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class NavigatorPanelImpl
extends AbstractNavigatorPanel<Either<SymbolInformation, DocumentSymbol>>
implements LSPBindings.BackgroundTask {
    public NavigatorPanelImpl(LSPBindings bindings) {
        this.setDisplayName(bindings);
    }

    @Override
    void addBackgroundTask(FileObject fo) {
        LSPBindings.addBackgroundTask(fo, this);
    }

    @Override
    void removeBackgroundTask(FileObject fo) {
        LSPBindings.removeBackgroundTask(fo, this);
    }

    @Override
    public void run(LSPBindings bindings, FileObject file) {
        if (this.isCurrentFile(file)) {
            this.setDisplayName(bindings);
            try {
                String uri = Utils.toURI(file);
                List symbols = (List)bindings.getTextDocumentService().documentSymbol(new DocumentSymbolParams(new TextDocumentIdentifier(uri))).get();
                this.setKeys(symbols);
                this.expandAll();
            }
            catch (ExecutionException ex) {
                LOG.log(Level.FINE, null, ex);
                this.setKeys(Collections.emptyList());
            }
            catch (InterruptedException ex) {
                LSPBindings.addBackgroundTask(file, this);
            }
        }
    }

    @Override
    protected Node[] createNodes(FileObject currentFile, Either<SymbolInformation, DocumentSymbol> sym) {
        return new Node[]{new NodeImpl(Utils.toURI(currentFile), sym)};
    }

    private void setDisplayName(LSPBindings bindings) {
        InitializeResult initResult = bindings.getInitResult();
        ServerCapabilities capa = initResult.getCapabilities();
        Either symbolProvider = capa != null ? capa.getDocumentSymbolProvider() : null;
        String displayName = symbolProvider != null && symbolProvider.isRight() ? ((DocumentSymbolOptions)symbolProvider.getRight()).getLabel() : null;
        this.setDisplayName(displayName);
    }

    private static final class NodeImpl
    extends AbstractNode {
        private final Action open;

        private static Children createChildren(String currentFileUri, Either<SymbolInformation, DocumentSymbol> sym) {
            if (sym.isLeft()) {
                return Children.LEAF;
            }
            return NodeImpl.createChildren(currentFileUri, (DocumentSymbol)sym.getRight());
        }

        private static Children createChildren(final String currentFileUri, final DocumentSymbol sym) {
            if (sym.getChildren() == null || sym.getChildren().isEmpty()) {
                return Children.LEAF;
            }
            return new Children.Keys<DocumentSymbol>(){

                protected void addNotify() {
                    this.setKeys(sym.getChildren());
                }

                protected Node[] createNodes(DocumentSymbol sym2) {
                    return new Node[]{new NodeImpl(currentFileUri, sym2)};
                }

                protected void removeNotify() {
                    this.setKeys(Collections.emptyList());
                }
            };
        }

        private static Action createOpenAction(final String uri, final Range range) {
            return new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Utils.open(uri, range);
                }
            };
        }

        public NodeImpl(String currentFileUri, Either<SymbolInformation, DocumentSymbol> symbol) {
            super(NodeImpl.createChildren(currentFileUri, symbol));
            if (symbol.isLeft()) {
                this.setDisplayName(((SymbolInformation)symbol.getLeft()).getName());
                this.setIconBaseWithExtension(Icons.getSymbolIconBase(((SymbolInformation)symbol.getLeft()).getKind()));
                this.open = NodeImpl.createOpenAction(((SymbolInformation)symbol.getLeft()).getLocation().getUri(), ((SymbolInformation)symbol.getLeft()).getLocation().getRange());
            } else {
                this.setDisplayName(((DocumentSymbol)symbol.getRight()).getName());
                this.setShortDescription(((DocumentSymbol)symbol.getRight()).getDetail());
                this.setIconBaseWithExtension(Icons.getSymbolIconBase(((DocumentSymbol)symbol.getRight()).getKind()));
                this.open = NodeImpl.createOpenAction(currentFileUri, ((DocumentSymbol)symbol.getRight()).getRange());
            }
        }

        public NodeImpl(String currentFileUri, DocumentSymbol symbol) {
            super(NodeImpl.createChildren(currentFileUri, symbol));
            this.setDisplayName(symbol.getName());
            this.setShortDescription(symbol.getDetail());
            this.setIconBaseWithExtension(Icons.getSymbolIconBase(symbol.getKind()));
            this.open = NodeImpl.createOpenAction(currentFileUri, symbol.getRange());
        }

        public Action getPreferredAction() {
            return this.open;
        }
    }
}

