/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings.refactoring.tree;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactory;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class FileTreeElement
implements TreeElement,
Openable {
    private FileObject fo;

    FileTreeElement(FileObject fo) {
        this.fo = fo;
    }

    public TreeElement getParent(boolean isLogical) {
        if (isLogical) {
            Project p = FileOwnerQuery.getOwner((FileObject)this.fo);
            if (p != null && p.getProjectDirectory() == this.fo.getParent()) {
                return TreeElementFactory.getTreeElement((Object)p);
            }
            return TreeElementFactory.getTreeElement((Object)this.fo.getParent());
        }
        Project p = FileOwnerQuery.getOwner((FileObject)this.fo);
        if (p != null) {
            return TreeElementFactory.getTreeElement((Object)p);
        }
        return TreeElementFactory.getTreeElement((Object)this.fo.getParent());
    }

    public Icon getIcon() {
        try {
            ImageIcon imageIcon = new ImageIcon(DataObject.find((FileObject)this.fo).getNodeDelegate().getIcon(1));
            return imageIcon;
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
    }

    public String getText(boolean isLogical) {
        return this.fo.getNameExt();
    }

    public Object getUserObject() {
        return this.fo;
    }

    public void open() {
        try {
            if (this.fo.isValid() && this.fo.isData()) {
                DataObject od = DataObject.find((FileObject)this.fo);
                NbDocument.openDocument((Lookup.Provider)od, (int)0, (Line.ShowOpenType)Line.ShowOpenType.OPEN, (Line.ShowVisibilityType)Line.ShowVisibilityType.FOCUS);
            }
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

