/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.ParserManagerListener;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.text.NbDocument;

class LanguagesNavigatorModel
implements TreeModel {
    private NbEditorDocument document;
    private ASTNode astNode;
    private NavigatorNode root;
    private EventListenerList listenerList = new EventListenerList();
    private static NavigatorComparator navigatorComparator;
    private ParserListener parserListener;
    private ParserManagerImpl parserManager;

    LanguagesNavigatorModel() {
        this.root = new NavigatorNode("", "", null, true);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((NavigatorNode)parent).getNodes(null).get(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((NavigatorNode)parent).getNodes(null).size();
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((NavigatorNode)node).getNodes(null).isEmpty();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ((NavigatorNode)parent).getNodes(null).indexOf(child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    void setContext(NbEditorDocument doc) {
        this.document = doc;
        if (doc == null) {
            this.root = new NavigatorNode("", "", null, true);
            this.astNode = null;
            this.setParserManager(null);
            this.fire();
            return;
        }
        ParserManagerImpl parserManager = ParserManagerImpl.getImpl((Document)doc);
        this.setParserManager(parserManager);
        this.refreshASTNode();
    }

    private void setParserManager(ParserManagerImpl parserManager) {
        if (parserManager == this.parserManager) {
            return;
        }
        if (this.parserListener == null) {
            this.parserListener = new ParserListener();
        }
        if (this.parserManager != null) {
            this.parserManager.removeListener(this.parserListener);
        }
        if (parserManager != null) {
            parserManager.addListener(this.parserListener);
        }
        this.parserManager = parserManager;
    }

    private void refreshASTNode() {
        this.astNode = this.parserManager.getAST();
        if (this.astNode == null) {
            this.root = new NavigatorNode("", "", null, true);
            this.fire();
        } else {
            ArrayList<ASTItem> path = new ArrayList<ASTItem>();
            path.add(this.astNode);
            List<ASTNavigatorNode> rootNodes = this.root.getNodes(this);
            if (this.root instanceof ASTNavigatorNode && ((ASTNavigatorNode)this.root).document == this.document && rootNodes != null && rootNodes.size() > 0) {
                if (this.parserManager.getState() == ParserManager.State.PARSING) {
                    return;
                }
                ASTNavigatorNode newASTNode = new ASTNavigatorNode((StyledDocument)this.document, this.astNode, path, "Root", "", null, false);
                ((ASTNavigatorNode)this.root).refreshNode(this, newASTNode, new LinkedList());
            } else {
                ASTNavigatorNode newASTNode = new ASTNavigatorNode((StyledDocument)this.document, this.astNode, path, "Root", "", null, false);
                newASTNode.getNodes(this);
                if (this.parserManager.getState() == ParserManager.State.PARSING) {
                    return;
                }
                this.root = newASTNode;
                this.fire();
            }
        }
    }

    private void fire() {
        TreeModelListener[] listeners = (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
        if (listeners.length == 0) {
            return;
        }
        TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{this.getRoot()});
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].treeStructureChanged(e);
        }
    }

    private void fireRemove(ASTNavigatorNode node, int[] indices, ASTNavigatorNode[] children, LinkedList<ASTNavigatorNode> nodePath) {
        TreeModelListener[] listeners = (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
        if (listeners.length == 0) {
            return;
        }
        TreePath path = new TreePath(nodePath.toArray());
        TreeModelEvent e = new TreeModelEvent((Object)this, path, indices, (Object[])children);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].treeNodesRemoved(e);
        }
    }

    private void fireInsert(ASTNavigatorNode node, int[] indices, ASTNavigatorNode[] children, LinkedList<ASTNavigatorNode> nodePath) {
        TreeModelListener[] listeners = (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
        if (listeners.length == 0) {
            return;
        }
        TreePath path = new TreePath(nodePath.toArray());
        TreeModelEvent e = new TreeModelEvent((Object)this, path, indices, (Object[])children);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].treeNodesInserted(e);
        }
    }

    private boolean cancel() {
        return this.parserManager.getState() == ParserManager.State.PARSING;
    }

    TreePath getTreePath(int position) {
        if (this.astNode == null) {
            return null;
        }
        if (!(this.root instanceof ASTNavigatorNode)) {
            return null;
        }
        ASTPath astPath = this.astNode.findPath(position);
        if (astPath == null) {
            return null;
        }
        ArrayList<ASTNavigatorNode> nodePath = new ArrayList<ASTNavigatorNode>();
        ASTNavigatorNode n = (ASTNavigatorNode)this.root;
        ListIterator<ASTItem> it = astPath.listIterator();
        if (it.next() != n.item) {
            return null;
        }
        nodePath.add(n);
        block0: while (it.hasNext()) {
            ASTItem astItem = (ASTItem)it.next();
            for (ASTNavigatorNode nn : n.getNodes(null)) {
                if (nn.item != astItem) continue;
                n = nn;
                nodePath.add(nn);
                continue block0;
            }
        }
        if (nodePath.isEmpty()) {
            return null;
        }
        return new TreePath(nodePath.toArray());
    }

    String getTooltip(Object node) {
        return ((NavigatorNode)node).tooltip;
    }

    void show(Object node) {
        ((NavigatorNode)node).show();
    }

    String getIcon(Object node) {
        return ((NavigatorNode)node).icon;
    }

    String getDisplayName(Object node) {
        return ((NavigatorNode)node).displayName;
    }

    static class NavigatorComparator
    implements Comparator<NavigatorNode> {
        NavigatorComparator() {
        }

        @Override
        public int compare(NavigatorNode o1, NavigatorNode o2) {
            return o1.displayName.compareToIgnoreCase(o2.displayName);
        }
    }

    static class ASTNavigatorNode
    extends NavigatorNode {
        ASTItem item;
        List<ASTItem> path;
        private StyledDocument document;
        private List<ASTNavigatorNode> nodes;

        ASTNavigatorNode(StyledDocument document, ASTItem item, List<ASTItem> path, String displayName, String tooltip, String icon, boolean isLeaf) {
            super(displayName, tooltip, icon, isLeaf);
            this.document = document;
            this.item = item;
            this.path = path;
        }

        @Override
        void show() {
            DataObject dataObject = NbEditorUtilities.getDataObject((Document)this.document);
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            Line.Set lineSet = lineCookie.getLineSet();
            Line line = lineSet.getCurrent(NbDocument.findLineNumber((StyledDocument)this.document, (int)this.item.getOffset()));
            int column = NbDocument.findLineColumn((StyledDocument)this.document, (int)this.item.getOffset());
            line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, column);
        }

        @Override
        List<ASTNavigatorNode> getNodes(LanguagesNavigatorModel model) {
            Feature properties;
            if (this.nodes != null) {
                return this.nodes;
            }
            if (this.isLeaf) {
                this.nodes = Collections.emptyList();
                return this.nodes;
            }
            this.nodes = new ArrayList<ASTNavigatorNode>();
            this.getNavigatorNodes(this.item, new ArrayList<ASTItem>(this.path), this.nodes, model);
            Language language = (Language)this.item.getLanguage();
            if (language != null && (properties = language.getFeatureList().getFeature("PROPERTIES")) != null && properties.getBoolean("navigator-sort", false)) {
                if (navigatorComparator == null) {
                    navigatorComparator = new NavigatorComparator();
                }
                Collections.sort(this.nodes, navigatorComparator);
            }
            return this.nodes;
        }

        private void refreshNode(LanguagesNavigatorModel model, ASTNavigatorNode newNode, LinkedList<ASTNavigatorNode> nodePath) {
            this.item = newNode.item;
            this.path = newNode.path;
            if (this.nodes == null) {
                return;
            }
            nodePath.add(this);
            List<ASTNavigatorNode> newChildren = newNode.getNodes(model);
            ArrayList<ASTNavigatorNode> newNodes = new ArrayList<ASTNavigatorNode>(newChildren.size());
            int index = 0;
            int lastIndex = 0;
            int insertPos = 0;
            ArrayList<Integer> removed = new ArrayList<Integer>();
            ArrayList<Integer> inserted = new ArrayList<Integer>();
            for (ASTNavigatorNode node : newChildren) {
                int x;
                ASTNavigatorNode found = null;
                for (x = index; x < this.nodes.size(); ++x) {
                    if (!this.compareNodes(node, this.nodes.get(x))) continue;
                    found = this.nodes.get(x);
                    index = x + 1;
                    break;
                }
                if (found != null) {
                    newNodes.add(found);
                    for (x = lastIndex; x < index - 1; ++x) {
                        removed.add(x);
                    }
                    lastIndex = index;
                    found.refreshNode(model, node, nodePath);
                } else {
                    newNodes.add(node);
                    inserted.add(insertPos);
                }
                ++insertPos;
            }
            for (int x = index; x < this.nodes.size(); ++x) {
                removed.add(x);
            }
            int[] removedIndices = new int[removed.size()];
            ASTNavigatorNode[] removedNodes = new ASTNavigatorNode[removed.size()];
            for (int x = 0; x < removedIndices.length; ++x) {
                removedIndices[x] = (Integer)removed.get(x);
                removedNodes[x] = this.nodes.get(removedIndices[x]);
            }
            int[] insertedIndices = new int[inserted.size()];
            ASTNavigatorNode[] insertedNodes = new ASTNavigatorNode[inserted.size()];
            for (int x = 0; x < insertedIndices.length; ++x) {
                insertedIndices[x] = (Integer)inserted.get(x);
                insertedNodes[x] = newChildren.get(insertedIndices[x]);
            }
            this.nodes = newNodes;
            if (removedIndices.length > 0) {
                model.fireRemove(this, removedIndices, removedNodes, nodePath);
            }
            if (insertedIndices.length > 0) {
                model.fireInsert(this, insertedIndices, insertedNodes, nodePath);
            }
            nodePath.removeLast();
        }

        private void getNavigatorNodes(ASTItem item, List<ASTItem> path, List<ASTNavigatorNode> nodes, LanguagesNavigatorModel model) {
            Iterator<ASTItem> it = item.getChildren().iterator();
            while (it.hasNext()) {
                if (model != null && model.cancel()) {
                    return;
                }
                ASTItem item2 = it.next();
                path.add(item2);
                ASTNavigatorNode navigatorNode = this.createNavigatorNode(item2, path);
                if (navigatorNode != null) {
                    nodes.add(navigatorNode);
                } else {
                    this.getNavigatorNodes(item2, path, nodes, model);
                }
                path.remove(path.size() - 1);
            }
        }

        private ASTNavigatorNode createNavigatorNode(ASTItem item, List<ASTItem> path) {
            ASTPath astPath = ASTPath.create(path);
            Feature navigator = null;
            Language language = (Language)item.getLanguage();
            if (language == null) {
                return null;
            }
            navigator = language.getFeatureList().getFeature("NAVIGATOR", astPath);
            if (navigator == null) {
                return null;
            }
            SyntaxContext context = SyntaxContext.create((Document)this.document, astPath);
            String displayName = (String)navigator.getValue("display_name", context);
            if (displayName == null || displayName.trim().length() == 0) {
                return null;
            }
            String tooltip = (String)navigator.getValue("tooltip", context);
            String icon = (String)navigator.getValue("icon", context);
            if (icon == null) {
                icon = "org/netbeans/modules/languages/resources/node.gif";
            }
            boolean isLeaf = navigator.getBoolean("isLeaf", context, false);
            return new ASTNavigatorNode(this.document, item, new ArrayList<ASTItem>(path), displayName, tooltip, icon, isLeaf);
        }
    }

    static class NavigatorNode {
        String displayName;
        String tooltip;
        String icon;
        boolean isLeaf;

        NavigatorNode(String displayName, String tooltip, String icon, boolean isLeaf) {
            this.displayName = displayName;
            this.tooltip = tooltip;
            this.icon = icon;
            this.isLeaf = isLeaf;
        }

        void show() {
        }

        List<ASTNavigatorNode> getNodes(LanguagesNavigatorModel model) {
            return Collections.emptyList();
        }

        boolean compareNodes(NavigatorNode nodeA, NavigatorNode nodeB) {
            if (nodeA.displayName == null ? nodeB.displayName != null : !nodeA.displayName.equals(nodeB.displayName)) {
                return false;
            }
            if (nodeA.icon == null ? nodeB.icon != null : !nodeA.icon.equals(nodeB.icon)) {
                return false;
            }
            return nodeA.isLeaf == nodeB.isLeaf;
        }
    }

    class ParserListener
    implements ParserManagerListener {
        ParserListener() {
        }

        @Override
        public void parsed(ParserManager.State state, ASTNode ast) {
            if (state == ParserManager.State.PARSING) {
                return;
            }
            LanguagesNavigatorModel.this.refreshASTNode();
        }
    }
}

