/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.classfile;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.DirectiveTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.classfile.Attribute;
import com.sun.tools.classfile.ClassFile;
import com.sun.tools.classfile.Code_attribute;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.Instruction;
import com.sun.tools.classfile.Method;
import com.sun.tools.classfile.Opcode;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javap.ClassWriter;
import com.sun.tools.javap.CodeWriter;
import com.sun.tools.javap.ConstantWriter;
import com.sun.tools.javap.Messages;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.AbstractElementVisitor9;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.query.CommentSet;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class CodeGenerator {
    private static final Logger LOG = Logger.getLogger(CodeGenerator.class.getName());
    private static final Set<ElementKind> UNUSABLE_KINDS = EnumSet.of(ElementKind.PACKAGE);
    private static final byte VERSION = 2;
    private static final String HASH_ATTRIBUTE_NAME = "origin-hash";
    private static final String DISABLE_ERRORS = "disable-java-errors";
    static final String CLASSFILE_ROOT = "classfile-root";
    static final String CLASSFILE_BINNAME = "classfile-binaryName";
    private static final Map<List<ElementKind>, Set<Modifier>> IMPLICIT_MODIFIERS = new HashMap<List<ElementKind>, Set<Modifier>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject generateCode(final ClasspathInfo cpInfo, final ElementHandle<? extends Element> toOpenHandle) {
        if (UNUSABLE_KINDS.contains((Object)toOpenHandle.getKind())) {
            return null;
        }
        try {
            FileObject file = FileUtil.createMemoryFileSystem().getRoot().createData(toOpenHandle.getKind() == ElementKind.MODULE ? "module-info.java" : "test.java");
            try (OutputStream out = file.getOutputStream();){
                FileUtil.copy((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), (OutputStream)out);
            }
            JavaSource js = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{file});
            final FileObject[] result = new FileObject[1];
            final boolean[] sourceGenerated = new boolean[1];
            final URL[] classfileRoot = new URL[1];
            final String[] binaryName = new String[1];
            ModificationResult r = js.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy wc) throws Exception {
                    FileObject root;
                    FileObject resource;
                    String binName;
                    wc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    Element toOpen = toOpenHandle.resolve((CompilationInfo)wc);
                    if (toOpen != null && toOpen.getKind() == ElementKind.MODULE) {
                        binName = "module-info";
                        JavaFileObject jfo = ((Symbol.ModuleSymbol)toOpen).module_info.classfile;
                        FileObject fileObject = resource = jfo != null ? URLMapper.findFileObject((URL)jfo.toUri().toURL()) : null;
                        if (resource == null) {
                            LOG.info("Cannot find resource for module: " + ((ModuleElement)toOpen).getQualifiedName());
                            return;
                        }
                        root = resource.getParent();
                    } else {
                        TypeElement te;
                        ClassPath cp = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT), cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE), cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE)});
                        TypeElement typeElement = te = toOpen != null ? wc.getElementUtilities().outermostTypeElement(toOpen) : null;
                        if (te == null) {
                            LOG.info("Cannot resolve element: " + toOpenHandle.toString() + " on classpath: " + cp.toString());
                            return;
                        }
                        binName = te.getQualifiedName().toString().replace('.', '/');
                        String resourceName = binName + ".class";
                        resource = cp.findResource(resourceName);
                        if (resource == null) {
                            LOG.info("Cannot find resource: " + resourceName + " on classpath: " + cp.toString());
                            return;
                        }
                        root = cp.findOwnerRoot(resource);
                        if (root == null) {
                            LOG.info("Cannot find owner of: " + FileUtil.getFileDisplayName((FileObject)resource) + " on classpath: " + cp.toString());
                            return;
                        }
                        toOpen = te;
                    }
                    classfileRoot[0] = root.getURL();
                    binaryName[0] = binName;
                    File sourceRoot = new File(JavaIndex.getIndex((URL)root.getURL()), "gensrc");
                    FileObject sourceRootFO = FileUtil.createFolder((File)sourceRoot);
                    if (sourceRootFO == null) {
                        LOG.info("Cannot create folder: " + sourceRoot);
                        return;
                    }
                    String path = binName + ".java";
                    FileObject source = sourceRootFO.getFileObject(path);
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    md.update((byte)2);
                    byte[] hashBytes = md.digest(resource.asBytes());
                    StringBuilder hashBuilder = new StringBuilder();
                    for (byte b : hashBytes) {
                        hashBuilder.append(String.format("%02X", b));
                    }
                    String hash = hashBuilder.toString();
                    if (source != null) {
                        result[0] = source;
                        String existingHash = (String)source.getAttribute(CodeGenerator.HASH_ATTRIBUTE_NAME);
                        if (hash.equals(existingHash)) {
                            LOG.fine(FileUtil.getFileDisplayName((FileObject)source) + " is up to date, reusing from cache.");
                            return;
                        }
                    }
                    CompilationUnitTree cut = CodeGenerator.generateCode(wc, toOpen);
                    wc.rewrite((Tree)wc.getCompilationUnit(), (Tree)cut);
                    if (source == null) {
                        result[0] = FileUtil.createData((FileObject)sourceRootFO, (String)path);
                        LOG.fine(FileUtil.getFileDisplayName((FileObject)result[0]) + " does not exist, creating.");
                    } else {
                        LOG.fine(FileUtil.getFileDisplayName((FileObject)source) + " is not up to date, regenerating.");
                    }
                    result[0].setAttribute(CodeGenerator.HASH_ATTRIBUTE_NAME, (Object)hash);
                    sourceGenerated[0] = true;
                }
            });
            if (sourceGenerated[0]) {
                File resultFile = FileUtil.toFile((FileObject)result[0]);
                if (resultFile != null && !resultFile.canWrite()) {
                    resultFile.setWritable(true);
                }
                out = result[0].getOutputStream();
                try {
                    FileUtil.copy((InputStream)new ByteArrayInputStream(r.getResultingSource(file).getBytes("UTF-8")), (OutputStream)out);
                }
                finally {
                    out.close();
                }
                if (resultFile != null) {
                    resultFile.setReadOnly();
                    result[0].setAttribute(DISABLE_ERRORS, (Object)true);
                    result[0].setAttribute(CLASSFILE_ROOT, (Object)classfileRoot[0]);
                    result[0].setAttribute(CLASSFILE_BINNAME, (Object)binaryName[0]);
                }
            }
            return result[0];
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    static CompilationUnitTree generateCode(WorkingCopy wc, Element te) {
        TreeMaker make = wc.getTreeMaker();
        Tree clazz = (Tree)new TreeBuilder(make, wc).visit(te);
        CompilationUnitTree cut = make.CompilationUnit((ExpressionTree)(te.getKind() == ElementKind.MODULE ? null : make.Identifier((CharSequence)((PackageElement)te.getEnclosingElement()).getQualifiedName())), Collections.emptyList(), Collections.singletonList(clazz), wc.getCompilationUnit().getSourceFile());
        return cut;
    }

    private CodeGenerator() {
    }

    static {
        IMPLICIT_MODIFIERS.put(Arrays.asList(ElementKind.ENUM), EnumSet.of(Modifier.STATIC, Modifier.ABSTRACT, Modifier.FINAL));
        IMPLICIT_MODIFIERS.put(Arrays.asList(ElementKind.ANNOTATION_TYPE), EnumSet.of(Modifier.STATIC, Modifier.ABSTRACT));
        IMPLICIT_MODIFIERS.put(Arrays.asList(ElementKind.METHOD, ElementKind.ANNOTATION_TYPE), EnumSet.of(Modifier.ABSTRACT));
        IMPLICIT_MODIFIERS.put(Arrays.asList(ElementKind.METHOD, ElementKind.INTERFACE), EnumSet.of(Modifier.ABSTRACT));
    }

    private static final class ConvenientCodeWriter
    extends CodeWriter {
        private final ConstantWriter constantWriter;
        private static final Set<Opcode> INSTRUCTION_WITH_REFERENCE = EnumSet.of(Opcode.LDC, new Opcode[]{Opcode.LDC_W, Opcode.LDC2_W, Opcode.GETSTATIC, Opcode.PUTSTATIC, Opcode.GETFIELD, Opcode.PUTFIELD, Opcode.INVOKEVIRTUAL, Opcode.INVOKESPECIAL, Opcode.INVOKESTATIC, Opcode.INVOKEINTERFACE, Opcode.NEW, Opcode.ANEWARRAY, Opcode.CHECKCAST, Opcode.INSTANCEOF});

        public ConvenientCodeWriter(com.sun.tools.javap.Context context) {
            super(context);
            this.constantWriter = ConstantWriter.instance(context);
        }

        @Override
        public void writeInstr(Instruction instr) {
            super.writeInstr(instr);
        }
    }

    private static final class TreeBuilder
    extends AbstractElementVisitor9<Tree, Void> {
        private final TreeMaker make;
        private final WorkingCopy wc;
        private ClassFile cf;
        private Map<String, Method> sig2Method;

        public TreeBuilder(TreeMaker make, WorkingCopy wc) {
            this.make = make;
            this.wc = wc;
        }

        @Override
        public Tree visitPackage(PackageElement e, Void p) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public Tree visitModule(ModuleElement e, Void p) {
            ModifiersTree mods = this.make.Modifiers(e.getModifiers());
            ModuleTree.ModuleKind kind = this.wc.getElementUtilities().isOpen(e) ? ModuleTree.ModuleKind.OPEN : ModuleTree.ModuleKind.STRONG;
            LinkedList<DirectiveTree> directives = new LinkedList<DirectiveTree>();
            for (ModuleElement.Directive directive : e.getDirectives()) {
                switch (directive.getKind()) {
                    case EXPORTS: {
                        ModuleElement.ExportsDirective expDirective = (ModuleElement.ExportsDirective)directive;
                        directives.add(this.make.Exports(this.make.QualIdent((Element)expDirective.getPackage()), this.constructModuleList(expDirective.getTargetModules())));
                        break;
                    }
                    case OPENS: {
                        ModuleElement.OpensDirective opensDirective = (ModuleElement.OpensDirective)directive;
                        directives.add(this.make.Opens(this.make.QualIdent((Element)opensDirective.getPackage()), this.constructModuleList(opensDirective.getTargetModules())));
                        break;
                    }
                    case PROVIDES: {
                        ModuleElement.ProvidesDirective provDirective = (ModuleElement.ProvidesDirective)directive;
                        directives.add(this.make.Provides(this.make.QualIdent((Element)provDirective.getService()), this.constructTypeList(provDirective.getImplementations())));
                        break;
                    }
                    case REQUIRES: {
                        ModuleElement.RequiresDirective reqDirective = (ModuleElement.RequiresDirective)directive;
                        directives.add(this.make.Requires(reqDirective.isTransitive(), reqDirective.isStatic(), this.make.QualIdent(reqDirective.getDependency().getQualifiedName().toString())));
                        break;
                    }
                    case USES: {
                        ModuleElement.UsesDirective usesDirective = (ModuleElement.UsesDirective)directive;
                        directives.add(this.make.Uses(this.make.QualIdent((Element)usesDirective.getService())));
                    }
                }
            }
            return this.addDeprecated(e, this.make.Module(mods, kind, this.make.QualIdent(e.getQualifiedName().toString()), directives));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Tree visitType(TypeElement e, Void p) {
            ClassFile oldCf = this.cf;
            Map<String, Method> oldMethods = this.sig2Method;
            this.cf = null;
            this.sig2Method = new HashMap<String, Method>();
            try {
                block21: {
                    try {
                        JavaFileObject classfile = ((Symbol.ClassSymbol)e).classfile;
                        if (classfile == null || classfile.getKind() != JavaFileObject.Kind.CLASS) break block21;
                        try (InputStream in = classfile.openInputStream();){
                            this.cf = ClassFile.read(in);
                            for (Method m : this.cf.methods) {
                                this.sig2Method.put(this.cf.constant_pool.getUTF8Value(m.name_index) + ":" + this.cf.constant_pool.getUTF8Value(m.descriptor.index), m);
                            }
                        }
                    }
                    catch (ConstantPoolException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                LinkedList<Tree> members = new LinkedList<Tree>();
                for (Element element : e.getEnclosedElements()) {
                    Tree member = (Tree)this.visit(element);
                    if (member == null) continue;
                    members.add(member);
                }
                ModifiersTree mods = this.computeMods(e);
                switch (e.getKind()) {
                    case CLASS: {
                        ClassTree classTree = this.addDeprecated(e, this.make.Class(mods, (CharSequence)e.getSimpleName(), this.constructTypeParams(e.getTypeParameters()), this.computeSuper(e.getSuperclass()), this.computeSuper(e.getInterfaces()), members));
                        return classTree;
                    }
                    case INTERFACE: {
                        ClassTree classTree = this.addDeprecated(e, this.make.Interface(mods, (CharSequence)e.getSimpleName(), this.constructTypeParams(e.getTypeParameters()), this.computeSuper(e.getInterfaces()), members));
                        return classTree;
                    }
                    case ENUM: {
                        ClassTree classTree = this.addDeprecated(e, this.make.Enum(mods, (CharSequence)e.getSimpleName(), this.computeSuper(e.getInterfaces()), members));
                        return classTree;
                    }
                    case ANNOTATION_TYPE: {
                        ClassTree classTree = this.addDeprecated(e, this.make.AnnotationType(mods, (CharSequence)e.getSimpleName(), members));
                        return classTree;
                    }
                }
                throw new UnsupportedOperationException();
            }
            finally {
                this.cf = oldCf;
                this.sig2Method = oldMethods;
            }
        }

        private ModifiersTree computeMods(Element e) {
            Set implicitModifiers = (Set)IMPLICIT_MODIFIERS.get(Arrays.asList(e.getKind()));
            if (implicitModifiers == null) {
                implicitModifiers = (Set)IMPLICIT_MODIFIERS.get(Arrays.asList(e.getKind(), e.getEnclosingElement().getKind()));
            }
            EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
            modifiers.addAll(e.getModifiers());
            if (implicitModifiers != null) {
                modifiers.removeAll(implicitModifiers);
            }
            LinkedList<AnnotationTree> annotations = new LinkedList<AnnotationTree>();
            for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
                annotations.add(this.computeAnnotationTree(annotationMirror));
            }
            return this.make.Modifiers(modifiers, annotations);
        }

        private <T extends Tree> T addDeprecated(Element e, T orig) {
            if (this.wc.getElements().isDeprecated(e)) {
                // empty if block
            }
            return orig;
        }

        private AnnotationTree computeAnnotationTree(AnnotationMirror am) {
            LinkedList<AssignmentTree> params = new LinkedList<AssignmentTree>();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : am.getElementValues().entrySet()) {
                ExpressionTree val = this.createTreeForAnnotationValue(this.make, entry.getValue());
                if (val == null) {
                    LOG.log(Level.WARNING, "Cannot create annotation for: {0}", entry.getValue());
                    continue;
                }
                AssignmentTree vt = this.make.Assignment((ExpressionTree)this.make.Identifier((CharSequence)entry.getKey().getSimpleName()), val);
                params.add(vt);
            }
            return this.make.Annotation(this.make.Type((TypeMirror)am.getAnnotationType()), params);
        }

        private Tree computeSuper(TypeMirror superClass) {
            if (superClass == null) {
                return null;
            }
            if (superClass.getKind() == TypeKind.NONE) {
                return null;
            }
            TypeElement jlObject = this.wc.getElements().getTypeElement("java.lang.Object");
            if (jlObject != null && this.wc.getTypes().isSameType(superClass, jlObject.asType())) {
                return null;
            }
            return this.make.Type(superClass);
        }

        private List<Tree> computeSuper(List<? extends TypeMirror> superTypes) {
            LinkedList<Tree> sup = new LinkedList<Tree>();
            if (superTypes != null) {
                for (TypeMirror typeMirror : superTypes) {
                    sup.add(this.make.Type(typeMirror));
                }
            }
            return sup;
        }

        private List<? extends TypeParameterTree> constructTypeParams(List<? extends TypeParameterElement> params) {
            LinkedList<TypeParameterTree> result = new LinkedList<TypeParameterTree>();
            for (TypeParameterElement typeParameterElement : params) {
                result.add((TypeParameterTree)this.visit(typeParameterElement));
            }
            return result;
        }

        private List<? extends ExpressionTree> constructModuleList(List<? extends ModuleElement> params) {
            LinkedList<ExpressionTree> result = new LinkedList<ExpressionTree>();
            if (params != null) {
                for (ModuleElement moduleElement : params) {
                    result.add(this.make.QualIdent(moduleElement.getQualifiedName().toString()));
                }
            }
            return result;
        }

        private List<? extends ExpressionTree> constructTypeList(List<? extends TypeElement> params) {
            LinkedList<ExpressionTree> result = new LinkedList<ExpressionTree>();
            for (TypeElement typeElement : params) {
                result.add(this.make.QualIdent((Element)typeElement));
            }
            return result;
        }

        @Override
        public Tree visitVariable(VariableElement e, Void p) {
            if (e.getKind() == ElementKind.ENUM_CONSTANT) {
                int mods = 16384;
                ModifiersTree modifiers = this.make.Modifiers((long)mods, Collections.emptyList());
                return this.make.Variable(modifiers, (CharSequence)e.getSimpleName().toString(), (Tree)this.make.Identifier((CharSequence)e.getEnclosingElement().getSimpleName().toString()), null);
            }
            ModifiersTree mods = this.computeMods(e);
            LiteralTree init = e.getConstantValue() != null ? this.make.Literal(e.getConstantValue()) : null;
            return this.addDeprecated(e, this.make.Variable(mods, (CharSequence)e.getSimpleName(), this.make.Type(e.asType()), (ExpressionTree)init));
        }

        @Override
        public Tree visitExecutable(ExecutableElement e, Void p) {
            Attribute code;
            if (e.getKind() == ElementKind.STATIC_INIT || e.getKind() == ElementKind.INSTANCE_INIT) {
                return null;
            }
            if (this.wc.getElementUtilities().isSynthetic((Element)e)) {
                return null;
            }
            if (e.getEnclosingElement().getKind() == ElementKind.ENUM) {
                TypeMirror param;
                if ("values".equals(e.getSimpleName().toString()) && e.getParameters().isEmpty()) {
                    return null;
                }
                if ("valueOf".equals(e.getSimpleName().toString()) && e.getParameters().size() == 1 && (param = e.getParameters().get(0).asType()).getKind() == TypeKind.DECLARED && "java.lang.String".equals(((TypeElement)((DeclaredType)param).asElement()).getQualifiedName().toString())) {
                    return null;
                }
            }
            ModifiersTree mods = this.computeMods(e);
            Tree returnValue = e.getReturnType() != null ? this.make.Type(e.getReturnType()) : null;
            LinkedList<VariableTree> parameters = new LinkedList<VariableTree>();
            for (VariableElement variableElement : e.getParameters()) {
                parameters.add((VariableTree)this.visit(variableElement));
            }
            LinkedList<ExpressionTree> throwsList = new LinkedList<ExpressionTree>();
            for (TypeMirror typeMirror : e.getThrownTypes()) {
                throwsList.add((ExpressionTree)this.make.Type(typeMirror));
            }
            if (e.getModifiers().contains((Object)Modifier.ABSTRACT) || e.getModifiers().contains((Object)Modifier.NATIVE)) {
                ExpressionTree expressionTree = this.createTreeForAnnotationValue(this.make, e.getDefaultValue());
                return this.addDeprecated(e, this.make.Method(mods, (CharSequence)e.getSimpleName(), returnValue, this.constructTypeParams(e.getTypeParameters()), parameters, throwsList, (BlockTree)null, expressionTree));
            }
            MethodTree methodTree = this.make.Method(mods, (CharSequence)e.getSimpleName(), returnValue, this.constructTypeParams(e.getTypeParameters()), parameters, throwsList, "{ }", null);
            String[] stringArray = SourceUtils.getJVMSignature((ElementHandle)ElementHandle.create((Element)e));
            Method m = this.sig2Method.get(stringArray[1] + ":" + stringArray[2]);
            CommentHandlerService handler = CommentHandlerService.instance((Context)JavaSourceAccessor.getINSTANCE().getJavacTask((CompilationInfo)this.wc).getContext());
            CommentSet set = handler.getComments((Tree)methodTree.getBody());
            if (m != null && (code = m.attributes.get("Code")) instanceof Code_attribute) {
                com.sun.tools.javap.Context ctx = new com.sun.tools.javap.Context();
                StringWriter decompiled = new StringWriter();
                PrintWriter w = new PrintWriter(decompiled);
                ctx.put(PrintWriter.class, w);
                ctx.put(Messages.class, new Messages(){

                    @Override
                    public String getMessage(String key, Object ... args) {
                        return "";
                    }

                    @Override
                    public String getMessage(Locale locale, String key, Object ... args) {
                        return "";
                    }
                });
                ctx.put(ClassWriter.class, new ClassWriter(ctx){
                    {
                        super(x0);
                        this.setClassFile(cf);
                    }
                });
                ctx.put(CodeWriter.class, new ConvenientCodeWriter(ctx));
                CodeWriter codeWriter = CodeWriter.instance(ctx);
                codeWriter.writeInstrs((Code_attribute)code);
                codeWriter.writeExceptionTable((Code_attribute)code);
                w.println();
                w.close();
                set.addComment(CommentSet.RelativePosition.INNER, Comment.create((Comment.Style)Comment.Style.LINE, (String)"<editor-fold defaultstate=\"collapsed\" desc=\"Compiled Code\">"));
                set.addComment(CommentSet.RelativePosition.INNER, Comment.create((String)decompiled.toString()));
                set.addComment(CommentSet.RelativePosition.INNER, Comment.create((Comment.Style)Comment.Style.LINE, (String)"</editor-fold>"));
            }
            if (!set.hasComments()) {
                set.addComment(CommentSet.RelativePosition.INNER, Comment.create((Comment.Style)Comment.Style.LINE, (String)"compiled code"));
            }
            return this.addDeprecated(e, methodTree);
        }

        @Override
        public Tree visitTypeParameter(TypeParameterElement e, Void p) {
            LinkedList<ExpressionTree> bounds = new LinkedList<ExpressionTree>();
            for (TypeMirror typeMirror : e.getBounds()) {
                bounds.add((ExpressionTree)this.make.Type(typeMirror));
            }
            return this.make.TypeParameter((CharSequence)e.getSimpleName(), bounds);
        }

        private ExpressionTree createTreeForAnnotationValue(final TreeMaker make, AnnotationValue def) {
            if (def == null) {
                return null;
            }
            return def.accept(new AnnotationValueVisitor<ExpressionTree, Void>(){

                @Override
                public ExpressionTree visit(AnnotationValue av, Void p) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public ExpressionTree visit(AnnotationValue av) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public ExpressionTree visitBoolean(boolean b, Void p) {
                    return make.Literal((Object)b);
                }

                @Override
                public ExpressionTree visitByte(byte b, Void p) {
                    return make.Literal((Object)b);
                }

                @Override
                public ExpressionTree visitChar(char c, Void p) {
                    return make.Literal((Object)Character.valueOf(c));
                }

                @Override
                public ExpressionTree visitDouble(double d, Void p) {
                    return make.Literal((Object)d);
                }

                @Override
                public ExpressionTree visitFloat(float f, Void p) {
                    return make.Literal((Object)Float.valueOf(f));
                }

                @Override
                public ExpressionTree visitInt(int i, Void p) {
                    return make.Literal((Object)i);
                }

                @Override
                public ExpressionTree visitLong(long i, Void p) {
                    return make.Literal((Object)i);
                }

                @Override
                public ExpressionTree visitShort(short s, Void p) {
                    return make.Literal((Object)s);
                }

                @Override
                public ExpressionTree visitString(String s, Void p) {
                    return make.Literal((Object)s);
                }

                @Override
                public ExpressionTree visitType(TypeMirror t, Void p) {
                    return make.MemberSelect((ExpressionTree)make.Type(t), (CharSequence)"class");
                }

                @Override
                public ExpressionTree visitEnumConstant(VariableElement c, Void p) {
                    return make.QualIdent((Element)c);
                }

                @Override
                public ExpressionTree visitAnnotation(AnnotationMirror a, Void p) {
                    return this.computeAnnotationTree(a);
                }

                @Override
                public ExpressionTree visitArray(List<? extends AnnotationValue> vals, Void p) {
                    LinkedList<ExpressionTree> values = new LinkedList<ExpressionTree>();
                    for (AnnotationValue annotationValue : vals) {
                        ExpressionTree val = this.createTreeForAnnotationValue(make, annotationValue);
                        if (val == null) {
                            LOG.log(Level.WARNING, "Cannot create annotation for: {0}", annotationValue);
                            continue;
                        }
                        values.add(val);
                    }
                    return make.NewArray(null, Collections.emptyList(), values);
                }

                @Override
                public ExpressionTree visitUnknown(AnnotationValue av, Void p) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            }, null);
        }
    }
}

