/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.AnnotationProcessingQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.BuildArtifactMapper;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.queries.FileBuiltQuery;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.java.preprocessorbridge.api.CompileOnSaveActionQuery;
import org.netbeans.modules.java.preprocessorbridge.spi.CompileOnSaveAction;
import org.netbeans.modules.java.source.NoJavacHelper;
import org.netbeans.modules.java.source.indexing.COSSynchronizingIndexer;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.usages.fcs.FileChangeSupport;
import org.netbeans.modules.java.source.usages.fcs.FileChangeSupportEvent;
import org.netbeans.modules.java.source.usages.fcs.FileChangeSupportListener;
import org.netbeans.modules.java.ui.UIProvider;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.modules.parsing.spi.indexing.ErrorsCache;
import org.netbeans.spi.queries.FileBuiltQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;

public class BuildArtifactMapperImpl {
    private static final String DIRTY_ROOT = "dirty";
    private static final Logger LOG = Logger.getLogger(BuildArtifactMapperImpl.class.getName());
    private static final String TAG_FILE_NAME = ".netbeans_automatic_build";
    private static final String TAG_UPDATE_RESOURCES = ".netbeans_update_resources";
    private static final String SIG = ".sig";
    private static final Map<URL, Set<BuildArtifactMapper.ArtifactsUpdated>> source2Listener = new HashMap<URL, Set<BuildArtifactMapper.ArtifactsUpdated>>();
    private static final boolean COMPARE_TIMESTAMPS = Boolean.getBoolean(BuildArtifactMapperImpl.class.getName() + ".COMPARE_TIMESTAMPS");
    private static final Set<Object> alreadyWarned = new WeakSet();
    private static final Pattern RELATIVE_SLASH_SEPARATED_PATH = Pattern.compile("[^:/\\\\.][^:/\\\\]*(/[^:/\\\\.][^:/\\\\]*)*");

    public static synchronized void addArtifactsUpdatedListener(URL sourceRoot, BuildArtifactMapper.ArtifactsUpdated listener) {
        Set<BuildArtifactMapper.ArtifactsUpdated> listeners = source2Listener.get(sourceRoot);
        if (listeners == null) {
            listeners = new HashSet<BuildArtifactMapper.ArtifactsUpdated>();
            source2Listener.put(sourceRoot, listeners);
        }
        listeners.add(listener);
    }

    public static synchronized void removeArtifactsUpdatedListener(URL sourceRoot, BuildArtifactMapper.ArtifactsUpdated listener) {
        Set<BuildArtifactMapper.ArtifactsUpdated> listeners = source2Listener.get(sourceRoot);
        if (listeners == null) {
            return;
        }
        listeners.remove(listener);
        if (listeners.isEmpty()) {
            source2Listener.remove(sourceRoot);
        }
    }

    private static boolean protectAgainstErrors(URL targetFolder, FileObject[][] sources, Object context) throws MalformedURLException {
        Preferences pref = NbPreferences.forModule(BuildArtifactMapperImpl.class).node(BuildArtifactMapperImpl.class.getSimpleName());
        if (!pref.getBoolean("askBeforeRunWithErrors", true)) {
            return true;
        }
        BuildArtifactMapperImpl.sources(targetFolder, sources);
        for (FileObject file : sources[0]) {
            if (!ErrorsCache.isInError((FileObject)file, (boolean)true) || alreadyWarned.contains(context)) continue;
            UIProvider uip = (UIProvider)Lookup.getDefault().lookup(UIProvider.class);
            if (uip == null || uip.warnContainsErrors(pref)) {
                alreadyWarned.add(context);
                return true;
            }
            return false;
        }
        return true;
    }

    private static void sources(URL targetFolder, FileObject[][] sources) throws MalformedURLException {
        if (sources[0] == null) {
            sources[0] = SourceForBinaryQuery.findSourceRoots((URL)targetFolder).getRoots();
        }
    }

    public static Boolean ensureBuilt(URL sourceRoot, Object context, boolean copyResources, boolean keepResourceUpToDate) throws IOException {
        CompileOnSaveAction a = CompileOnSaveActionQuery.getAction((URL)sourceRoot);
        if (a != null) {
            CompileOnSaveAction.Context ctx = CompileOnSaveAction.Context.sync((URL)sourceRoot, (boolean)copyResources, (boolean)keepResourceUpToDate, (Object)context);
            return a.performAction(ctx);
        }
        return null;
    }

    public static Boolean clean(URL sourceRoot) throws IOException {
        CompileOnSaveAction a = CompileOnSaveActionQuery.getAction((URL)sourceRoot);
        if (a != null) {
            CompileOnSaveAction.Context ctx = CompileOnSaveAction.Context.clean((URL)sourceRoot);
            return a.performAction(ctx);
        }
        return null;
    }

    public static boolean isUpdateClasses(URL sourceRoot) {
        CompileOnSaveAction a = CompileOnSaveActionQuery.getAction((URL)sourceRoot);
        return a != null ? a.isUpdateClasses() : false;
    }

    public static boolean isUpdateResources(URL srcRoot) {
        CompileOnSaveAction a = CompileOnSaveActionQuery.getAction((URL)srcRoot);
        return a != null ? a.isUpdateResources() : false;
    }

    public static void classCacheUpdated(URL sourceRoot, File cacheRoot, Iterable<File> deleted, Iterable<File> updated, boolean resource, boolean isAllFilesIndexing) {
        CompileOnSaveAction a = CompileOnSaveActionQuery.getAction((URL)sourceRoot);
        if (a != null) {
            try {
                CompileOnSaveAction.Context ctx = CompileOnSaveAction.Context.update((URL)sourceRoot, (boolean)resource, (boolean)isAllFilesIndexing, (File)cacheRoot, updated, deleted, updatedFiles -> BuildArtifactMapperImpl.fire(sourceRoot, updatedFiles));
                a.performAction(ctx);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void fire(@NonNull URL sourceRoot, @NonNull Iterable<File> updatedFiles) {
        if (!updatedFiles.iterator().hasNext()) return;
        Class<BuildArtifactMapperImpl> clazz = BuildArtifactMapperImpl.class;
        synchronized (BuildArtifactMapperImpl.class) {
            Set<BuildArtifactMapper.ArtifactsUpdated> listeners = source2Listener.get(sourceRoot);
            if (listeners != null) {
                listeners = new HashSet<BuildArtifactMapper.ArtifactsUpdated>(listeners);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (listeners == null) return;
            for (BuildArtifactMapper.ArtifactsUpdated listener : listeners) {
                listener.artifactsUpdated(updatedFiles);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyFile(File updatedFile, File target, URL sourceFile) throws IOException {
        File parent = target.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Cannot create folder: " + parent.getAbsolutePath());
        }
        if (BuildArtifactMapperImpl.targetNewerThanSourceFile(target, sourceFile)) {
            LOG.log(Level.FINER, "#227791: declining to overwrite {0} with {1}", new Object[]{target, updatedFile});
            return false;
        }
        LOG.log(Level.FINER, "#227791: proceeding to overwrite {0} with {1}", new Object[]{target, updatedFile});
        FileInputStream ins = null;
        OutputStream out = null;
        try {
            ins = new FileInputStream(updatedFile);
            out = new FileOutputStream(target);
            FileUtil.copy((InputStream)ins, (OutputStream)out);
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fnf) {
            LOG.log(Level.INFO, "Cannot open file.", fnf);
            boolean bl = false;
            return bl;
        }
        finally {
            if (ins != null) {
                try {
                    ((InputStream)ins).close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(FileObject updatedFile, File target) throws IOException {
        File parent = target.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Cannot create folder: " + parent.getAbsolutePath());
        }
        InputStream ins = null;
        FileOutputStream out = null;
        try {
            ins = updatedFile.getInputStream();
            out = new FileOutputStream(target);
            FileUtil.copy((InputStream)ins, (OutputStream)out);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private static void copyRecursively(File source, File target, URL sourceURL) throws IOException {
        if (target.exists() && !target.isDirectory()) {
            throw new IOException("Cannot create folder: " + target.getAbsolutePath() + ", already exists as a file.");
        }
        File[] listed = source.listFiles();
        if (listed == null) {
            return;
        }
        for (File f : listed) {
            String name = f.getName();
            if (name.endsWith(SIG)) {
                name = name.substring(0, name.length() - "sig".length()) + "class";
            }
            File newTarget = new File(target, name);
            if (f.isDirectory()) {
                BuildArtifactMapperImpl.copyRecursively(f, newTarget, new URL(sourceURL, name + '/'));
                continue;
            }
            if (newTarget.isDirectory()) {
                throw new IOException("Cannot create file: " + newTarget.getAbsolutePath() + ", already exists as a folder.");
            }
            BuildArtifactMapperImpl.copyFile(f, newTarget, new URL(sourceURL, name));
        }
    }

    private static void copyRecursively(FileObject source, File target, Set<String> javaMimeTypes, String[] javaMimeTypesArr) throws IOException {
        if (!VisibilityQuery.getDefault().isVisible(source)) {
            return;
        }
        if (source.isFolder()) {
            FileObject[] listed;
            if (!target.exists()) {
                if (!target.mkdirs()) {
                    throw new IOException("Cannot create folder: " + target.getAbsolutePath());
                }
            } else if (!target.isDirectory()) {
                throw new IOException("Cannot create folder: " + target.getAbsolutePath() + ", already exists as a file.");
            }
            if ((listed = source.getChildren()) == null) {
                return;
            }
            for (FileObject f : listed) {
                if (f.isData() && javaMimeTypes.contains(FileUtil.getMIMEType((FileObject)f, (String[])javaMimeTypesArr))) continue;
                BuildArtifactMapperImpl.copyRecursively(f, new File(target, f.getNameExt()), javaMimeTypes, javaMimeTypesArr);
            }
        } else {
            if (target.isDirectory()) {
                throw new IOException("Cannot create file: " + target.getAbsolutePath() + ", already exists as a folder.");
            }
            BuildArtifactMapperImpl.copyFile(source, target);
        }
    }

    private static void delete(File file, boolean cleanCompletely) throws IOException {
        if (file.isDirectory()) {
            File[] listed = file.listFiles();
            if (listed == null) {
                return;
            }
            for (File f : listed) {
                BuildArtifactMapperImpl.delete(f, cleanCompletely);
            }
            if (cleanCompletely) {
                file.delete();
            }
        } else if (cleanCompletely || file.getName().endsWith(".class")) {
            file.delete();
        }
    }

    public static File resolveFile(File basedir, String filename) throws IllegalArgumentException {
        File f;
        if (basedir == null) {
            throw new NullPointerException("null basedir passed to resolveFile");
        }
        if (filename == null) {
            throw new NullPointerException("null filename passed to resolveFile");
        }
        if (!basedir.isAbsolute()) {
            throw new IllegalArgumentException("nonabsolute basedir passed to resolveFile: " + basedir);
        }
        if (filename.endsWith(SIG)) {
            filename = filename.substring(0, filename.length() - "sig".length()) + "class";
        }
        if (RELATIVE_SLASH_SEPARATED_PATH.matcher(filename).matches()) {
            f = new File(basedir, filename.replace('/', File.separatorChar));
        } else {
            String machinePath = filename.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            f = new File(machinePath);
            if (!f.isAbsolute()) {
                f = new File(basedir, machinePath);
            }
            assert (f.isAbsolute());
        }
        return f;
    }

    public static String relativizeFile(File basedir, File file) {
        if (basedir.isFile()) {
            throw new IllegalArgumentException("Cannot relative w.r.t. a data file " + basedir);
        }
        if (basedir.equals(file)) {
            return ".";
        }
        StringBuffer b = new StringBuffer();
        File base = basedir;
        String filepath = file.getAbsolutePath();
        while (!filepath.startsWith(BuildArtifactMapperImpl.slashify(base.getAbsolutePath()))) {
            if ((base = base.getParentFile()) == null) {
                return null;
            }
            if (base.equals(file)) {
                b.append("..");
                return b.toString();
            }
            b.append("../");
        }
        URI u = BaseUtilities.toURI((File)base).relativize(BaseUtilities.toURI((File)file));
        assert (!u.isAbsolute()) : u + " from " + basedir + " and " + file + " with common root " + base;
        b.append(u.getPath());
        if (b.charAt(b.length() - 1) == '/') {
            b.setLength(b.length() - 1);
        }
        return b.toString();
    }

    private static String slashify(String path) {
        if (path.endsWith(File.separator)) {
            return path;
        }
        return path + File.separatorChar;
    }

    public static boolean isCompileOnSaveSupported() {
        return NoJavacHelper.hasNbJavac();
    }

    private static boolean targetNewerThanSourceFile(File target, URL approximateSource) {
        File mockSrc;
        if (!COMPARE_TIMESTAMPS) {
            LOG.finest("#227791: timestamp comparison disabled");
            return false;
        }
        if (!"file".equals(approximateSource.getProtocol())) {
            LOG.log(Level.FINER, "#227791: ignoring non-file-based source {0}", approximateSource);
            return false;
        }
        if (!target.isFile()) {
            LOG.log(Level.FINER, "#227791: {0} does not even exist", target);
            return false;
        }
        long targetLastMod = target.lastModified();
        try {
            mockSrc = BaseUtilities.toFile((URI)approximateSource.toURI());
        }
        catch (URISyntaxException x) {
            LOG.log(Level.FINER, "#227791: cannot convert " + approximateSource, x);
            return false;
        }
        File src = new File(mockSrc.getParentFile(), mockSrc.getName().replaceFirst("([$].+)*[.]sig$", ".java"));
        if (!src.isFile()) {
            LOG.log(Level.FINER, "#227791: could not locate estimated source file {0}", src);
            return false;
        }
        long sourceLastMod = src.lastModified();
        if (targetLastMod > sourceLastMod) {
            LOG.log(Level.FINE, "#227791: skipping delete/overwrite since {0} @{1,time,yyyy-MM-dd'T'HH:mm:ssZ} is newer than {2} @{3,time,yyyy-MM-dd'T'HH:mm:ssZ}", new Object[]{target, targetLastMod, src, sourceLastMod});
            return true;
        }
        LOG.log(Level.FINER, "#227791: {0} @{1,time,yyyy-MM-dd'T'HH:mm:ssZ} is older than {2} @{3,time,yyyy-MM-dd'T'HH:mm:ssZ}", new Object[]{target, targetLastMod, src, sourceLastMod});
        return false;
    }

    public static final class Provider
    implements CompileOnSaveAction.Provider {
        private final Map<URL, Reference<DefaultCompileOnSaveAction>> normCache = new WeakHashMap<URL, Reference<DefaultCompileOnSaveAction>>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompileOnSaveAction forRoot(@NonNull URL root) {
            Map<URL, Reference<DefaultCompileOnSaveAction>> map = this.normCache;
            synchronized (map) {
                DefaultCompileOnSaveAction res;
                Reference<DefaultCompileOnSaveAction> ref = this.normCache.get(root);
                if (ref == null || (res = ref.get()) == null) {
                    res = new DefaultCompileOnSaveAction(root);
                    this.normCache.put(root, new WeakReference<DefaultCompileOnSaveAction>(res));
                }
                return res;
            }
        }
    }

    private static final class DefaultCompileOnSaveAction
    implements CompileOnSaveAction,
    ChangeListener {
        private static Map<File, Reference<FileChangeListenerImpl>> file2Listener = new WeakHashMap<File, Reference<FileChangeListenerImpl>>();
        private static Map<FileChangeListenerImpl, File> listener2File = new WeakHashMap<FileChangeListenerImpl, File>();
        private final URL root;
        private final ChangeSupport cs;
        private FileChangeListenerImpl listenerDelegate;

        DefaultCompileOnSaveAction(@NonNull URL root) {
            this.root = root;
            this.cs = new ChangeSupport((Object)this);
        }

        public boolean isEnabled() {
            return true;
        }

        public boolean isUpdateClasses() {
            return this.isUpdateClasses(CompileOnSaveAction.Context.getTarget((URL)this.root));
        }

        public boolean isUpdateResources() {
            return this.isUpdateResources(CompileOnSaveAction.Context.getTarget((URL)this.root));
        }

        public Boolean performAction(@NonNull CompileOnSaveAction.Context ctx) throws IOException {
            assert (this.root.equals(ctx.getSourceRoot()));
            switch (ctx.getOperation()) {
                case CLEAN: {
                    return this.performClean(ctx);
                }
                case SYNC: {
                    return this.performSync(ctx);
                }
                case UPDATE: {
                    return this.performUpdate(ctx);
                }
            }
            throw new IllegalArgumentException(String.valueOf(ctx.getOperation()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(@NonNull ChangeListener listener) {
            File target = CompileOnSaveAction.Context.getTarget((URL)this.root);
            File tagFile = FileUtil.normalizeFile((File)new File(target, BuildArtifactMapperImpl.TAG_FILE_NAME));
            Map<File, Reference<FileChangeListenerImpl>> map = file2Listener;
            synchronized (map) {
                if (this.listenerDelegate == null) {
                    FileChangeListenerImpl l;
                    Reference<FileChangeListenerImpl> ref = file2Listener.get(tagFile);
                    FileChangeListenerImpl fileChangeListenerImpl = l = ref != null ? ref.get() : null;
                    if (l == null) {
                        l = new FileChangeListenerImpl();
                        file2Listener.put(tagFile, new WeakReference<FileChangeListenerImpl>(l));
                        listener2File.put(l, tagFile);
                        FileChangeSupport.DEFAULT.addListener(l, tagFile);
                    }
                    this.listenerDelegate = l;
                    this.listenerDelegate.addListener(this);
                }
            }
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(@NonNull ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }

        @Override
        public void stateChanged(@NonNull ChangeEvent e) {
            this.cs.fireChange();
        }

        private Boolean performClean(@NonNull CompileOnSaveAction.Context ctx) throws IOException {
            File targetFolder = ctx.getTarget();
            if (targetFolder == null) {
                return null;
            }
            File tagFile = new File(targetFolder, BuildArtifactMapperImpl.TAG_FILE_NAME);
            if (!tagFile.exists()) {
                return null;
            }
            try {
                SourceUtils.waitScanFinished();
            }
            catch (InterruptedException e) {
                LOG.log(Level.FINE, null, e);
                return false;
            }
            BuildArtifactMapperImpl.delete(targetFolder, false);
            BuildArtifactMapperImpl.delete(tagFile, true);
            return null;
        }

        private Boolean performSync(@NonNull CompileOnSaveAction.Context ctx) throws IOException {
            URL sourceRoot = ctx.getSourceRoot();
            URL targetFolderURL = ctx.getTargetURL();
            boolean copyResources = ctx.isCopyResources();
            boolean keepResourceUpToDate = ctx.isKeepResourcesUpToDate();
            Object context = ctx.getOwner();
            if (targetFolderURL == null) {
                return null;
            }
            File targetFolder = FileUtil.archiveOrDirForURL((URL)targetFolderURL);
            if (targetFolder == null) {
                return null;
            }
            try {
                SourceUtils.waitScanFinished();
            }
            catch (InterruptedException e) {
                LOG.log(Level.FINE, null, e);
                return null;
            }
            if (JavaIndex.ensureAttributeValue(sourceRoot, BuildArtifactMapperImpl.DIRTY_ROOT, null)) {
                IndexingManager.getDefault().refreshIndexAndWait(sourceRoot, null);
            }
            if (JavaIndex.getAttribute(sourceRoot, BuildArtifactMapperImpl.DIRTY_ROOT, null) != null) {
                return false;
            }
            FileObject[][] sources = new FileObject[1][];
            if (!BuildArtifactMapperImpl.protectAgainstErrors(targetFolderURL, sources, context)) {
                return false;
            }
            File tagFile = new File(targetFolder, BuildArtifactMapperImpl.TAG_FILE_NAME);
            File tagUpdateResourcesFile = new File(targetFolder, BuildArtifactMapperImpl.TAG_UPDATE_RESOURCES);
            boolean forceResourceCopy = copyResources && keepResourceUpToDate && !tagUpdateResourcesFile.exists();
            boolean cosActive = tagFile.exists();
            if (cosActive && !forceResourceCopy) {
                return true;
            }
            if (!cosActive) {
                BuildArtifactMapperImpl.delete(targetFolder, false);
            }
            if (!targetFolder.exists() && !targetFolder.mkdirs()) {
                throw new IOException("Cannot create destination folder: " + targetFolder.getAbsolutePath());
            }
            BuildArtifactMapperImpl.sources(targetFolderURL, sources);
            for (int i = sources[0].length - 1; i >= 0; --i) {
                FileObject sr = sources[0][i];
                if (!cosActive) {
                    URL srURL = sr.toURL();
                    File index = JavaIndex.getClassFolder(srURL, true);
                    if (index == null) {
                        if (srURL.equals(AnnotationProcessingQuery.getAnnotationProcessingOptions((FileObject)sr).sourceOutputDirectory())) continue;
                        return null;
                    }
                    LOG.log(Level.FINER, "#227791: copying {0} to {1} given sources in {2}", new Object[]{index, targetFolder, srURL});
                    BuildArtifactMapperImpl.copyRecursively(index, targetFolder, srURL);
                }
                if (!copyResources) continue;
                Set<String> javaMimeTypes = COSSynchronizingIndexer.gatherJavaMimeTypes();
                String[] javaMimeTypesArr = javaMimeTypes.toArray(new String[0]);
                BuildArtifactMapperImpl.copyRecursively(sr, targetFolder, javaMimeTypes, javaMimeTypesArr);
            }
            if (!cosActive) {
                new FileOutputStream(tagFile).close();
            }
            if (keepResourceUpToDate) {
                new FileOutputStream(tagUpdateResourcesFile).close();
            }
            return true;
        }

        private Boolean performUpdate(@NonNull CompileOnSaveAction.Context ctx) throws IOException {
            String relPath;
            Iterable deleted = ctx.getDeleted();
            Iterable updated = ctx.getUpdated();
            boolean resource = ctx.isCopyResources();
            File cacheRoot = ctx.getCacheRoot();
            if (!deleted.iterator().hasNext() && !updated.iterator().hasNext()) {
                return null;
            }
            File targetFolder = ctx.getTarget();
            if (targetFolder == null) {
                return null;
            }
            if (!this.isUpdateClasses(targetFolder)) {
                return null;
            }
            if (resource && !this.isUpdateResources(targetFolder)) {
                return null;
            }
            LinkedList<File> updatedFiles = new LinkedList<File>();
            for (File deletedFile : deleted) {
                relPath = BuildArtifactMapperImpl.relativizeFile(cacheRoot, deletedFile);
                if (relPath == null) {
                    throw new IllegalArgumentException(String.format("Deleted file: %s is not under cache root: %s, (normalized file: %s).", deletedFile.getAbsolutePath(), cacheRoot.getAbsolutePath(), FileUtil.normalizeFile((File)deletedFile).getAbsolutePath()));
                }
                File toDelete = BuildArtifactMapperImpl.resolveFile(targetFolder, relPath);
                if (BuildArtifactMapperImpl.targetNewerThanSourceFile(toDelete, new URL(ctx.getSourceRoot(), relPath))) {
                    LOG.log(Level.FINER, "#227791: declining to delete {0}", toDelete);
                    continue;
                }
                LOG.log(Level.FINER, "#227791: proceeding to delete {0}", toDelete);
                toDelete.delete();
                updatedFiles.add(toDelete);
            }
            for (File updatedFile : updated) {
                relPath = BuildArtifactMapperImpl.relativizeFile(cacheRoot, updatedFile);
                if (relPath == null) {
                    throw new IllegalArgumentException(String.format("Updated file: %s is not under cache root: %s, (normalized file: %s).", updatedFile.getAbsolutePath(), cacheRoot.getAbsolutePath(), FileUtil.normalizeFile((File)updatedFile).getAbsolutePath()));
                }
                File target = BuildArtifactMapperImpl.resolveFile(targetFolder, relPath);
                try {
                    if (!BuildArtifactMapperImpl.copyFile(updatedFile, target, new URL(ctx.getSourceRoot(), relPath))) continue;
                    updatedFiles.add(target);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            ctx.filesUpdated(updatedFiles);
            return true;
        }

        private boolean isUpdateClasses(@NullAllowed File targetFolder) {
            if (targetFolder == null) {
                return false;
            }
            return new File(targetFolder, BuildArtifactMapperImpl.TAG_FILE_NAME).exists();
        }

        private boolean isUpdateResources(@NullAllowed File targetFolder) {
            if (targetFolder == null) {
                return false;
            }
            return new File(targetFolder, BuildArtifactMapperImpl.TAG_UPDATE_RESOURCES).exists();
        }
    }

    private static final class FileChangeListenerImpl
    implements FileChangeSupportListener {
        private RequestProcessor NOTIFY = new RequestProcessor(FileChangeListenerImpl.class.getName());
        private Set<ChangeListener> notify = new WeakSet();

        private FileChangeListenerImpl() {
        }

        @Override
        public void fileCreated(FileChangeSupportEvent event) {
            this.notifyListeners();
        }

        @Override
        public void fileDeleted(FileChangeSupportEvent event) {
            this.notifyListeners();
        }

        @Override
        public void fileModified(FileChangeSupportEvent event) {
            this.notifyListeners();
        }

        private synchronized void addListener(ChangeListener l) {
            this.notify.add(l);
        }

        private synchronized void notifyListeners() {
            final HashSet<ChangeListener> toNotify = new HashSet<ChangeListener>(this.notify);
            this.NOTIFY.post(new Runnable(){

                @Override
                public void run() {
                    for (ChangeListener l : toNotify) {
                        l.stateChanged(null);
                    }
                }
            });
        }
    }

    private static final class FileBuiltQueryStatusImpl
    implements FileBuiltQuery.Status,
    ChangeListener {
        private final FileBuiltQuery.Status delegate;
        private final CompileOnSaveAction action;
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        public FileBuiltQueryStatusImpl(FileBuiltQuery.Status delegate, CompileOnSaveAction action) {
            this.delegate = delegate;
            this.action = action;
            delegate.addChangeListener((ChangeListener)this);
            action.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)action));
        }

        public boolean isBuilt() {
            return this.delegate.isBuilt() || this.action.isUpdateClasses();
        }

        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.cs.fireChange();
        }
    }

    public static final class FileBuildQueryImpl
    implements FileBuiltQueryImplementation {
        private final ThreadLocal<Boolean> recursive = new ThreadLocal();
        private final Map<FileObject, Reference<FileBuiltQuery.Status>> file2Status = new WeakHashMap<FileObject, Reference<FileBuiltQuery.Status>>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileBuiltQuery.Status getStatus(FileObject file) {
            FileBuiltQuery.Status result;
            Reference<FileBuiltQuery.Status> statusRef;
            FileBuildQueryImpl fileBuildQueryImpl = this;
            synchronized (fileBuildQueryImpl) {
                statusRef = this.file2Status.get(file);
            }
            FileBuiltQuery.Status status = result = statusRef != null ? statusRef.get() : null;
            if (result != null) {
                return result;
            }
            if (this.recursive.get() != null) {
                return null;
            }
            this.recursive.set(true);
            try {
                FileObject owner;
                FileBuiltQuery.Status delegate = FileBuiltQuery.getStatus((FileObject)file);
                if (delegate == null) {
                    FileBuiltQuery.Status status2 = null;
                    return status2;
                }
                ClassPath source = ClassPath.getClassPath((FileObject)file, (String)"classpath/source");
                FileObject fileObject = owner = source != null ? source.findOwnerRoot(file) : null;
                if (owner == null) {
                    FileBuiltQuery.Status status3 = delegate;
                    return status3;
                }
                CompileOnSaveAction action = CompileOnSaveActionQuery.getAction((URL)owner.toURL());
                if (action == null) {
                    FileBuiltQuery.Status status4 = delegate;
                    return status4;
                }
                FileBuildQueryImpl fileBuildQueryImpl2 = this;
                synchronized (fileBuildQueryImpl2) {
                    Reference<FileBuiltQuery.Status> prevRef = this.file2Status.get(file);
                    FileBuiltQuery.Status status5 = result = prevRef != null ? prevRef.get() : null;
                    if (result == null) {
                        result = new FileBuiltQueryStatusImpl(delegate, action);
                        this.file2Status.put(file, new WeakReference<FileBuiltQueryStatusImpl>((FileBuiltQueryStatusImpl)result));
                    }
                    FileBuiltQuery.Status status6 = result;
                    return status6;
                }
            }
            finally {
                this.recursive.remove();
            }
        }
    }
}

