/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.project.BrokenReferencesImpl;
import org.netbeans.modules.java.lsp.server.project.BrokenReferencesModel;
import org.netbeans.modules.java.lsp.server.project.Bundle;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.RequestProcessor;

class ProjectAlertPresenter {
    private static final Logger LOG = Logger.getLogger(ProjectAlertPresenter.class.getName());
    static int MAX_PRESENTED_ERRORS = Integer.getInteger(ProjectAlertPresenter.class.getName() + ".maxErrors", 10);
    static int ERRORS_WAKEUP_DELAY = Integer.getInteger(ProjectAlertPresenter.class.getName() + ".errorsWakeUp", 120000);
    static int QUESTION_WAKEUP_DELAY = Integer.getInteger(ProjectAlertPresenter.class.getName() + ".questionWakeUp", 300000);
    private static final RequestProcessor RESOLVE_RP = new RequestProcessor(BrokenReferencesImpl.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(BrokenReferencesImpl.class.getName());
    private static final int WAKEUP_DELAY = 120000;
    private final Project project;
    private final String projectName;
    private final BrokenReferencesModel model;
    private final Env controller;
    private final Set<ProjectProblemsProvider.ProjectProblem> seen = Collections.synchronizedSet(new HashSet());
    final Object restOption = Bundle.ProjectProblems_RestOption();
    final Object detailOption = Bundle.ProjectProblems_DetailsOption();
    final CompletableFuture<Boolean> completion;
    Set<BrokenReferencesModel.ProblemReference> snapshot = Collections.emptySet();
    int runAttempt;
    boolean includeSeen;
    private RequestProcessor.Task wakeUpTask;
    private volatile CancellationException cancelled;
    boolean allProcessed = true;
    ErrorQueue errorQueue = null;

    public ProjectAlertPresenter(Project project, BrokenReferencesModel model, Env master) {
        this.controller = master;
        this.project = project;
        this.model = model;
        ProjectInformation pi = ProjectUtils.getInformation((Project)project);
        String pn = pi.getDisplayName();
        if (pn == null) {
            pn = pi.getName();
        }
        this.projectName = pn;
        LOG.log(Level.FINE, "Initializing alert presenter for {0}", this.projectName);
        this.completion = new CompletableFuture<Boolean>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean r = super.cancel(mayInterruptIfRunning);
                if (r) {
                    ProjectAlertPresenter.this.cancel();
                }
                return r;
            }
        };
        model.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                ProjectAlertPresenter.this.awake();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                ProjectAlertPresenter.this.awake();
            }
        });
    }

    public Project getProject() {
        return this.project;
    }

    public CompletableFuture<Boolean> getCompletion() {
        return this.completion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        ProjectAlertPresenter projectAlertPresenter = this;
        synchronized (projectAlertPresenter) {
            this.cancelled = new CancellationException();
            if (this.wakeUpTask != null) {
                this.wakeUpTask.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resumeAfterTimeout(Ctx ctx) {
        ErrorQueue oq;
        assert (RP.isRequestProcessorThread());
        LOG.log(Level.FINE, "User unresponsive for project {0}, continue", this.projectName);
        ProjectAlertPresenter projectAlertPresenter = this;
        synchronized (projectAlertPresenter) {
            if (!ctx.valid()) {
                return;
            }
            if (this.wakeUpTask != null && !this.wakeUpTask.isFinished()) {
                this.wakeUpTask.cancel();
                this.wakeUpTask = null;
            }
            oq = this.errorQueue;
            this.errorQueue = null;
            ++this.runAttempt;
            ctx = new Ctx(ctx.autoResolve);
        }
        if (oq != null) {
            oq.terminate(true);
        }
        this.processOneRound(ctx);
    }

    private void awake() {
        this.processProject(false);
    }

    Set<ProjectProblemsProvider.ProjectProblem> seenProblems() {
        return new LinkedHashSet<ProjectProblemsProvider.ProjectProblem>(this.seen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanAndProcess(boolean autoResolve) {
        ProjectAlertPresenter projectAlertPresenter = this;
        synchronized (projectAlertPresenter) {
            if (this.wakeUpTask != null) {
                this.wakeUpTask.cancel();
            }
            this.wakeUpTask = null;
            this.snapshot = Collections.emptySet();
        }
        this.processProject(autoResolve);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processProject(boolean autoResolve) {
        Ctx ctx;
        this.model.refresh(false);
        ProjectAlertPresenter projectAlertPresenter = this;
        synchronized (projectAlertPresenter) {
            ArrayList<BrokenReferencesModel.ProblemReference> probs = new ArrayList<BrokenReferencesModel.ProblemReference>();
            List<BrokenReferencesModel.ProblemReference> fatals = this.findProblems(probs);
            LOG.log(Level.FINE, "Processing {0} fatals, {1} resolvables of {2}", new Object[]{fatals.size(), probs.size(), this.projectName});
            if (this.snapshot.containsAll(probs) && this.snapshot.containsAll(fatals) && this.wakeUpTask != null) {
                LOG.log(Level.FINE, "All already seen or being processed, wakeup task available");
                return;
            }
            if (this.seen.containsAll(fatals) && this.wakeUpTask != null) {
                LOG.log(Level.FINE, "Fatals reported, wakeup task available, wait for user or timeout");
                return;
            }
            if (this.wakeUpTask != null && !this.wakeUpTask.isFinished() && !this.wakeUpTask.cancel()) {
                return;
            }
            if (this.cancelled != null) {
                this.finishThis();
                return;
            }
            ++this.runAttempt;
            ctx = new Ctx(autoResolve);
            LOG.log(Level.FINE, "Wakeup cancelled, new presenter run");
        }
        this.processOneRound(ctx);
    }

    private List<BrokenReferencesModel.ProblemReference> findProblems(List<BrokenReferencesModel.ProblemReference> probs) {
        ArrayList<BrokenReferencesModel.ProblemReference> fatals = new ArrayList<BrokenReferencesModel.ProblemReference>();
        for (BrokenReferencesModel.ProblemReference ref : this.model.projectProblems(this.project, this.includeSeen)) {
            if (this.seen.contains(ref.problem) || ref.resolved || ref.seen && !this.includeSeen) continue;
            ProjectProblemsProvider.ProjectProblem pp = ref.problem;
            if (!pp.isResolvable()) {
                fatals.add(ref);
                continue;
            }
            probs.add(ref);
        }
        return fatals;
    }

    void finishThis() {
        this.controller.finishProject(this);
        if (this.cancelled != null && this.completion.completeExceptionally(this.cancelled)) {
            return;
        }
        this.completion.complete(this.allProcessed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processOneRound(Ctx ctx) {
        if (!RP.isRequestProcessorThread()) {
            RP.post(() -> this.processOneRound(ctx));
            return;
        }
        assert (RP.isRequestProcessorThread());
        this.model.refresh(false);
        ArrayList<BrokenReferencesModel.ProblemReference> probs = new ArrayList<BrokenReferencesModel.ProblemReference>();
        List<BrokenReferencesModel.ProblemReference> fatals = this.findProblems(probs);
        ProjectAlertPresenter projectAlertPresenter = this;
        synchronized (projectAlertPresenter) {
            if (!ctx.valid()) {
                return;
            }
            this.wakeUpTask = null;
            this.snapshot = new HashSet<BrokenReferencesModel.ProblemReference>();
            this.snapshot.addAll(probs);
            this.snapshot.addAll(fatals);
        }
        if (probs.isEmpty() && fatals.isEmpty()) {
            LOG.log(Level.FINE, "Project {0} clear, finishing", this.projectName);
            this.finishThis();
            return;
        }
        if (this.cancelled != null) {
            this.finishThis();
            return;
        }
        if (!fatals.isEmpty()) {
            ProjectAlertPresenter projectAlertPresenter2;
            boolean newBatch;
            CompletableFuture f = null;
            do {
                ErrorQueue activeBatch;
                newBatch = false;
                projectAlertPresenter2 = this;
                synchronized (projectAlertPresenter2) {
                    activeBatch = this.errorQueue;
                    if (activeBatch == null) {
                        this.errorQueue = activeBatch = new ErrorQueue(ctx);
                        newBatch = true;
                    }
                }
                f = activeBatch.moreErrors(fatals);
                projectAlertPresenter2 = this;
                synchronized (projectAlertPresenter2) {
                    if (f == null && this.errorQueue == activeBatch) {
                        this.errorQueue = null;
                    }
                }
            } while (f == null);
            if (newBatch) {
                projectAlertPresenter2 = this;
                synchronized (projectAlertPresenter2) {
                    LOG.log(Level.FINE, "Waiting for {0} items, scheduling wakeup task", fatals.size());
                    this.wakeUpTask = RP.create(() -> this.resumeAfterTimeout(ctx));
                    this.wakeUpTask.schedule(ERRORS_WAKEUP_DELAY);
                }
            }
            f.thenAccept(r -> this.continueResetPending(ctx));
            return;
        }
        if (probs.isEmpty()) {
            this.finishThis();
            return;
        }
        BrokenReferencesModel.ProblemReference ref = (BrokenReferencesModel.ProblemReference)probs.iterator().next();
        BiFunction<ProjectProblemsProvider.Result, Throwable, Void> handlerFn = (r, e) -> {
            if (!ctx.valid()) {
                return null;
            }
            if (e instanceof CompletionException) {
                e = e.getCause();
            }
            if (e instanceof CancellationException) {
                this.finishIfNoMoreErrors(ctx, probs);
                return null;
            }
            if (r != null) {
                this.processOneRound(ctx.autoresolve(true));
            } else {
                this.processOneRound(ctx.autoresolve(false));
            }
            return null;
        };
        if (ctx.autoResolve) {
            this.postResolveProblem(ctx, ref).handle(handlerFn);
        } else {
            Object[] objectArray;
            RequestProcessor.Task t;
            this.seen.add(ref.problem);
            if (this.cancelled != null) {
                this.finishThis();
                return;
            }
            ProjectAlertPresenter projectAlertPresenter3 = this;
            synchronized (projectAlertPresenter3) {
                t = this.wakeUpTask == null ? (this.wakeUpTask = RP.post(() -> this.resumeAfterTimeout(ctx), QUESTION_WAKEUP_DELAY)) : null;
            }
            String title = Bundle.ProjectProblems_Fixable_Title(this.projectName, ref.problem.getDisplayName());
            String msg = Utils.html2plain(ref.problem.getDescription());
            if (probs.size() > 1) {
                msg = Bundle.ProjectProblems_Additional(probs.size() - 1, msg);
            }
            if (probs.size() > 1) {
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = NotifyDescriptor.OK_OPTION;
                objectArray2[1] = this.restOption;
                objectArray = objectArray2;
                objectArray2[2] = NotifyDescriptor.CANCEL_OPTION;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = NotifyDescriptor.OK_OPTION;
                objectArray = objectArray3;
                objectArray3[1] = NotifyDescriptor.CANCEL_OPTION;
            }
            Object[] options = objectArray;
            NotifyDescriptor desc = new NotifyDescriptor((Object)(title + ": " + msg), title, -1, 3, options, null);
            ((CompletableFuture)DialogDisplayer.getDefault().notifyFuture(desc).whenComplete((d, ex) -> {
                ProjectAlertPresenter projectAlertPresenter = this;
                synchronized (projectAlertPresenter) {
                    if (t != null && this.wakeUpTask == t) {
                        this.wakeUpTask.cancel();
                        this.wakeUpTask = null;
                    }
                }
                if (this.cancelled != null) {
                    this.finishThis();
                    return;
                }
                Object res = d.getValue();
                if (this.restOption.equals(res)) {
                    ProjectAlertPresenter projectAlertPresenter2 = this;
                    synchronized (projectAlertPresenter2) {
                        if (!ctx.valid()) {
                            this.postResolveProblem(ctx.autoresolve(false), ref).handle(handlerFn);
                            return;
                        }
                        this.seen.remove(ref.problem);
                    }
                    this.processOneRound(ctx.autoresolve(true));
                } else if (res != NotifyDescriptor.OK_OPTION) {
                    handlerFn.apply(null, null);
                } else {
                    this.postResolveProblem(ctx.autoresolve(false), ref).handle(handlerFn);
                }
            })).exceptionally(x -> {
                if (x instanceof CompletionException) {
                    x = x.getCause();
                }
                if (x instanceof CancellationException) {
                    this.finishIfNoMoreErrors(ctx, probs);
                }
                return null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishIfNoMoreErrors(Ctx ctx, Collection<BrokenReferencesModel.ProblemReference> dismiss) {
        ProjectAlertPresenter projectAlertPresenter = this;
        synchronized (projectAlertPresenter) {
            this.allProcessed &= dismiss.isEmpty();
            this.seen.addAll(dismiss.stream().map(r -> r.problem).collect(Collectors.toList()));
        }
        ArrayList<BrokenReferencesModel.ProblemReference> probs = new ArrayList<BrokenReferencesModel.ProblemReference>();
        List<BrokenReferencesModel.ProblemReference> fatals = this.findProblems(probs);
        if (!fatals.isEmpty()) {
            this.processOneRound(ctx);
        } else {
            this.finishThis();
        }
    }

    private CompletableFuture<ProjectProblemsProvider.Result> postResolveProblem(Ctx ctx, BrokenReferencesModel.ProblemReference ref) {
        CompletionStage f = CompletableFuture.supplyAsync(() -> {
            try {
                this.seen.add(ref.problem);
                return (ProjectProblemsProvider.Result)ref.problem.resolve().get();
            }
            catch (ExecutionException ex) {
                return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED, (String)ex.getCause().getLocalizedMessage());
            }
            catch (InterruptedException ex) {
                return null;
            }
        }, (Executor)RESOLVE_RP).thenApply(r -> {
            if (r.isResolved()) {
                if (r.getMessage() != null) {
                    StatusDisplayer.getDefault().setStatusText(Utils.html2plain(r.getMessage()));
                }
                return ctx.autoResolve ? r : null;
            }
            ArrayList<BrokenReferencesModel.ProblemReference> probs = new ArrayList<BrokenReferencesModel.ProblemReference>();
            List<BrokenReferencesModel.ProblemReference> fatals = this.findProblems(probs);
            NotifyDescriptor desc = this.createNotifyDescriptor(ref.problem, (ProjectProblemsProvider.Result)r, probs.size());
            if (fatals.isEmpty() && !probs.isEmpty()) {
                desc.setOptions(new Object[]{this.restOption, this.detailOption, NotifyDescriptor.CANCEL_OPTION});
                desc.setValue(this.detailOption);
            }
            Object v = DialogDisplayer.getDefault().notify(desc);
            if (this.cancelled != null) {
                throw new CancellationException();
            }
            if (v == NotifyDescriptor.CANCEL_OPTION || v == null) {
                throw new CancellationException();
            }
            if (this.restOption.equals(v)) {
                return r;
            }
            return null;
        });
        return f;
    }

    private NotifyDescriptor createNotifyDescriptor(ProjectProblemsProvider.ProjectProblem pp, ProjectProblemsProvider.Result r, int probs) {
        int type;
        Object msg;
        String title;
        String plainMessage = Utils.html2plain(r.getMessage());
        if (r.getStatus() == ProjectProblemsProvider.Status.UNRESOLVED) {
            title = Bundle.ProjectProblems_Resolved_Error(this.projectName);
            msg = Bundle.ProjectProblems_Resolved_ErrorMessage1(pp.getDisplayName(), plainMessage);
            type = 0;
        } else {
            title = Bundle.ProjectProblems_Resolved_Warning(this.projectName);
            msg = Bundle.ProjectProblems_Resolved_WarningMessage1(pp.getDisplayName(), plainMessage);
            type = 2;
        }
        if (probs > 0) {
            msg = Bundle.ProjectProblems_Additional(probs, msg);
        }
        msg = title + ": " + (String)msg;
        NotifyDescriptor desc = new NotifyDescriptor(msg, title, -1, type, new Object[]{NotifyDescriptor.OK_OPTION}, null);
        return desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void continueResetPending(Ctx ctx) {
        LOG.log(Level.FINE, "All dialogs confirmed");
        ProjectAlertPresenter projectAlertPresenter = this;
        synchronized (projectAlertPresenter) {
            if (!ctx.valid()) {
                return;
            }
            if (this.wakeUpTask != null && !this.wakeUpTask.isFinished() && !this.wakeUpTask.cancel()) {
                return;
            }
        }
        this.processOneRound(ctx);
    }

    class ErrorQueue {
        final Ctx ctx;
        final List<BrokenReferencesModel.ProblemReference> toProcess = new ArrayList<BrokenReferencesModel.ProblemReference>();
        final Set<BrokenReferencesModel.ProblemReference> processed = new HashSet<BrokenReferencesModel.ProblemReference>();
        CompletableFuture allDone = new CompletableFuture();
        boolean started;
        int fatalErrorsOnScreen;
        Throwable error;

        public ErrorQueue(Ctx ctx) {
            this.ctx = ctx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runOrDelay(BrokenReferencesModel.ProblemReference p) {
            ErrorQueue errorQueue = this;
            synchronized (errorQueue) {
                if (this.fatalErrorsOnScreen >= MAX_PRESENTED_ERRORS) {
                    return;
                }
                ++this.fatalErrorsOnScreen;
            }
            this.displayError(p);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CompletableFuture moreErrors(List<BrokenReferencesModel.ProblemReference> newErrors) {
            ErrorQueue errorQueue = this;
            synchronized (errorQueue) {
                if (this.started && this.processed.containsAll(this.toProcess)) {
                    return null;
                }
                this.started = true;
                this.toProcess.addAll(newErrors);
            }
            for (BrokenReferencesModel.ProblemReference r : newErrors) {
                this.runOrDelay(r);
            }
            return this.allDone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void terminate(boolean all) {
            Throwable exception;
            ErrorQueue errorQueue = this;
            synchronized (errorQueue) {
                for (BrokenReferencesModel.ProblemReference ref : this.toProcess) {
                    if (!all && ProjectAlertPresenter.this.seen.contains(ref.problem)) continue;
                    this.processed.add(ref);
                }
                if (!this.processed.containsAll(this.toProcess)) {
                    return;
                }
                ProjectAlertPresenter projectAlertPresenter = ProjectAlertPresenter.this;
                synchronized (projectAlertPresenter) {
                    if (this == ProjectAlertPresenter.this.errorQueue) {
                        ProjectAlertPresenter.this.errorQueue = null;
                    }
                }
                exception = this.error;
            }
            if (exception != null) {
                this.allDone.completeExceptionally(exception);
            } else {
                this.allDone.complete(null);
            }
        }

        public void displayError(BrokenReferencesModel.ProblemReference toPresent) {
            ProjectProblemsProvider.ProjectProblem p = toPresent.problem;
            ProjectAlertPresenter.this.seen.add(p);
            LOG.log(Level.FINE, "Reporting fatal {0}", p.getDisplayName());
            int type = switch (p.getSeverity()) {
                default -> 0;
                case ProjectProblemsProvider.Severity.WARNING -> 2;
            };
            String title = Bundle.ProjectProblem_Title(ProjectAlertPresenter.this.projectName, p.getDisplayName());
            NotifyDescriptor msg = new NotifyDescriptor((Object)(title + ": " + Utils.html2plain(p.getDescription())), title, -1, type, new Object[]{NotifyDescriptor.OK_OPTION}, null);
            CompletionStage running = DialogDisplayer.getDefault().notifyFuture(msg).handle((n, e) -> {
                Optional<BrokenReferencesModel.ProblemReference> o;
                int result = 0;
                ErrorQueue errorQueue = this;
                synchronized (errorQueue) {
                    this.processed.add(toPresent);
                    if (!this.ctx.valid() || ProjectAlertPresenter.this.cancelled != null) {
                        return 2;
                    }
                    o = this.toProcess.stream().filter(a -> !ProjectAlertPresenter.this.seen.contains(a.problem)).findFirst();
                    if (!o.isPresent()) {
                        result = 1;
                        if (this.fatalErrorsOnScreen > 0) {
                            --this.fatalErrorsOnScreen;
                        }
                    }
                }
                if (o.isPresent()) {
                    this.displayError(o.get());
                }
                return result;
            });
            ((CompletableFuture)running).whenComplete((t, ex) -> {
                if (t > 0) {
                    this.terminate(t > 1);
                } else {
                    ProjectAlertPresenter projectAlertPresenter = ProjectAlertPresenter.this;
                    synchronized (projectAlertPresenter) {
                        if (ProjectAlertPresenter.this.wakeUpTask != null) {
                            LOG.log(Level.FINER, "Trying to postpone wakeup for {0}ms", 120000);
                            ProjectAlertPresenter.this.wakeUpTask.schedule(ERRORS_WAKEUP_DELAY);
                        }
                    }
                }
            });
        }
    }

    static interface Env {
        public void finishProject(ProjectAlertPresenter var1);

        public boolean isActivePresenter(ProjectAlertPresenter var1);
    }

    final class Ctx {
        final int attempt;
        final boolean autoResolve;

        public Ctx(boolean autoResolve) {
            this(this$0.runAttempt, autoResolve);
        }

        public Ctx(int attempt, boolean autoResolve) {
            this.attempt = attempt;
            this.autoResolve = autoResolve;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean valid() {
            ProjectAlertPresenter projectAlertPresenter = ProjectAlertPresenter.this;
            synchronized (projectAlertPresenter) {
                return this.attempt == ProjectAlertPresenter.this.runAttempt && ProjectAlertPresenter.this.controller.isActivePresenter(ProjectAlertPresenter.this);
            }
        }

        Ctx autoresolve(boolean r) {
            return new Ctx(this.attempt, r);
        }
    }
}

