/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging;

import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.debug.Capabilities;
import org.eclipse.lsp4j.debug.ConfigurationDoneArguments;
import org.eclipse.lsp4j.debug.ContinueArguments;
import org.eclipse.lsp4j.debug.ContinueResponse;
import org.eclipse.lsp4j.debug.DisconnectArguments;
import org.eclipse.lsp4j.debug.EvaluateArguments;
import org.eclipse.lsp4j.debug.EvaluateResponse;
import org.eclipse.lsp4j.debug.ExceptionBreakpointsFilter;
import org.eclipse.lsp4j.debug.ExceptionInfoArguments;
import org.eclipse.lsp4j.debug.ExceptionInfoResponse;
import org.eclipse.lsp4j.debug.InitializeRequestArguments;
import org.eclipse.lsp4j.debug.NextArguments;
import org.eclipse.lsp4j.debug.PauseArguments;
import org.eclipse.lsp4j.debug.Scope;
import org.eclipse.lsp4j.debug.ScopesArguments;
import org.eclipse.lsp4j.debug.ScopesResponse;
import org.eclipse.lsp4j.debug.SetBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetBreakpointsResponse;
import org.eclipse.lsp4j.debug.SetExceptionBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetVariableArguments;
import org.eclipse.lsp4j.debug.SetVariableResponse;
import org.eclipse.lsp4j.debug.Source;
import org.eclipse.lsp4j.debug.SourceArguments;
import org.eclipse.lsp4j.debug.SourceResponse;
import org.eclipse.lsp4j.debug.StackFrame;
import org.eclipse.lsp4j.debug.StackTraceArguments;
import org.eclipse.lsp4j.debug.StackTraceResponse;
import org.eclipse.lsp4j.debug.StepInArguments;
import org.eclipse.lsp4j.debug.StepOutArguments;
import org.eclipse.lsp4j.debug.StoppedEventArguments;
import org.eclipse.lsp4j.debug.Thread;
import org.eclipse.lsp4j.debug.ThreadsResponse;
import org.eclipse.lsp4j.debug.VariablesArguments;
import org.eclipse.lsp4j.debug.VariablesResponse;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.truffle.vars.TruffleVariable;
import org.netbeans.modules.java.lsp.server.debugging.DebugAdapterContext;
import org.netbeans.modules.java.lsp.server.debugging.NbFrame;
import org.netbeans.modules.java.lsp.server.debugging.NbScope;
import org.netbeans.modules.java.lsp.server.debugging.NbSourceProvider;
import org.netbeans.modules.java.lsp.server.debugging.breakpoints.NbBreakpointsRequestHandler;
import org.netbeans.modules.java.lsp.server.debugging.launch.NbDebugSession;
import org.netbeans.modules.java.lsp.server.debugging.launch.NbDisconnectRequestHandler;
import org.netbeans.modules.java.lsp.server.debugging.launch.NbLaunchRequestHandler;
import org.netbeans.modules.java.lsp.server.debugging.utils.ErrorUtilities;
import org.netbeans.modules.java.lsp.server.debugging.variables.NbVariablesRequestHandler;
import org.netbeans.spi.debugger.ui.DebuggingView;

public final class NbProtocolServer
implements IDebugProtocolServer {
    private final DebugAdapterContext context;
    private final NbLaunchRequestHandler launchRequestHandler = new NbLaunchRequestHandler();
    private final NbDisconnectRequestHandler disconnectRequestHandler = new NbDisconnectRequestHandler();
    private final NbBreakpointsRequestHandler breakpointsRequestHandler = new NbBreakpointsRequestHandler();
    private final NbVariablesRequestHandler variablesRequestHandler = new NbVariablesRequestHandler();
    private boolean initialized = false;

    public NbProtocolServer(DebugAdapterContext context) {
        this.context = context;
    }

    public CompletableFuture<Capabilities> initialize(InitializeRequestArguments args) {
        if (!this.initialized) {
            this.initialized = true;
            this.context.getThreadsProvider().initialize(this.context, Collections.emptyMap());
        }
        this.context.setClientLinesStartAt1(args.getLinesStartAt1());
        this.context.setClientColumnsStartAt1(args.getColumnsStartAt1());
        String pathFormat = args.getPathFormat();
        if (pathFormat != null) {
            switch (pathFormat) {
                case "uri": {
                    this.context.setClientPathsAreUri(true);
                    break;
                }
                default: {
                    this.context.setClientPathsAreUri(false);
                }
            }
        }
        this.context.setSupportsRunInTerminalRequest(args.getSupportsRunInTerminalRequest());
        Capabilities caps = new Capabilities();
        caps.setSupportsConfigurationDoneRequest(Boolean.valueOf(true));
        caps.setSupportsHitConditionalBreakpoints(Boolean.valueOf(true));
        caps.setSupportsConditionalBreakpoints(Boolean.valueOf(true));
        caps.setSupportsSetVariable(Boolean.valueOf(true));
        caps.setSupportTerminateDebuggee(Boolean.valueOf(true));
        caps.setSupportsCompletionsRequest(Boolean.valueOf(true));
        caps.setSupportsRestartFrame(Boolean.valueOf(true));
        caps.setSupportsLogPoints(Boolean.valueOf(true));
        caps.setSupportsEvaluateForHovers(Boolean.valueOf(true));
        ExceptionBreakpointsFilter uncaught = new ExceptionBreakpointsFilter();
        uncaught.setFilter("uncaught");
        uncaught.setLabel("Uncaught Exceptions");
        ExceptionBreakpointsFilter caught = new ExceptionBreakpointsFilter();
        caught.setFilter("caught");
        caught.setLabel("Caught Exceptions");
        caps.setExceptionBreakpointFilters(new ExceptionBreakpointsFilter[]{uncaught, caught});
        caps.setSupportsExceptionInfoRequest(Boolean.valueOf(true));
        return CompletableFuture.completedFuture(caps);
    }

    public CompletableFuture<Void> configurationDone(ConfigurationDoneArguments args) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        NbDebugSession debugSession = this.context.getDebugSession();
        if (debugSession != null) {
            this.context.getConfigurationSemaphore().notifyCongigurationDone();
            future.complete(null);
        } else {
            ErrorUtilities.completeExceptionally(future, "Failed to launch debug session, the debugger will exit.", ResponseErrorCode.serverErrorStart);
        }
        return future;
    }

    public CompletableFuture<Void> launch(Map<String, Object> args) {
        return this.launchRequestHandler.launch(args, this.context);
    }

    public CompletableFuture<Void> disconnect(DisconnectArguments args) {
        return this.disconnectRequestHandler.disconnect(args, this.context);
    }

    public CompletableFuture<SetBreakpointsResponse> setBreakpoints(SetBreakpointsArguments args) {
        return this.breakpointsRequestHandler.setBreakpoints(args, this.context);
    }

    public CompletableFuture<Void> setExceptionBreakpoints(SetExceptionBreakpointsArguments args) {
        return this.breakpointsRequestHandler.setExceptionBreakpoints(args, this.context);
    }

    public CompletableFuture<ContinueResponse> continue_(ContinueArguments args) {
        ContinueResponse response = new ContinueResponse();
        if (args.getThreadId() > 0) {
            DebuggingView.DVThread dvThread = this.context.getThreadsProvider().getThread(args.getThreadId());
            if (dvThread != null) {
                dvThread.resume();
                this.context.getThreadsProvider().getThreadObjects().cleanObjects(args.getThreadId());
            }
            response.setAllThreadsContinued(Boolean.valueOf(false));
        } else {
            JPDADebugger debugger = this.context.getDebugSession().getDebugger();
            debugger.getSession().getCurrentEngine().getActionsManager().doAction((Object)"continue");
            this.context.getThreadsProvider().getThreadObjects().cleanAll();
            response.setAllThreadsContinued(Boolean.valueOf(true));
        }
        return CompletableFuture.completedFuture(response);
    }

    public CompletableFuture<Void> next(NextArguments args) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.context.getDebugSession() == null) {
            ErrorUtilities.completeExceptionally(future, "Debug Session doesn't exist.", ResponseErrorCode.InvalidParams);
        } else {
            ActionsManager am = DebuggerManager.getDebuggerManager().getCurrentEngine().getActionsManager();
            am.doAction((Object)"stepOver");
            future.complete(null);
        }
        return future;
    }

    public CompletableFuture<Void> stepIn(StepInArguments args) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.context.getDebugSession() == null) {
            ErrorUtilities.completeExceptionally(future, "Debug Session doesn't exist.", ResponseErrorCode.InvalidParams);
        } else {
            ActionsManager am = DebuggerManager.getDebuggerManager().getCurrentEngine().getActionsManager();
            am.doAction((Object)"stepInto");
            future.complete(null);
        }
        return future;
    }

    public CompletableFuture<Void> stepOut(StepOutArguments args) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.context.getDebugSession() == null) {
            ErrorUtilities.completeExceptionally(future, "Debug Session doesn't exist.", ResponseErrorCode.InvalidParams);
        } else {
            ActionsManager am = DebuggerManager.getDebuggerManager().getCurrentEngine().getActionsManager();
            am.doAction((Object)"stepOut");
            future.complete(null);
        }
        return future;
    }

    public CompletableFuture<Void> pause(PauseArguments args) {
        StoppedEventArguments ev;
        if (args.getThreadId() > 0) {
            DebuggingView.DVThread dvThread = this.context.getThreadsProvider().getThread(args.getThreadId());
            if (dvThread != null) {
                dvThread.suspend();
                ev = new StoppedEventArguments();
                ev.setReason("pause");
                ev.setThreadId(Integer.valueOf(args.getThreadId()));
                ev.setAllThreadsStopped(Boolean.valueOf(false));
            } else {
                ev = null;
            }
        } else {
            JPDADebugger debugger = this.context.getDebugSession().getDebugger();
            debugger.getSession().getCurrentEngine().getActionsManager().doAction((Object)"pause");
            ev = new StoppedEventArguments();
            ev.setReason("pause");
            ev.setThreadId(Integer.valueOf(0));
            ev.setAllThreadsStopped(Boolean.valueOf(true));
        }
        if (ev != null) {
            this.context.getClient().stopped(ev);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<StackTraceResponse> stackTrace(StackTraceArguments args) {
        CompletableFuture<StackTraceResponse> future = new CompletableFuture<StackTraceResponse>();
        if (this.context.getDebugSession() == null) {
            ErrorUtilities.completeExceptionally(future, "Debug Session doesn't exist.", ResponseErrorCode.InvalidParams);
        } else {
            ArrayList<StackFrame> result = new ArrayList<StackFrame>();
            int cnt = 0;
            DebuggingView.DVThread dvThread = this.context.getThreadsProvider().getThread(args.getThreadId());
            if (dvThread != null) {
                cnt = dvThread.getFrameCount();
                int from = args.getStartFrame() != null ? args.getStartFrame() : 0;
                int to = args.getLevels() != null ? from + args.getLevels() : Integer.MAX_VALUE;
                List stackFrames = dvThread.getFrames(from, to);
                for (DebuggingView.DVFrame frame : stackFrames) {
                    int column;
                    int frameId = this.context.getThreadsProvider().getThreadObjects().addObject(args.getThreadId(), new NbFrame(args.getThreadId(), frame));
                    int line = frame.getLine();
                    if (line < 0) {
                        line = 0;
                    }
                    if ((column = frame.getColumn()) < 0) {
                        column = 0;
                    }
                    StackFrame stackFrame = new StackFrame();
                    stackFrame.setId(frameId);
                    stackFrame.setName(frame.getName());
                    URI sourceURI = frame.getSourceURI();
                    if (sourceURI != null && sourceURI.getPath() != null) {
                        Source source = new Source();
                        source.setName(Paths.get(sourceURI).getFileName().toString());
                        source.setPath(sourceURI.getPath());
                        source.setSourceReference(Integer.valueOf(0));
                        stackFrame.setSource(source);
                    }
                    stackFrame.setLine(line);
                    stackFrame.setColumn(column);
                    result.add(stackFrame);
                }
            }
            StackTraceResponse response = new StackTraceResponse();
            response.setStackFrames(result.toArray(new StackFrame[result.size()]));
            response.setTotalFrames(Integer.valueOf(cnt));
            future.complete(response);
        }
        return future;
    }

    public CompletableFuture<ScopesResponse> scopes(ScopesArguments args) {
        ArrayList<Scope> result = new ArrayList<Scope>();
        NbFrame stackFrame = (NbFrame)this.context.getThreadsProvider().getThreadObjects().getObject(args.getFrameId());
        if (stackFrame != null) {
            stackFrame.getDVFrame().makeCurrent();
            NbScope localScope = new NbScope(stackFrame, "Local");
            int localScopeId = this.context.getThreadsProvider().getThreadObjects().addObject(stackFrame.getThreadId(), localScope);
            Scope scope = new Scope();
            scope.setName(localScope.getName());
            scope.setVariablesReference(localScopeId);
            scope.setExpensive(false);
            result.add(scope);
        }
        ScopesResponse response = new ScopesResponse();
        response.setScopes(result.toArray(new Scope[result.size()]));
        return CompletableFuture.completedFuture(response);
    }

    public CompletableFuture<VariablesResponse> variables(VariablesArguments args) {
        return this.variablesRequestHandler.variables(args, this.context);
    }

    public CompletableFuture<SetVariableResponse> setVariable(SetVariableArguments args) {
        return this.variablesRequestHandler.setVariable(args, this.context);
    }

    public CompletableFuture<SourceResponse> source(SourceArguments args) {
        CompletableFuture<SourceResponse> future = new CompletableFuture<SourceResponse>();
        int sourceReference = args.getSourceReference();
        if (sourceReference <= 0) {
            ErrorUtilities.completeExceptionally(future, "SourceRequest: property 'sourceReference' is missing, null, or empty", ResponseErrorCode.InvalidParams);
        } else {
            String uri = this.context.getSourceUri(sourceReference);
            NbSourceProvider sourceProvider = this.context.getSourceProvider();
            SourceResponse response = new SourceResponse();
            response.setMimeType("text/x-java");
            response.setContent(sourceProvider.getSourceContents(uri));
            future.complete(response);
        }
        return future;
    }

    public CompletableFuture<ThreadsResponse> threads() {
        CompletableFuture<ThreadsResponse> future = new CompletableFuture<ThreadsResponse>();
        if (this.context.getDebugSession() == null) {
            ErrorUtilities.completeExceptionally(future, "Debug Session doesn't exist.", ResponseErrorCode.InvalidParams);
        } else {
            ArrayList result = new ArrayList();
            this.context.getThreadsProvider().visitThreads((id, dvThread) -> {
                Thread thread = new Thread();
                thread.setId(id.intValue());
                thread.setName(dvThread.getName());
                result.add(thread);
            });
            ThreadsResponse response = new ThreadsResponse();
            response.setThreads(result.toArray(new Thread[result.size()]));
            future.complete(response);
        }
        return future;
    }

    public CompletableFuture<EvaluateResponse> evaluate(EvaluateArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            Variable variable;
            String expression = args.getExpression();
            if (StringUtils.isBlank((CharSequence)expression)) {
                throw ErrorUtilities.createResponseErrorException("Failed to evaluate. Reason: Empty expression cannot be evaluated.", ResponseErrorCode.InvalidParams);
            }
            NbFrame stackFrame = (NbFrame)this.context.getThreadsProvider().getThreadObjects().getObject(args.getFrameId());
            if (stackFrame == null) {
                throw ErrorUtilities.createResponseErrorException("Failed to evaluate. Reason: Unknown frame " + args.getFrameId(), ResponseErrorCode.InvalidParams);
            }
            stackFrame.getDVFrame().makeCurrent();
            DebuggingView.DVThread dvThread = stackFrame.getDVFrame().getThread();
            int threadId = this.context.getThreadsProvider().getId(dvThread);
            JPDADebugger debugger = this.context.getDebugSession().getDebugger();
            try {
                variable = debugger.evaluate(expression);
            }
            catch (InvalidExpressionException ex) {
                throw ErrorUtilities.createResponseErrorException("Failed to evaluate. Reason: " + ex.getLocalizedMessage(), ResponseErrorCode.ParseError);
            }
            EvaluateResponse response = new EvaluateResponse();
            TruffleVariable truffleVariable = TruffleVariable.get((Variable)variable);
            if (truffleVariable != null) {
                int referenceId = this.context.getThreadsProvider().getThreadObjects().addObject(threadId, truffleVariable);
                response.setResult(truffleVariable.getDisplayValue());
                response.setVariablesReference(referenceId);
                response.setType(truffleVariable.getType());
                response.setIndexedVariables(Integer.valueOf(truffleVariable.isLeaf() ? 0 : Integer.MAX_VALUE));
            } else if (variable instanceof ObjectVariable) {
                String toString;
                int referenceId = this.context.getThreadsProvider().getThreadObjects().addObject(threadId, variable);
                int indexedVariables = ((ObjectVariable)variable).getFieldsCount();
                try {
                    toString = ((ObjectVariable)variable).getToStringValue();
                }
                catch (InvalidExpressionException ex) {
                    toString = variable.getValue();
                }
                response.setResult(toString);
                response.setVariablesReference(referenceId);
                response.setType(variable.getType());
                response.setIndexedVariables(Integer.valueOf(Math.max(indexedVariables, 0)));
            } else {
                response.setResult(variable.getValue());
                response.setVariablesReference(0);
                response.setType(variable.getType());
                response.setIndexedVariables(Integer.valueOf(0));
            }
            return response;
        });
    }

    public CompletableFuture<ExceptionInfoResponse> exceptionInfo(ExceptionInfoArguments args) {
        CompletableFuture<ExceptionInfoResponse> future = new CompletableFuture<ExceptionInfoResponse>();
        Variable exceptionVariable = this.context.getBreakpointManager().getExceptionOn(args.getThreadId());
        if (exceptionVariable == null) {
            ErrorUtilities.completeExceptionally(future, "No exception exists in thread " + args.getThreadId(), ResponseErrorCode.InvalidParams);
        } else {
            JPDADebugger debugger = this.context.getDebugSession().getDebugger();
            Throwable exception = (Throwable)exceptionVariable.createMirrorObject();
            String typeName = exception.getLocalizedMessage();
            String exceptionToString = exception.toString();
            ExceptionInfoResponse response = new ExceptionInfoResponse();
            response.setExceptionId(typeName);
            response.setDescription(exceptionToString);
            future.complete(response);
        }
        return future;
    }
}

