/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.web;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.impl.common.ParseUtils;
import org.openide.filesystems.FileObject;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class WebParseUtils {
    private static final Logger LOGGER = Logger.getLogger(WebParseUtils.class.getName());

    public static String getVersion(InputStream is) throws IOException, SAXException {
        return ParseUtils.getVersion(is, (DefaultHandler)new VersionHandler(), (EntityResolver)DDResolver.getInstance());
    }

    public static String getVersion(FileObject fo) throws IOException, SAXException {
        try (InputStream inputStream = fo.getInputStream();){
            String string = ParseUtils.getVersion(inputStream, (DefaultHandler)new VersionHandler(), (EntityResolver)DDResolver.getInstance());
            return string;
        }
    }

    public static String getVersion(InputSource is) throws IOException, SAXException {
        return ParseUtils.getVersion(is, (DefaultHandler)new VersionHandler(), (EntityResolver)DDResolver.getInstance());
    }

    public static SAXParseException parse(FileObject fo) throws SAXException, IOException {
        try (InputStream inputStream = fo.getInputStream();){
            SAXParseException sAXParseException = WebParseUtils.parse(new InputSource(inputStream));
            return sAXParseException;
        }
    }

    public static SAXParseException parse(InputSource is) throws SAXException, IOException {
        return ParseUtils.parseDD(is, DDResolver.getInstance());
    }

    public static SAXParseException parse(InputSource is, EntityResolver resolver) throws SAXException, IOException {
        return ParseUtils.parseDD(is, resolver);
    }

    private static class DDResolver
    implements EntityResolver {
        static DDResolver resolver;

        private DDResolver() {
        }

        static synchronized DDResolver getInstance() {
            if (resolver == null) {
                resolver = new DDResolver();
            }
            return resolver;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Resolving entity [publicId: '" + publicId + "', systemId: '" + systemId + "']");
            }
            String resource = null;
            if ("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN".equals(publicId)) {
                resource = "/org/netbeans/modules/j2ee/dd/impl/resources/web-app_2_3.dtd";
            } else if ("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN".equals(publicId)) {
                resource = "/org/netbeans/modules/j2ee/dd/impl/resources/web-app_2_2.dtd";
            } else if (systemId != null && systemId.endsWith("web-app_2_4.xsd")) {
                resource = "/org/netbeans/modules/j2ee/dd/impl/resources/web-app_2_4.xsd";
            } else if (systemId != null && systemId.endsWith("web-app_2_5.xsd")) {
                resource = "/org/netbeans/modules/j2ee/dd/impl/resources/web-app_2_5.xsd";
            } else if (systemId != null && systemId.endsWith("web-app_3_0.xsd")) {
                resource = "/org/netbeans/modules/j2ee/dd/impl/resources/web-app_3_0.xsd";
            } else if (systemId != null && systemId.endsWith("web-app_3_1.xsd")) {
                resource = "/org/netbeans/modules/j2ee/dd/impl/resources/web-app_3_1.xsd";
            } else if (systemId != null && systemId.endsWith("web-app_4_0.xsd")) {
                resource = "/org/netbeans/modules/j2ee/dd/impl/resources/web-app_4_0.xsd";
            } else if (systemId != null && systemId.endsWith("web-fragment_3_0.xsd")) {
                resource = "/org/netbeans/modules/j2ee/dd/impl/resources/web-fragment_3_0.xsd";
            } else if (systemId != null && systemId.endsWith("web-fragment_3_1.xsd")) {
                resource = "/org/netbeans/modules/j2ee/dd/impl/resources/web-fragment_3_1.xsd";
            } else if (systemId != null && systemId.endsWith("web-fragment_4_0.xsd")) {
                resource = "/org/netbeans/modules/j2ee/dd/impl/resources/web-fragment_4_0.xsd";
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Got resource: " + resource);
            }
            if (resource == null) {
                return null;
            }
            URL url = this.getClass().getResource(resource);
            return new InputSource(url.toString());
        }
    }

    private static class VersionHandler
    extends DefaultHandler {
        private VersionHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String rawName, Attributes atts) throws SAXException {
            if ("web-app".equals(rawName)) {
                String version = atts.getValue("version");
                throw new SAXException("version:" + (version == null ? "2.3" : version));
            }
            if ("web-fragment".equals(rawName)) {
                String version = atts.getValue("version");
                throw new SAXException("version:" + version);
            }
        }
    }
}

