/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.application;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.Module;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.Icon;
import org.netbeans.modules.j2ee.dd.api.common.NameAlreadyUsedException;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.dd.api.common.SecurityRole;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.xml.sax.SAXParseException;

public class ApplicationProxy
implements Application {
    private Application app;
    private String version;
    private List<PropertyChangeListener> listeners;
    public boolean writing = false;
    private OutputProvider outputProvider;
    private SAXParseException error;
    private int ddStatus;

    public ApplicationProxy(Application app, String version) {
        this.app = app;
        this.version = version;
        this.listeners = new ArrayList<PropertyChangeListener>();
    }

    public void setOriginal(Application app) {
        if (this.app != app) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                PropertyChangeListener pcl = this.listeners.get(i);
                if (this.app != null) {
                    this.app.removePropertyChangeListener(pcl);
                }
                if (app == null) continue;
                app.addPropertyChangeListener(pcl);
            }
            this.app = app;
            if (app != null) {
                this.setProxyVersion(app.getVersion().toString());
            }
        }
    }

    public Application getOriginal() {
        return this.app;
    }

    public void setProxyVersion(String value) {
        if (this.version == null && value != null || this.version != null && !this.version.equals(value)) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this, "dd_version", this.version, value);
            this.version = value;
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).propertyChange(evt);
            }
        }
    }

    @Override
    public CommonDDBean addBean(String beanName) throws ClassNotFoundException {
        return this.app == null ? null : this.app.addBean(beanName);
    }

    @Override
    public CommonDDBean addBean(String beanName, String[] propertyNames, Object[] propertyValues, String keyProperty) throws ClassNotFoundException, NameAlreadyUsedException {
        return this.app == null ? null : this.app.addBean(beanName, propertyNames, propertyValues, keyProperty);
    }

    @Override
    public int addIcon(Icon value) throws VersionNotSupportedException {
        return this.app == null ? -1 : this.app.addIcon(value);
    }

    @Override
    public int addModule(Module value) {
        return this.app == null ? -1 : this.app.addModule(value);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.app != null) {
            this.app.addPropertyChangeListener(pcl);
        }
        this.listeners.add(pcl);
    }

    @Override
    public int addSecurityRole(SecurityRole value) {
        return this.app == null ? -1 : this.app.addSecurityRole(value);
    }

    @Override
    public CommonDDBean createBean(String beanName) throws ClassNotFoundException {
        return this.app == null ? null : this.app.createBean(beanName);
    }

    @Override
    public CommonDDBean findBeanByName(String beanName, String propertyName, String value) {
        return this.app == null ? null : this.app.findBeanByName(beanName, propertyName, value);
    }

    @Override
    public Map getAllDescriptions() {
        return this.app == null ? new HashMap() : this.app.getAllDescriptions();
    }

    @Override
    public Map getAllDisplayNames() {
        return this.app == null ? new HashMap() : this.app.getAllDisplayNames();
    }

    @Override
    public Map getAllIcons() {
        return this.app == null ? new HashMap() : this.app.getAllIcons();
    }

    @Override
    public String getDefaultDescription() {
        return this.app == null ? null : this.app.getDefaultDescription();
    }

    @Override
    public String getDefaultDisplayName() {
        return this.app == null ? null : this.app.getDefaultDisplayName();
    }

    @Override
    public Icon getDefaultIcon() {
        return this.app == null ? null : this.app.getDefaultIcon();
    }

    @Override
    public String getDescription(String locale) throws VersionNotSupportedException {
        return this.app == null ? null : this.app.getDescription(locale);
    }

    @Override
    public String getDisplayName(String locale) throws VersionNotSupportedException {
        return this.app == null ? null : this.app.getDisplayName(locale);
    }

    @Override
    public SAXParseException getError() {
        return this.error;
    }

    public void setError(SAXParseException error) {
        this.error = error;
    }

    @Override
    public Icon getIcon(int index) throws VersionNotSupportedException {
        return this.app == null ? null : this.app.getIcon(index);
    }

    @Override
    public String getId() {
        return this.app == null ? null : this.app.getId();
    }

    @Override
    public String getLargeIcon() {
        return this.app == null ? null : this.app.getLargeIcon();
    }

    @Override
    public String getLargeIcon(String locale) throws VersionNotSupportedException {
        return this.app == null ? null : this.app.getLargeIcon(locale);
    }

    @Override
    public Module[] getModule() {
        return this.app == null ? null : this.app.getModule();
    }

    @Override
    public Module getModule(int index) {
        return this.app == null ? null : this.app.getModule(index);
    }

    @Override
    public SecurityRole[] getSecurityRole() {
        return this.app == null ? null : this.app.getSecurityRole();
    }

    @Override
    public SecurityRole getSecurityRole(int index) {
        return this.app == null ? null : this.app.getSecurityRole(index);
    }

    @Override
    public String getSmallIcon() {
        return this.app == null ? null : this.app.getSmallIcon();
    }

    @Override
    public String getSmallIcon(String locale) throws VersionNotSupportedException {
        return this.app == null ? null : this.app.getSmallIcon(locale);
    }

    @Override
    public int getStatus() {
        return this.ddStatus;
    }

    public void setStatus(int value) {
        if (this.ddStatus != value) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this, "dd_status", this.ddStatus, value);
            this.ddStatus = value;
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).propertyChange(evt);
            }
        }
    }

    @Override
    public Object getValue(String propertyName) {
        return this.app == null ? null : this.app.getValue(propertyName);
    }

    @Override
    public BigDecimal getVersion() {
        return this.version == null ? BigDecimal.ZERO : new BigDecimal(this.version);
    }

    @Override
    public void merge(RootInterface root, int mode) {
        if (this.app != null) {
            if (root instanceof ApplicationProxy) {
                this.app.merge(((ApplicationProxy)root).getOriginal(), mode);
            } else {
                this.app.merge(root, mode);
            }
        }
    }

    @Override
    public Icon newIcon() {
        return this.app == null ? null : this.app.newIcon();
    }

    @Override
    public Module newModule() {
        return this.app == null ? null : this.app.newModule();
    }

    @Override
    public SecurityRole newSecurityRole() {
        return this.app == null ? null : this.app.newSecurityRole();
    }

    @Override
    public void removeAllDescriptions() {
        if (this.app != null) {
            this.app.removeAllDescriptions();
        }
    }

    @Override
    public void removeAllDisplayNames() {
        if (this.app != null) {
            this.app.removeAllDisplayNames();
        }
    }

    @Override
    public void removeAllIcons() {
        if (this.app != null) {
            this.app.removeAllIcons();
        }
    }

    @Override
    public void removeDescription() {
        if (this.app != null) {
            this.app.removeDescription();
        }
    }

    @Override
    public void removeDescriptionForLocale(String locale) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.removeDescriptionForLocale(locale);
        }
    }

    @Override
    public void removeDisplayName() {
        if (this.app != null) {
            this.app.removeDisplayName();
        }
    }

    @Override
    public void removeDisplayNameForLocale(String locale) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.removeDisplayNameForLocale(locale);
        }
    }

    @Override
    public void removeIcon() {
        if (this.app != null) {
            this.app.removeIcon();
        }
    }

    @Override
    public int removeIcon(Icon value) throws VersionNotSupportedException {
        return this.app == null ? -1 : this.app.removeIcon(value);
    }

    @Override
    public void removeIcon(String locale) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.removeIcon(locale);
        }
    }

    @Override
    public void removeLargeIcon() {
        if (this.app != null) {
            this.app.removeLargeIcon();
        }
    }

    @Override
    public void removeLargeIcon(String locale) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.removeLargeIcon(locale);
        }
    }

    @Override
    public int removeModule(Module value) {
        return this.app == null ? -1 : this.app.removeModule(value);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.app != null) {
            this.app.removePropertyChangeListener(pcl);
        }
        this.listeners.remove(pcl);
    }

    @Override
    public int removeSecurityRole(SecurityRole value) {
        return this.app == null ? -1 : this.app.removeSecurityRole(value);
    }

    @Override
    public void removeSmallIcon() {
        if (this.app != null) {
            this.app.removeSmallIcon();
        }
    }

    @Override
    public void removeSmallIcon(String locale) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.removeSmallIcon(locale);
        }
    }

    @Override
    public void setAllDescriptions(Map descriptions) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setAllDescriptions(descriptions);
        }
    }

    @Override
    public void setAllDisplayNames(Map displayNames) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setAllDisplayNames(displayNames);
        }
    }

    @Override
    public void setAllIcons(String[] locales, String[] smallIcons, String[] largeIcons) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setAllIcons(locales, smallIcons, largeIcons);
        }
    }

    @Override
    public void setDescription(String description) {
        if (this.app != null) {
            this.app.setDescription(description);
        }
    }

    @Override
    public void setDescription(String locale, String description) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setDescription(locale, description);
        }
    }

    @Override
    public void setDisplayName(String displayName) {
        if (this.app != null) {
            this.app.setDisplayName(displayName);
        }
    }

    @Override
    public void setDisplayName(String locale, String displayName) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setDisplayName(locale, displayName);
        }
    }

    @Override
    public void setIcon(Icon[] value) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setIcon(value);
        }
    }

    @Override
    public void setIcon(Icon icon) {
        if (this.app != null) {
            this.app.setIcon(icon);
        }
    }

    @Override
    public void setIcon(int index, Icon value) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setIcon(index, value);
        }
    }

    @Override
    public void setId(String value) {
        if (this.app != null) {
            this.app.setId(value);
        }
    }

    @Override
    public void setLargeIcon(String icon) {
        if (this.app != null) {
            this.app.setLargeIcon(icon);
        }
    }

    @Override
    public void setLargeIcon(String locale, String icon) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setLargeIcon(locale, icon);
        }
    }

    @Override
    public void setModule(Module[] value) {
        if (this.app != null) {
            this.app.setModule(value);
        }
    }

    @Override
    public void setModule(int index, Module value) {
        if (this.app != null) {
            this.app.setModule(index, value);
        }
    }

    @Override
    public void setSecurityRole(SecurityRole[] value) {
        if (this.app != null) {
            this.app.setSecurityRole(value);
        }
    }

    @Override
    public void setSecurityRole(int index, SecurityRole value) {
        if (this.app != null) {
            this.app.setSecurityRole(index, value);
        }
    }

    @Override
    public void setSmallIcon(String icon) {
        if (this.app != null) {
            this.app.setSmallIcon(icon);
        }
    }

    @Override
    public void setSmallIcon(String locale, String icon) throws VersionNotSupportedException {
        if (this.app != null) {
            this.app.setSmallIcon(locale, icon);
        }
    }

    @Override
    public int sizeIcon() throws VersionNotSupportedException {
        return this.app == null ? 0 : this.app.sizeIcon();
    }

    @Override
    public int sizeModule() {
        return this.app == null ? 0 : this.app.sizeModule();
    }

    @Override
    public int sizeSecurityRole() {
        return this.app == null ? 0 : this.app.sizeSecurityRole();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(FileObject fo) throws IOException {
        if (this.app != null) {
            try {
                FileLock lock = fo.lock();
                try (OutputStream os = fo.getOutputStream(lock);){
                    this.writing = true;
                    this.write(os);
                }
                finally {
                    lock.releaseLock();
                }
            }
            catch (FileAlreadyLockedException ex) {
                DataObject dobj = DataObject.find((FileObject)fo);
                if (dobj != null && dobj instanceof OutputProvider) {
                    ((OutputProvider)dobj).write(this);
                }
                throw ex;
            }
        }
    }

    @Override
    public void write(OutputStream os) throws IOException {
        if (this.app != null) {
            this.writing = true;
            this.app.write(os);
        }
    }

    @Override
    public Object clone() {
        ApplicationProxy proxy = null;
        if (this.app == null) {
            proxy = new ApplicationProxy(null, this.version);
        } else {
            ApplicationProxy clonedApp = (ApplicationProxy)this.app.clone();
            proxy = new ApplicationProxy(clonedApp, this.version);
        }
        proxy.setError(this.error);
        proxy.setStatus(this.ddStatus);
        return proxy;
    }

    public boolean isWriting() {
        return this.writing;
    }

    public void setWriting(boolean writing) {
        this.writing = writing;
    }

    public void setOutputProvider(OutputProvider iop) {
        this.outputProvider = iop;
    }

    public static interface OutputProvider {
        public void write(Application var1) throws IOException;

        public FileObject getTarget();
    }
}

