/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.loaders;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.netbeans.modules.gradle.GradleProject;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.GradleReport;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.execute.GradleCommandLine;
import org.netbeans.modules.gradle.cache.ProjectInfoDiskCache;
import org.netbeans.modules.gradle.cache.SubProjectDiskCache;
import org.netbeans.modules.gradle.loaders.FallbackProjectLoader;
import org.netbeans.modules.gradle.loaders.GradleDaemon;
import org.netbeans.modules.gradle.loaders.LegacyProjectLoader;
import org.netbeans.modules.gradle.options.GradleExperimentalSettings;
import org.netbeans.modules.gradle.spi.GradleFiles;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.netbeans.modules.gradle.spi.ProjectInfoExtractor;
import org.netbeans.modules.gradle.tooling.internal.NbProjectInfo;
import org.openide.util.Lookup;

public abstract class AbstractProjectLoader {
    final ReloadContext ctx;

    AbstractProjectLoader(ReloadContext ctx) {
        this.ctx = ctx;
    }

    abstract GradleProject load();

    abstract boolean isEnabled();

    boolean needsTrust() {
        return true;
    }

    static GradleCommandLine injectNetBeansTooling(GradleCommandLine cmd) {
        GradleCommandLine ret = new GradleCommandLine(cmd);
        ret.setFlag(GradleCommandLine.Flag.CONFIGURE_ON_DEMAND, GradleSettings.getDefault().isConfigureOnDemand());
        ret.addParameter(GradleCommandLine.Parameter.INIT_SCRIPT, GradleDaemon.initScript());
        ret.setStackTrace(GradleCommandLine.StackTrace.SHORT);
        ret.addProjectProperty("nbSerializeCheck", "true");
        return ret;
    }

    static GradleProject createGradleProject(GradleFiles gf, ProjectInfoDiskCache.QualifiedProjectInfo info) {
        Collection extractors = Lookup.getDefault().lookupAll(ProjectInfoExtractor.class);
        HashMap results = new HashMap();
        LinkedHashSet<String> problems = new LinkedHashSet<String>(info.getProblems());
        HashMap<String, Object> projectInfo = new HashMap<String, Object>(info.getInfo());
        projectInfo.putAll(info.getExt());
        for (ProjectInfoExtractor extractor : extractors) {
            ProjectInfoExtractor.Result result = extractor.extract(projectInfo, Collections.unmodifiableMap(results));
            problems.addAll(result.getProblems());
            for (Object extract : result.getExtract()) {
                results.put(extract.getClass(), extract);
            }
        }
        LinkedHashSet<GradleReport> reps = new LinkedHashSet<GradleReport>();
        if (info.getReports() != null) {
            for (NbProjectInfo.Report r : info.getReports()) {
                reps.add(LegacyProjectLoader.copyReport(r));
            }
        }
        for (String s : problems) {
            reps.add(GradleProject.createGradleReport(gf.getBuildScript().toPath(), s, new String[0]));
        }
        return new GradleProject(info.getQuality(), reps, results.values());
    }

    static void updateSubDirectoryCache(GradleProject gp) {
        GradleBaseProject baseProject;
        if (gp.getQuality().atLeast(NbGradleProject.Quality.EVALUATED) && (baseProject = gp.getBaseProject()).isRoot() && !GradleExperimentalSettings.getDefault().isBundledLoading()) {
            SubProjectDiskCache spCache = SubProjectDiskCache.get(baseProject.getRootDir());
            spCache.storeData(new SubProjectDiskCache.SubProjectInfo(baseProject));
        }
    }

    static void saveCachedProjectInfo(ProjectInfoDiskCache.QualifiedProjectInfo data, GradleProject gp) {
        assert (gp.getQuality().betterThan(NbGradleProject.Quality.FALLBACK)) : "Never attempt to cache FALLBACK projects.";
        GradleFiles gf = new GradleFiles(gp.getBaseProject().getProjectDir(), true);
        ProjectInfoDiskCache.get(gf).storeData(data);
    }

    static final class ReloadContext {
        final NbGradleProjectImpl project;
        final GradleProject previous;
        final NbGradleProject.Quality aim;
        final GradleCommandLine cmd;
        final String description;

        public ReloadContext(NbGradleProjectImpl project, NbGradleProject.Quality aim, GradleCommandLine cmd, String description) {
            this.project = project;
            this.previous = project.isGradleProjectLoaded() ? project.projectWithQuality(null, NbGradleProject.Quality.FALLBACK, false, false) : FallbackProjectLoader.createFallbackProject(project.getGradleFiles());
            this.aim = aim;
            this.cmd = cmd;
            this.description = description;
        }

        public GradleProject getPrevious() {
            return this.previous;
        }

        public NbGradleProject.Quality getAim() {
            return this.aim;
        }
    }
}

