/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.TemplateAttrProvider;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class LicenseHeadersPanel
extends JPanel {
    private static final String PROP_LICENSE = "license";
    private boolean hasLicenseProperty = false;
    private FileObject projectLicense;
    private Project project;
    private final ActionListener storeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            LicenseHeadersPanel.this.store();
        }
    };
    private ButtonGroup bgLicense;
    private JComboBox<GlobalItem> cbGlobalLicense;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JRadioButton rbCustomFile;
    private JRadioButton rbGlobalLicense;
    private JTextArea taLicense;
    private JTextField tfCustomFile;

    public LicenseHeadersPanel() {
        this.initComponents();
        this.loadGlobalLicenses();
    }

    public LicenseHeadersPanel(Project project) {
        this();
        this.project = project;
        this.initProject();
    }

    private void initComponents() {
        this.bgLicense = new ButtonGroup();
        this.rbGlobalLicense = new JRadioButton();
        this.cbGlobalLicense = new JComboBox();
        this.rbCustomFile = new JRadioButton();
        this.tfCustomFile = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.taLicense = new JTextArea();
        this.jLabel2 = new JLabel();
        this.bgLicense.add(this.rbGlobalLicense);
        Mnemonics.setLocalizedText((AbstractButton)this.rbGlobalLicense, (String)NbBundle.getMessage(LicenseHeadersPanel.class, (String)"LicenseHeadersPanel.rbGlobalLicense.text"));
        this.rbGlobalLicense.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LicenseHeadersPanel.this.rbGlobalLicenseStateChanged(evt);
            }
        });
        this.cbGlobalLicense.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseHeadersPanel.this.cbGlobalLicenseActionPerformed(evt);
            }
        });
        this.bgLicense.add(this.rbCustomFile);
        this.rbCustomFile.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbCustomFile, (String)NbBundle.getMessage(LicenseHeadersPanel.class, (String)"LicenseHeadersPanel.rbCustomFile.text"));
        this.rbCustomFile.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LicenseHeadersPanel.this.rbCustomFileStateChanged(evt);
            }
        });
        this.tfCustomFile.setEditable(false);
        this.tfCustomFile.setEnabled(false);
        this.jLabel1.setLabelFor(this.taLicense);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(LicenseHeadersPanel.class, (String)"LicenseHeadersPanel.jLabel1.text"));
        this.taLicense.setEditable(false);
        this.taLicense.setColumns(20);
        this.taLicense.setRows(5);
        this.taLicense.setTabSize(4);
        this.jScrollPane1.setViewportView(this.taLicense);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(LicenseHeadersPanel.class, (String)"LicenseHeadersPanel.jLabel2.text"));
        this.jLabel2.setVerticalAlignment(1);
        this.jLabel2.setVerifyInputWhenFocusTarget(false);
        this.jLabel2.setVerticalTextPosition(1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jLabel2, -2, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.rbCustomFile, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfCustomFile)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.rbGlobalLicense, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbGlobalLicense, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jScrollPane1, -1, 590, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.rbCustomFile, this.rbGlobalLicense);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rbGlobalLicense).addComponent(this.cbGlobalLicense, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rbCustomFile).addComponent(this.tfCustomFile, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 243, Short.MAX_VALUE)));
    }

    private void cbGlobalLicenseActionPerformed(ActionEvent evt) {
        GlobalItem sel = (GlobalItem)this.cbGlobalLicense.getSelectedItem();
        try {
            this.taLicense.setText(sel.fileObject.asText());
            this.taLicense.setCaretPosition(0);
        }
        catch (IOException ex) {
            this.taLicense.setText(null);
        }
    }

    private void rbCustomFileStateChanged(ChangeEvent evt) {
        if (this.rbCustomFile.isSelected()) {
            try {
                String text = this.projectLicense != null ? this.projectLicense.asText() : null;
                this.taLicense.setText(this.hasLicenseProperty ? null : text);
                this.taLicense.setCaretPosition(0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void rbGlobalLicenseStateChanged(ChangeEvent evt) {
        boolean globalLicense = this.rbGlobalLicense.isSelected();
        this.cbGlobalLicense.setEnabled(globalLicense);
        if (globalLicense) {
            this.cbGlobalLicenseActionPerformed(null);
        }
    }

    private void loadGlobalLicenses() {
        TreeSet<GlobalItem> licenses = new TreeSet<GlobalItem>();
        FileObject root = FileUtil.getConfigFile((String)"Templates/Licenses");
        for (FileObject fo : root.getChildren()) {
            if (fo.getAttribute("template") == null) continue;
            String displayName = (String)fo.getAttribute("displayName");
            if (displayName == null && (displayName = fo.getName()).startsWith("license-")) {
                displayName = displayName.substring("license-".length());
            }
            licenses.add(new GlobalItem(displayName, fo));
        }
        DefaultComboBoxModel<GlobalItem> model = new DefaultComboBoxModel<GlobalItem>();
        for (GlobalItem license : licenses) {
            model.addElement(license);
        }
        this.cbGlobalLicense.setModel(model);
        this.setGlobalLicense(null);
    }

    private void initProject() {
        AuxiliaryProperties aux = (AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class);
        GradleBaseProject gbp = GradleBaseProject.get(this.project);
        this.projectLicense = this.resolveLicense(gbp.getLicense());
        String license = aux.get(PROP_LICENSE, true);
        if (license != null) {
            String licensePath = TemplateAttrProvider.findLicensePathInTemplates(license);
            if (licensePath != null) {
                this.rbGlobalLicense.setSelected(true);
                this.hasLicenseProperty = true;
                this.setGlobalLicense(license);
            } else {
                this.rbCustomFile.setSelected(true);
            }
        }
        if (this.projectLicense != null) {
            String name = (String)this.projectLicense.getAttribute("displayName");
            name = name != null ? name : FileUtil.getFileDisplayName((FileObject)this.projectLicense);
            this.tfCustomFile.setText(name);
            try {
                this.taLicense.setText(this.projectLicense.asText());
                this.taLicense.setCaretPosition(0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void setGlobalLicense(String lic) {
        lic = lic != null ? lic : "default";
        ComboBoxModel<GlobalItem> model = this.cbGlobalLicense.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            GlobalItem item = (GlobalItem)model.getElementAt(i);
            if (!lic.equals(item.getName())) continue;
            model.setSelectedItem(item);
            break;
        }
    }

    private FileObject resolveLicense(String license) {
        String lic = TemplateAttrProvider.findLicenseByMavenProjectContent(license);
        lic = TemplateAttrProvider.findLicensePathInTemplates(lic == null ? license : lic);
        if (lic != null) {
            return FileUtil.getConfigFile((String)lic);
        }
        File f = FileUtil.normalizeFile((File)new File(license));
        return f.isAbsolute() ? FileUtil.toFileObject((File)f) : this.project.getProjectDirectory().getFileObject(license);
    }

    private void store() {
        if (this.project == null) {
            return;
        }
        AuxiliaryProperties aux = (AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class);
        if (this.rbGlobalLicense.isSelected()) {
            aux.put(PROP_LICENSE, ((GlobalItem)this.cbGlobalLicense.getSelectedItem()).getName(), true);
        } else if (this.hasLicenseProperty) {
            aux.put(PROP_LICENSE, null, true);
        }
    }

    public static ProjectCustomizer.CompositeCategoryProvider licenseHeaderCustomizerProvider() {
        return new ProjectCustomizer.CompositeCategoryProvider(){

            public ProjectCustomizer.Category createCategory(Lookup context) {
                return null;
            }

            public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
                Project project = (Project)context.lookup(Project.class);
                LicenseHeadersPanel panel = new LicenseHeadersPanel(project);
                category.setStoreListener(panel.storeListener);
                return panel;
            }
        };
    }

    private static class GlobalItem
    implements Comparable<GlobalItem> {
        final String displayName;
        final FileObject fileObject;

        public GlobalItem(String name, FileObject fileObject) {
            this.displayName = name;
            this.fileObject = fileObject;
        }

        public String getName() {
            if (this.fileObject == null) {
                return this.displayName;
            }
            String name = this.fileObject.getName();
            if (name.startsWith("license-")) {
                name = name.substring("license-".length());
            }
            return name;
        }

        public String toString() {
            return this.displayName;
        }

        @Override
        public int compareTo(GlobalItem o) {
            return this.displayName.compareToIgnoreCase(o.displayName);
        }
    }
}

