/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.ConfigurableLauncher;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProgressListener;
import org.gradle.tooling.ProjectConnection;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.gradle.Bundle;
import org.netbeans.modules.gradle.GradleArtifactStore;
import org.netbeans.modules.gradle.GradleDaemon;
import org.netbeans.modules.gradle.GradleDistributionManager;
import org.netbeans.modules.gradle.GradleProject;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.NbProjectInfo;
import org.netbeans.modules.gradle.api.execute.GradleCommandLine;
import org.netbeans.modules.gradle.api.execute.RunUtils;
import org.netbeans.modules.gradle.spi.GradleFiles;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.netbeans.modules.gradle.spi.ProjectInfoExtractor;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;

public final class GradleProjectCache {
    private static final Logger LOG = Logger.getLogger(GradleProjectCache.class.getName());
    private static final String INFO_CACHE_FILE_NAME = "project-info.ser";
    private static final Map<File, List<Notification>> NOTIFICATIONS = new WeakHashMap<File, List<Notification>>();
    private static AtomicLong timeInLoad = new AtomicLong();
    private static AtomicInteger loadedProjects = new AtomicInteger();
    private static final Map<File, Set<File>> SUB_PROJECT_DIR_CACHE = new ConcurrentHashMap<File, Set<File>>();
    private static final int COMPATIBLE_CACHE_VERSION = 11;

    public static GradleProject loadProject(NbGradleProjectImpl project, NbGradleProject.Quality aim, boolean ignoreCache, String ... args) {
        GradleProject ret;
        ProjectCacheEntry cacheEntry;
        GradleFiles files = project.getGradleFiles();
        if (aim == NbGradleProject.Quality.FALLBACK) {
            return GradleProjectCache.fallbackProject(files);
        }
        GradleProject prev = project.project;
        if (!ignoreCache && !GradleSettings.getDefault().isCacheDisabled() && prev.getQuality() == NbGradleProject.Quality.FALLBACK && (cacheEntry = GradleProjectCache.loadCachedProject(files)) != null && cacheEntry.isCompatible()) {
            prev = GradleProjectCache.createGradleProject(cacheEntry.quality, cacheEntry.data);
            if (cacheEntry.isValid()) {
                GradleProjectCache.updateSubDirectoryCache(prev);
                return prev;
            }
        }
        if (prev == null) {
            prev = GradleProjectCache.fallbackProject(project.getGradleFiles());
        }
        ReloadContext ctx = new ReloadContext(project, prev, aim);
        ctx.args = args;
        try {
            ret = (GradleProject)GradleDaemon.GRADLE_LOADER_RP.submit((Callable)new ProjectLoaderTask(ctx)).get();
            GradleProjectCache.updateSubDirectoryCache(ret);
        }
        catch (InterruptedException | ExecutionException ex) {
            ret = GradleProjectCache.fallbackProject(files);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GradleProject loadGradleProject(ReloadContext ctx, CancellationToken token, ProgressListener pl) {
        GradleBaseProject base;
        NbGradleProject.Quality quality;
        NbProjectInfo info;
        long start;
        block32: {
            GoOnline goOnline;
            start = System.currentTimeMillis();
            info = null;
            quality = ctx.aim;
            base = ctx.previous.getBaseProject();
            GradleConnector gconn = GradleConnector.newConnector();
            File gradleInstall = RunUtils.evaluateGradleDistribution(ctx.project, true);
            if (gradleInstall == null) {
                GradleDistributionManager gdm = GradleDistributionManager.get(GradleSettings.getDefault().getGradleUserHome());
                GradleDistributionManager.NbGradleVersion version = gdm.createVersion(GradleSettings.getDefault().getGradleVersion());
                gradleInstall = gdm.install(version);
            }
            if (gradleInstall == null) {
                return ctx.previous;
            }
            gconn.useInstallation(gradleInstall);
            ProjectConnection pconn = gconn.forProjectDirectory(base.getProjectDir()).connect();
            GradleCommandLine cmd = new GradleCommandLine(ctx.args);
            cmd.setFlag(GradleCommandLine.Flag.CONFIGURE_ON_DEMAND, GradleSettings.getDefault().isConfigureOnDemand());
            cmd.addParameter(GradleCommandLine.Parameter.INIT_SCRIPT, GradleDaemon.INIT_SCRIPT);
            cmd.setStackTrace(GradleCommandLine.StackTrace.SHORT);
            cmd.addSystemProperty("NETBEANS_TOOLING_JAR", GradleDaemon.TOOLING_JAR);
            cmd.addProjectProperty("nbSerializeCheck", "true");
            if (GradleSettings.getDefault().isOffline()) {
                goOnline = GoOnline.NEVER;
            } else if (ctx.aim == NbGradleProject.Quality.FULL_ONLINE) {
                goOnline = GoOnline.ALWAYS;
            } else {
                switch (GradleSettings.getDefault().getDownloadLibs()) {
                    case NEVER: {
                        goOnline = GoOnline.NEVER;
                        break;
                    }
                    case ALWAYS: {
                        goOnline = GoOnline.ALWAYS;
                        break;
                    }
                    default: {
                        goOnline = GoOnline.ON_DEMAND;
                    }
                }
            }
            try {
                info = GradleProjectCache.retrieveProjectInfo(goOnline, pconn, cmd, token, pl);
                List<Notification> nlist = NOTIFICATIONS.get(base.getProjectDir());
                if (nlist != null) {
                    NOTIFICATIONS.remove(base.getProjectDir());
                    for (Notification notification : nlist) {
                        notification.clear();
                    }
                }
                if (!info.hasException()) {
                    if (!info.getProblems().isEmpty()) {
                        quality = NbGradleProject.Quality.SIMPLE;
                        GradleProjectCache.openNotification(base.getProjectDir(), Bundle.TIT_LOAD_ISSUES(base.getProjectDir().getName()), Bundle.TIT_LOAD_ISSUES(base.getProjectDir().getName()), GradleProjectCache.bulletedList(info.getProblems()));
                    } else {
                        quality = ctx.aim;
                    }
                    break block32;
                }
                String problem = info.getGradleException();
                String[] lines = problem.split("\n");
                LOG.log(Level.INFO, "Failed to retrieve project information for: {0} {1}", new Object[]{base.getProjectDir(), lines});
                GradleProjectCache.openNotification(base.getProjectDir(), Bundle.TIT_LOAD_FAILED(base.getProjectDir().getName()), lines[0], problem);
                GradleProject gradleProject = ctx.previous.invalidate(problem);
                return gradleProject;
            }
            catch (IllegalStateException | GradleConnectionException ex) {
                LOG.log(Level.FINE, "Failed to retrieve project information for: " + base.getProjectDir(), ex);
                StringBuilder sb = new StringBuilder();
                String separator = "";
                for (Throwable th = ex; th != null; th = th.getCause()) {
                    sb.insert(0, separator);
                    sb.insert(0, th.getMessage());
                    separator = "<br/>";
                }
                GradleProjectCache.openNotification(base.getProjectDir(), Bundle.TIT_LOAD_FAILED(base.getProjectDir()), ex.getMessage(), sb.toString());
                GradleProject gradleProject = ctx.previous.invalidate(sb.toString());
                return gradleProject;
            }
            finally {
                try {
                    pconn.close();
                }
                catch (NullPointerException nullPointerException) {}
                loadedProjects.incrementAndGet();
            }
        }
        long finish = System.currentTimeMillis();
        timeInLoad.getAndAdd(finish - start);
        LOG.log(Level.FINE, "Loaded project {0} in {1} msec", new Object[]{base.getProjectDir(), finish - start});
        if (SwingUtilities.isEventDispatchThread()) {
            LOG.log(Level.FINE, "Load happened on AWT event dispatcher", new RuntimeException());
        }
        GradleProject ret = GradleProjectCache.createGradleProject(quality, info);
        GradleArtifactStore.getDefault().processProject(ret);
        if (info.getMiscOnly()) {
            ret = ctx.previous;
        } else {
            GradleProjectCache.saveCachedProjectInfo(info, ret);
        }
        return ret;
    }

    private static BuildActionExecuter<NbProjectInfo> createInfoAction(ProjectConnection pconn, GradleCommandLine cmd, CancellationToken token, ProgressListener pl) {
        BuildActionExecuter ret = pconn.action((BuildAction)new NbProjectInfoAction());
        cmd.configure((ConfigurableLauncher)ret);
        if (token != null) {
            ret.withCancellationToken(token);
        }
        if (pl != null) {
            ret.addProgressListener(pl);
        }
        return ret;
    }

    private static NbProjectInfo retrieveProjectInfo(GoOnline goOnline, ProjectConnection pconn, GradleCommandLine cmd, CancellationToken token, ProgressListener pl) throws GradleConnectionException, IllegalStateException {
        NbProjectInfo ret;
        BuildActionExecuter<NbProjectInfo> action;
        GradleCommandLine online;
        block7: {
            GradleSettings settings = GradleSettings.getDefault();
            online = new GradleCommandLine(cmd);
            GradleCommandLine offline = new GradleCommandLine(cmd);
            if (goOnline != GoOnline.ALWAYS) {
                if (settings.getDownloadSources() == GradleSettings.DownloadMiscRule.ALWAYS) {
                    // empty if block
                }
                if (settings.getDownloadJavadoc() == GradleSettings.DownloadMiscRule.ALWAYS) {
                    // empty if block
                }
                offline.addFlag(GradleCommandLine.Flag.OFFLINE);
            }
            if (goOnline == GoOnline.NEVER || goOnline == GoOnline.ON_DEMAND) {
                action = GradleProjectCache.createInfoAction(pconn, offline, token, pl);
                try {
                    ret = (NbProjectInfo)action.run();
                    if (goOnline == GoOnline.NEVER || !ret.hasException()) {
                        return ret;
                    }
                }
                catch (IllegalStateException | GradleConnectionException ex) {
                    if (goOnline != GoOnline.NEVER) break block7;
                    throw ex;
                }
            }
        }
        action = GradleProjectCache.createInfoAction(pconn, online, token, pl);
        ret = (NbProjectInfo)action.run();
        return ret;
    }

    private static void openNotification(File projectDir, String title, String problem, String details) {
        String[] lines;
        StringBuilder sb = new StringBuilder(details.length());
        sb.append("<html>");
        for (String line : lines = details.split("\n")) {
            sb.append(line).append("<br/>");
        }
        Notification notify = NotificationDisplayer.getDefault().notify(title, NbGradleProject.getWarningIcon(), (JComponent)new JLabel(problem), (JComponent)new JLabel(sb.toString()), NotificationDisplayer.Priority.LOW, NotificationDisplayer.Category.WARNING);
        List<Notification> nlist = NOTIFICATIONS.get(projectDir);
        if (nlist == null) {
            nlist = new LinkedList<Notification>();
            NOTIFICATIONS.put(projectDir, nlist);
        }
        nlist.add(notify);
    }

    private static String bulletedList(Collection<? extends Object> elements) {
        StringBuilder sb = new StringBuilder();
        sb.append("<ul>");
        for (Object object : elements) {
            sb.append("<li>");
            String[] lines = object.toString().split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                sb.append(line);
                if (i >= lines.length - 1) continue;
                sb.append("<br/>");
            }
            sb.append("</li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    private static ProjectCacheEntry loadCachedProject(GradleFiles gf) {
        File cacheFile = new File(GradleProjectCache.getCacheDir(gf), INFO_CACHE_FILE_NAME);
        ProjectCacheEntry ret = null;
        if (cacheFile.canRead()) {
            try (ObjectInputStream is = new ObjectInputStream(new FileInputStream(cacheFile));){
                try {
                    ret = (ProjectCacheEntry)is.readObject();
                }
                catch (ClassNotFoundException ex) {
                    LOG.log(Level.FINE, "Invalid cache entry.", ex);
                }
            }
            catch (IOException ex) {
                LOG.log(Level.FINE, "Could no load project info from " + cacheFile, ex);
            }
        }
        return ret;
    }

    private static GradleProject createGradleProject(NbGradleProject.Quality quality, NbProjectInfo info) {
        Collection extractors = Lookup.getDefault().lookupAll(ProjectInfoExtractor.class);
        HashMap results = new HashMap();
        LinkedHashSet<String> problems = new LinkedHashSet<String>(info.getProblems());
        HashMap<String, Object> projectInfo = new HashMap<String, Object>(info.getInfo());
        projectInfo.putAll(info.getExt());
        for (ProjectInfoExtractor extractor : extractors) {
            ProjectInfoExtractor.Result result = extractor.extract(projectInfo, Collections.unmodifiableMap(results));
            problems.addAll(result.getProblems());
            for (Object extract : result.getExtract()) {
                results.put(extract.getClass(), extract);
            }
        }
        return new GradleProject(quality, problems, results.values());
    }

    private static void updateSubDirectoryCache(GradleProject gp) {
        GradleBaseProject baseProject;
        if (gp.getQuality().atLeast(NbGradleProject.Quality.EVALUATED) && (baseProject = gp.getBaseProject()).isRoot()) {
            SUB_PROJECT_DIR_CACHE.put(baseProject.getProjectDir(), new HashSet<File>(baseProject.getSubProjects().values()));
        }
    }

    static Boolean isKnownSubProject(File rootDir, File subProjectDir) {
        Set<File> cache = SUB_PROJECT_DIR_CACHE.get(rootDir);
        return cache != null ? Boolean.valueOf(cache.contains(subProjectDir)) : null;
    }

    private static void saveCachedProjectInfo(NbProjectInfo data, GradleProject gp) {
        assert (gp.getQuality().betterThan(NbGradleProject.Quality.FALLBACK)) : "Never attempt to cache FALLBACK projects.";
        GradleFiles gf = new GradleFiles(gp.getBaseProject().getProjectDir(), true);
        ProjectCacheEntry entry = new ProjectCacheEntry(new StoredProjectInfo(data), gp, gf.getProjectFiles());
        File cacheFile = new File(GradleProjectCache.getCacheDir(gp), INFO_CACHE_FILE_NAME);
        if (!cacheFile.exists()) {
            cacheFile.getParentFile().mkdirs();
        }
        try (ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(cacheFile));){
            os.writeObject(entry);
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, "Failed to persist project info to" + cacheFile, ex);
        }
    }

    private static GradleProject fallbackProject(GradleFiles files) {
        return GradleProjectCache.createFallbackProject(NbGradleProject.Quality.FALLBACK, files, Collections.emptyList());
    }

    private static GradleProject evaluatedProject(GradleFiles files, Collection<String> probs) {
        return GradleProjectCache.createFallbackProject(NbGradleProject.Quality.EVALUATED, files, probs);
    }

    private static GradleProject createFallbackProject(NbGradleProject.Quality quality, GradleFiles files, Collection<String> probs) {
        Collection extractors = Lookup.getDefault().lookupAll(ProjectInfoExtractor.class);
        HashMap infos = new HashMap();
        LinkedHashSet<String> problems = new LinkedHashSet<String>(probs);
        for (ProjectInfoExtractor extractor : extractors) {
            ProjectInfoExtractor.Result result = extractor.fallback(files);
            problems.addAll(result.getProblems());
            for (Object extract : result.getExtract()) {
                infos.put(extract.getClass(), extract);
            }
        }
        return new GradleProject(quality, problems, infos.values());
    }

    public static File getCacheDir(GradleFiles gf) {
        return GradleProjectCache.getCacheDir(gf.getRootDir(), gf.getProjectDir());
    }

    public static File getCacheDir(GradleProject gp) {
        GradleBaseProject base = gp.getBaseProject();
        return GradleProjectCache.getCacheDir(base.getRootDir(), base.getProjectDir());
    }

    private static File getCacheDir(File rootDir, File projectDir) {
        int code = Math.abs(projectDir.getAbsolutePath().hashCode());
        String dirName = projectDir.getName() + "-" + code;
        File dir = new File(rootDir, ".gradle/nb-cache/" + dirName);
        return dir;
    }

    private static class StoredProjectInfo
    implements NbProjectInfo {
        private final Map<String, Object> info;
        private final Set<String> problems;
        private final String gradleException;

        public StoredProjectInfo(NbProjectInfo pinfo) {
            this.info = new LinkedHashMap<String, Object>(pinfo.getInfo());
            this.problems = new LinkedHashSet<String>(pinfo.getProblems());
            this.gradleException = pinfo.getGradleException();
        }

        public Map<String, Object> getInfo() {
            return this.info;
        }

        public Map<String, Object> getExt() {
            return Collections.emptyMap();
        }

        public Set<String> getProblems() {
            return this.problems;
        }

        public String getGradleException() {
            return this.gradleException;
        }

        public boolean hasException() {
            return this.gradleException != null;
        }

        public boolean getMiscOnly() {
            return false;
        }
    }

    private static class ProjectCacheEntry
    implements Serializable {
        int version;
        long timestamp;
        Set<File> sourceFiles;
        NbGradleProject.Quality quality;
        NbProjectInfo data;

        protected ProjectCacheEntry() {
        }

        public ProjectCacheEntry(NbProjectInfo data, GradleProject gp, Set<File> sourceFiles) {
            this.sourceFiles = sourceFiles;
            this.data = data;
            this.quality = gp.getQuality();
            this.timestamp = gp.getEvaluationTime();
            this.version = 11;
        }

        public boolean isCompatible() {
            return this.version == 11;
        }

        public boolean isValid() {
            boolean ret = this.isCompatible();
            if (ret && this.sourceFiles != null) {
                for (File f : this.sourceFiles) {
                    if (f.exists() && f.lastModified() <= this.timestamp) continue;
                    ret = false;
                    break;
                }
            }
            return ret;
        }
    }

    static final class ReloadContext {
        final NbGradleProjectImpl project;
        final GradleProject previous;
        final NbGradleProject.Quality aim;
        String[] args = new String[0];

        public ReloadContext(NbGradleProjectImpl project, GradleProject previous, NbGradleProject.Quality aim) {
            this.project = project;
            this.previous = previous;
            this.aim = aim;
        }

        public GradleProject getPrevious() {
            return this.previous;
        }

        public NbGradleProject.Quality getAim() {
            return this.aim;
        }
    }

    private static class ProjectLoaderTask
    implements Callable<GradleProject>,
    Cancellable {
        private final ReloadContext ctx;
        private CancellationTokenSource tokenSource;

        public ProjectLoaderTask(ReloadContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public GradleProject call() throws Exception {
            this.tokenSource = GradleConnector.newCancellationTokenSource();
            ProgressHandle handle = ProgressHandle.createHandle((String)Bundle.LBL_Loading(this.ctx.previous.getBaseProject().getName()), (Cancellable)this);
            ProgressListener pl = pe -> handle.progress(pe.getDescription());
            handle.start();
            try {
                GradleProject gradleProject = GradleProjectCache.loadGradleProject(this.ctx, this.tokenSource.token(), pl);
                return gradleProject;
            }
            catch (Throwable ex) {
                LOG.log(Level.WARNING, ex.getMessage(), ex);
                throw ex;
            }
            finally {
                handle.finish();
            }
        }

        public boolean cancel() {
            if (this.tokenSource != null) {
                this.tokenSource.cancel();
            }
            return true;
        }
    }

    private static class NbProjectInfoAction
    implements Serializable,
    BuildAction<NbProjectInfo> {
        private NbProjectInfoAction() {
        }

        public NbProjectInfo execute(BuildController bc) {
            return (NbProjectInfo)bc.getModel(NbProjectInfo.class);
        }
    }

    private static enum GoOnline {
        NEVER,
        ON_DEMAND,
        ALWAYS;

    }
}

