/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.api;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.netbeans.modules.gradle.java.api.Bundle;
import org.netbeans.modules.gradle.spi.Utils;

public final class GradleJavaSourceSet
implements Serializable {
    public static final String MAIN_SOURCESET_NAME = "main";
    public static final String TEST_SOURCESET_NAME = "test";
    private static final String DEFAULT_SOURCE_COMPATIBILITY = "1.5";
    Map<SourceType, Set<File>> sources = new EnumMap<SourceType, Set<File>>(SourceType.class);
    String name;
    String runtimeConfigurationName;
    String compileConfigurationName;
    Map<SourceType, String> sourcesCompatibility = Collections.emptyMap();
    Map<SourceType, String> targetCompatibility = Collections.emptyMap();
    Map<SourceType, List<String>> compilerArgs = Collections.emptyMap();
    boolean testSourceSet;
    Set<File> outputClassDirs;
    File outputResources;
    File webApp;
    Set<File> compileClassPath;
    Set<File> runtimeClassPath;
    Set<GradleJavaSourceSet> sourceDependencies = Collections.emptySet();

    public GradleJavaSourceSet(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTestSourceSet() {
        return this.testSourceSet;
    }

    @Deprecated
    public String getSourcesCompatibility() {
        return this.getSourcesCompatibility(SourceType.JAVA);
    }

    public String getSourcesCompatibility(SourceType type) {
        return this.sourcesCompatibility.getOrDefault((Object)type, DEFAULT_SOURCE_COMPATIBILITY);
    }

    @Deprecated
    public String getTargetCompatibility() {
        return this.getTargetCompatibility(SourceType.JAVA);
    }

    public String getTargetCompatibility(SourceType type) {
        return this.targetCompatibility.getOrDefault((Object)type, this.getSourcesCompatibility(type));
    }

    public String getRuntimeConfigurationName() {
        return this.runtimeConfigurationName;
    }

    public String getCompileConfigurationName() {
        return this.compileConfigurationName;
    }

    public Set<File> getSourceDirs(SourceType type) {
        Set<File> ret = this.sources.get((Object)type);
        return ret != null ? ret : Collections.emptySet();
    }

    public final Set<File> getJavaDirs() {
        return this.getSourceDirs(SourceType.JAVA);
    }

    public final Set<File> getGroovyDirs() {
        return this.getSourceDirs(SourceType.GROOVY);
    }

    public final Set<File> getScalaDirs() {
        return this.getSourceDirs(SourceType.SCALA);
    }

    public final Set<File> getResourcesDirs() {
        return this.getSourceDirs(SourceType.RESOURCES);
    }

    public final Collection<File> getAllDirs(boolean deduplicate) {
        HashSet<File> ret;
        AbstractCollection abstractCollection = ret = deduplicate ? new HashSet() : new ArrayList();
        if (this.sources != null) {
            for (Set<File> s : this.sources.values()) {
                ret.addAll(s);
            }
        }
        return ret;
    }

    public final Collection<File> getAllDirs() {
        return this.getAllDirs(true);
    }

    public final Collection<File> getAvailableDirs(boolean deduplicate) {
        HashSet<File> ret;
        AbstractCollection abstractCollection = ret = deduplicate ? new HashSet() : new ArrayList();
        if (this.sources != null) {
            for (Set<File> s : this.sources.values()) {
                for (File f : s) {
                    if (!f.isDirectory()) continue;
                    ret.add(f);
                }
            }
        }
        return ret;
    }

    public final Collection<File> getAvailableDirs() {
        return this.getAvailableDirs(true);
    }

    public Set<File> getCompileClassPath() {
        return this.compileClassPath != null ? this.compileClassPath : Collections.emptySet();
    }

    public Set<File> getRuntimeClassPath() {
        return this.runtimeClassPath != null ? this.runtimeClassPath : this.getCompileClassPath();
    }

    public SourceType getSourceType(File f) {
        for (SourceType type : this.sources.keySet()) {
            Set<File> dirs = this.sources.get((Object)type);
            for (File dir : dirs) {
                if (!GradleJavaSourceSet.parentOrSame(f, dir)) continue;
                return type;
            }
        }
        return null;
    }

    public boolean hasOverlappingSourceDirs() {
        HashSet<File> check = new HashSet<File>();
        for (SourceType type : SourceType.values()) {
            for (File f : this.getSourceDirs(type)) {
                if (check.add(f)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<SourceType> getSourceTypes(File f) {
        EnumSet<SourceType> ret = EnumSet.noneOf(SourceType.class);
        for (SourceType type : this.sources.keySet()) {
            Set<File> dirs = this.sources.get((Object)type);
            for (File dir : dirs) {
                if (!GradleJavaSourceSet.parentOrSame(f, dir)) continue;
                ret.add(type);
            }
        }
        return ret;
    }

    public boolean outputContains(File f) {
        LinkedList<File> checkList = new LinkedList<File>(this.getOutputClassDirs());
        if (this.outputResources != null) {
            checkList.add(this.outputResources);
        }
        for (File check : checkList) {
            if (!GradleJavaSourceSet.parentOrSame(f, check)) continue;
            return true;
        }
        return false;
    }

    public Set<File> getOutputClassDirs() {
        return this.outputClassDirs != null ? this.outputClassDirs : Collections.emptySet();
    }

    public File getOutputResources() {
        return this.outputResources;
    }

    public Set<GradleJavaSourceSet> getSourceDependencies() {
        return this.sourceDependencies;
    }

    public boolean contains(File f) {
        boolean web = this.webApp != null && GradleJavaSourceSet.parentOrSame(f, this.webApp);
        return web || this.outputContains(f) || this.getSourceType(f) != null;
    }

    public File findResource(String name) {
        return this.findResource(name, true, new SourceType[0]);
    }

    public File findResource(String name, boolean includeOutputs, SourceType ... types) {
        ArrayList<File> roots = new ArrayList<File>();
        if (includeOutputs) {
            roots.addAll(this.outputClassDirs);
            if (this.outputResources != null) {
                roots.add(this.outputResources);
            }
        }
        SourceType[] checkedRoots = types.length > 0 ? types : SourceType.values();
        for (SourceType checkedRoot : checkedRoots) {
            roots.addAll(this.getSourceDirs(checkedRoot));
        }
        for (File root : roots) {
            File test = new File(root, name);
            if (!test.exists()) continue;
            return test;
        }
        return null;
    }

    public String relativePath(File f) {
        if (!f.isAbsolute()) {
            return null;
        }
        ArrayList<Path> roots = new ArrayList<Path>();
        for (File dir : this.getAllDirs()) {
            roots.add(dir.toPath());
        }
        for (File dir : this.getOutputClassDirs()) {
            roots.add(dir.toPath());
        }
        if (this.outputResources != null) {
            roots.add(this.outputResources.toPath());
        }
        Path path = f.toPath();
        for (Path root : roots) {
            if (!path.startsWith(root)) continue;
            return root.relativize(path).toString().replace('\\', '/');
        }
        return null;
    }

    public String toString() {
        return "JavaSourceSet[" + this.name + "]";
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GradleJavaSourceSet other = (GradleJavaSourceSet)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.sources, other.sources)) {
            return false;
        }
        if (!Objects.equals(this.outputClassDirs, other.outputClassDirs)) {
            return false;
        }
        if (!Objects.equals(this.outputResources, other.outputResources)) {
            return false;
        }
        if (!Objects.equals(this.webApp, other.webApp)) {
            return false;
        }
        if (!Objects.equals(this.compileClassPath, other.compileClassPath)) {
            return false;
        }
        if (!Objects.equals(this.runtimeClassPath, other.runtimeClassPath)) {
            return false;
        }
        return Objects.equals(this.sourceDependencies, other.sourceDependencies);
    }

    static boolean parentOrSame(File f, File supposedParent) {
        if (f == null || supposedParent == null) {
            return false;
        }
        boolean ret = supposedParent.equals(f);
        File sparent = supposedParent.getParentFile();
        for (File parent = f; !ret && parent != null && !parent.equals(sparent); parent = parent.getParentFile()) {
            ret = supposedParent.equals(parent);
        }
        return ret;
    }

    public String getBuildTaskName(SourceType type) {
        switch (type) {
            case RESOURCES: {
                return this.getProcessResourcesTaskName();
            }
            case JAVA: {
                return this.getCompileTaskName("Java");
            }
            case GROOVY: {
                return this.getCompileTaskName("Groovy");
            }
            case SCALA: {
                return this.getCompileTaskName("Scala");
            }
        }
        return null;
    }

    public List<String> getCompilerArgs(SourceType type) {
        List<String> args = this.compilerArgs.get((Object)type);
        return args != null ? args : Collections.emptyList();
    }

    public String getCompileTaskName(String language) {
        return this.getTaskName("compile", language);
    }

    public String getProcessResourcesTaskName() {
        return this.getTaskName("process", "Resources");
    }

    public String getClassesTaskName() {
        return this.getTaskName("classes", null);
    }

    public String getTaskName(String verb, String target) {
        String n = MAIN_SOURCESET_NAME.equals(this.name) ? "" : Utils.capitalize((String)this.name);
        String t = target == null ? "" : Utils.capitalize((String)target);
        return verb + n + t;
    }

    public static enum ClassPathType {
        COMPILE,
        RUNTIME;

    }

    public static enum SourceType {
        JAVA,
        GROOVY,
        SCALA,
        RESOURCES;


        public String toString() {
            switch (this) {
                case JAVA: {
                    return Bundle.LBL_JAVA();
                }
                case GROOVY: {
                    return Bundle.LBL_GROOVY();
                }
                case SCALA: {
                    return Bundle.LBL_SCALA();
                }
            }
            return Bundle.LBL_RESOURCES();
        }
    }
}

