/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.frames;

import com.sun.jdi.StringReference;
import java.io.InvalidObjectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.truffle.LanguageName;
import org.netbeans.modules.debugger.jpda.truffle.access.CurrentPCInfo;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.modules.debugger.jpda.truffle.source.Source;
import org.netbeans.modules.debugger.jpda.truffle.source.SourcePosition;
import org.netbeans.modules.debugger.jpda.truffle.vars.impl.TruffleScope;
import org.openide.util.Exceptions;

public final class TruffleStackFrame {
    private static final Logger LOG = Logger.getLogger(TruffleStackFrame.class.getName());
    private final JPDADebugger debugger;
    private final JPDAThread thread;
    private final int depth;
    private final ObjectVariable frameInstance;
    private final String methodName;
    private final LanguageName language;
    private final String sourceLocation;
    private final int sourceId;
    private final String sourceName;
    private final String hostClassName;
    private final String hostMethodName;
    private final String sourcePath;
    private final URI sourceURI;
    private final String mimeType;
    private final String sourceSection;
    private final StringReference codeRef;
    private TruffleScope[] scopes;
    private final ObjectVariable thisObject;
    private final boolean isInternal;
    private final boolean isHost;

    public TruffleStackFrame(JPDADebugger debugger, JPDAThread thread, int depth, ObjectVariable frameInstance, String frameDefinition, StringReference codeRef, TruffleScope[] scopes, ObjectVariable thisObject, boolean includeInternal) {
        if (LOG.isLoggable(Level.FINE)) {
            try {
                LOG.fine("new TruffleStackFrame(" + depth + ", " + frameInstance.getToStringValue() + " of type " + frameInstance.getClassType().getName() + ", " + frameDefinition + ", vars = " + Arrays.toString(scopes) + ", " + thisObject + ")");
            }
            catch (InvalidExpressionException iex) {
                LOG.log(Level.FINE, iex.getMessage(), iex);
            }
        }
        this.debugger = debugger;
        this.thread = thread;
        this.depth = depth;
        this.frameInstance = frameInstance;
        boolean internalFrame = includeInternal;
        try {
            int i1 = 0;
            int i2 = frameDefinition.indexOf(10);
            this.methodName = frameDefinition.substring(i1, i2);
            i1 = i2 + 1;
            i2 = frameDefinition.indexOf(10, i1);
            this.isHost = Boolean.valueOf(frameDefinition.substring(i1, i2));
            i1 = i2 + 1;
            i2 = frameDefinition.indexOf(10, i1);
            this.language = LanguageName.parse(frameDefinition.substring(i1, i2));
            i1 = i2 + 1;
            i2 = frameDefinition.indexOf(10, i1);
            this.sourceLocation = frameDefinition.substring(i1, i2);
            i1 = i2 + 1;
            i2 = frameDefinition.indexOf(10, i1);
            this.sourceId = Integer.parseInt(frameDefinition.substring(i1, i2));
            i1 = i2 + 1;
            i2 = frameDefinition.indexOf(10, i1);
            this.sourceName = frameDefinition.substring(i1, i2);
            i1 = i2 + 1;
            i2 = frameDefinition.indexOf(10, i1);
            this.sourcePath = frameDefinition.substring(i1, i2);
            i1 = i2 + 1;
            i2 = frameDefinition.indexOf(10, i1);
            this.hostClassName = frameDefinition.substring(i1, i2);
            i1 = i2 + 1;
            i2 = frameDefinition.indexOf(10, i1);
            this.hostMethodName = TruffleStackFrame.stringOrNull(frameDefinition.substring(i1, i2));
            i1 = i2 + 1;
            i2 = frameDefinition.indexOf(10, i1);
            try {
                this.sourceURI = new URI(frameDefinition.substring(i1, i2));
            }
            catch (URISyntaxException usex) {
                throw new IllegalStateException("Bad URI: " + frameDefinition.substring(i1, i2), usex);
            }
            i1 = i2 + 1;
            i2 = frameDefinition.indexOf(10, i1);
            this.mimeType = TruffleStackFrame.stringOrNull(frameDefinition.substring(i1, i2));
            i1 = i2 + 1;
            if (includeInternal) {
                i2 = frameDefinition.indexOf(10, i1);
                this.sourceSection = frameDefinition.substring(i1, i2);
                i1 = i2 + 1;
                internalFrame = Boolean.valueOf(frameDefinition.substring(i1));
            } else {
                this.sourceSection = frameDefinition.substring(i1);
            }
        }
        catch (IndexOutOfBoundsException ioob) {
            throw new IllegalStateException("frameDefinition='" + frameDefinition + "'", ioob);
        }
        this.codeRef = codeRef;
        this.scopes = scopes;
        this.thisObject = thisObject;
        this.isInternal = internalFrame;
    }

    private static String stringOrNull(String str) {
        if ("null".equals(str)) {
            return null;
        }
        return str;
    }

    public final JPDADebugger getDebugger() {
        return this.debugger;
    }

    public final JPDAThread getThread() {
        return this.thread;
    }

    public final int getDepth() {
        return this.depth;
    }

    public String getHostClassName() {
        return this.hostClassName;
    }

    public String getHostMethodName() {
        return this.hostMethodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public LanguageName getLanguage() {
        return this.language;
    }

    public String getSourceLocation() {
        return this.sourceLocation;
    }

    public String getDisplayName() {
        if (!this.methodName.isEmpty()) {
            return this.methodName + " (" + this.sourceLocation + ")";
        }
        return this.sourceLocation;
    }

    public SourcePosition getSourcePosition() {
        Source src = Source.getExistingSource(this.debugger, this.sourceId);
        if (src == null) {
            src = Source.getSource(this.debugger, this.sourceId, this.sourceName, this.hostMethodName, this.sourcePath, this.sourceURI, this.mimeType, this.codeRef);
        }
        SourcePosition sp = new SourcePosition(this.debugger, this.sourceId, src, this.sourceSection);
        return sp;
    }

    public ObjectVariable getStackFrameInstance() {
        return this.frameInstance;
    }

    public TruffleScope[] getScopes() {
        if (this.scopes == null) {
            this.scopes = TruffleAccess.createFrameScopes(this.debugger, (Variable)this.getStackFrameInstance());
        }
        return this.scopes;
    }

    public void popToHere() {
        boolean unwindScheduled;
        if (this.depth > 0 && (unwindScheduled = TruffleAccess.unwind(this.debugger, this.thread, this.depth - 1))) {
            CurrentPCInfo currentPCInfo = TruffleAccess.getCurrentGuestPCInfo(this.thread);
            try {
                currentPCInfo.getStepCommandVar().setFromMirrorObject((Object)-1);
                this.thread.resume();
            }
            catch (InvalidObjectException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public ObjectVariable getThis() {
        return this.thisObject;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public boolean isHost() {
        return this.isHost;
    }
}

