/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.runtime;

import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.spi.db.explorer.DatabaseRuntime;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public final class DatabaseRuntimeManager {
    private static final Logger LOGGER = Logger.getLogger(DatabaseRuntimeManager.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private static final String RUNTIMES_PATH = "Databases/Runtimes";
    private static DatabaseRuntimeManager DEFAULT = null;
    private Lookup.Result<DatabaseRuntime> result = this.getLookupResult();

    public static synchronized DatabaseRuntimeManager getDefault() {
        if (DEFAULT == null) {
            LOGGER.finest("Instantiated DatabaseRuntimeManager.");
            DEFAULT = new DatabaseRuntimeManager();
        }
        return DEFAULT;
    }

    public DatabaseRuntime[] getRuntimes() {
        Collection runtimes = this.result.allInstances();
        return runtimes.toArray(new DatabaseRuntime[runtimes.size()]);
    }

    public static synchronized boolean isInstantiated() {
        LOGGER.finest("Is DatabaseRuntimeManager instantiated? " + (DEFAULT != null));
        return DEFAULT != null;
    }

    public DatabaseRuntime[] getRuntimes(String jdbcDriverClassName) {
        if (jdbcDriverClassName == null) {
            throw new NullPointerException();
        }
        LinkedList<DatabaseRuntime> runtimeList = new LinkedList<DatabaseRuntime>();
        for (DatabaseRuntime runtime : this.result.allInstances()) {
            if (LOG) {
                LOGGER.log(Level.FINE, "Runtime: " + runtime.getClass().getName() + " for driver " + runtime.getJDBCDriverClass());
            }
            if (!jdbcDriverClassName.equals(runtime.getJDBCDriverClass())) continue;
            runtimeList.add(runtime);
        }
        return runtimeList.toArray(new DatabaseRuntime[runtimeList.size()]);
    }

    private synchronized Lookup.Result<DatabaseRuntime> getLookupResult() {
        return Lookups.forPath((String)RUNTIMES_PATH).lookupResult(DatabaseRuntime.class);
    }
}

