/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.driver;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class JDBCDriverConvertor
implements Environment.Provider,
InstanceCookie.Of {
    private static Reference<JDBCDriverConvertor> providerRef;
    public static final String DRIVERS_PATH = "Databases/JDBCDrivers";
    private static final int DELAY = 2000;
    private static final WeakHashMap<JDBCDriver, DataObject> newDriver2DO;
    private static final Map<FileObject, JDBCDriver> newFile2Driver;
    private final Reference holder;
    private Lookup lookup;
    private Reference refDriver = new WeakReference<Object>(null);

    private static synchronized JDBCDriverConvertor createProvider() {
        JDBCDriverConvertor provider = null;
        if (providerRef != null) {
            provider = providerRef.get();
        }
        if (provider == null) {
            provider = new JDBCDriverConvertor();
            providerRef = new WeakReference<JDBCDriverConvertor>(provider);
        }
        return provider;
    }

    private JDBCDriverConvertor() {
        this.holder = new WeakReference<Object>(null);
    }

    private JDBCDriverConvertor(XMLDataObject object) {
        this.holder = new WeakReference<XMLDataObject>(object);
        InstanceContent cookies = new InstanceContent();
        cookies.add((Object)this);
        this.lookup = new AbstractLookup((AbstractLookup.Content)cookies);
    }

    private JDBCDriverConvertor(XMLDataObject object, JDBCDriver existingInstance) {
        this(object);
        this.refDriver = new WeakReference<JDBCDriver>(existingInstance);
    }

    public Lookup getEnvironment(DataObject obj) {
        JDBCDriver existingInstance = newFile2Driver.remove(obj.getPrimaryFile());
        if (existingInstance != null) {
            return new JDBCDriverConvertor((XMLDataObject)obj, existingInstance).getLookup();
        }
        return new JDBCDriverConvertor((XMLDataObject)obj).getLookup();
    }

    public String instanceName() {
        XMLDataObject obj = this.getHolder();
        return obj == null ? "" : obj.getName();
    }

    public Class instanceClass() {
        return JDBCDriver.class;
    }

    public boolean instanceOf(Class type) {
        return type.isAssignableFrom(JDBCDriver.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object instanceCreate() throws IOException, ClassNotFoundException {
        JDBCDriverConvertor jDBCDriverConvertor = this;
        synchronized (jDBCDriverConvertor) {
            Object o = this.refDriver.get();
            if (o != null) {
                return o;
            }
            XMLDataObject obj = this.getHolder();
            if (obj == null) {
                return null;
            }
            try {
                JDBCDriver inst = JDBCDriverConvertor.readDriverFromFile(obj.getPrimaryFile());
                this.refDriver = new WeakReference<JDBCDriver>(inst);
                return inst;
            }
            catch (MalformedURLException e) {
                String message = "Ignoring " + obj.getPrimaryFile();
                Logger.getLogger(JDBCDriverConvertor.class.getName()).log(Level.INFO, message, e);
                return null;
            }
        }
    }

    private XMLDataObject getHolder() {
        return (XMLDataObject)this.holder.get();
    }

    private static JDBCDriver readDriverFromFile(FileObject fo) throws IOException, MalformedURLException {
        Handler handler = new Handler();
        try {
            XMLReader reader = XMLUtil.createXMLReader();
            InputSource is = new InputSource(fo.getInputStream());
            is.setSystemId(fo.toURL().toExternalForm());
            reader.setContentHandler(handler);
            reader.setErrorHandler(handler);
            reader.setEntityResolver((EntityResolver)EntityCatalog.getDefault());
            reader.parse(is);
        }
        catch (SAXException ex) {
            throw new IOException(ex.getMessage());
        }
        URL[] urls = new URL[handler.urls.size()];
        int j = 0;
        Iterator i = handler.urls.iterator();
        while (i.hasNext()) {
            urls[j] = new URL((String)i.next());
            ++j;
        }
        if (!JDBCDriverConvertor.checkClassPathDrivers(handler.clazz, urls)) {
            return null;
        }
        if (handler.displayName == null) {
            handler.displayName = handler.name;
        }
        return JDBCDriver.create(handler.name, handler.displayName, handler.clazz, urls);
    }

    public static DataObject create(JDBCDriver drv) throws IOException {
        FileObject fo = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)DRIVERS_PATH);
        DataFolder df = DataFolder.findFolder((FileObject)fo);
        String fileName = drv.getClassName().replace('.', '_');
        AtomicWriter writer = new AtomicWriter(drv, df, fileName);
        df.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)writer);
        return writer.holder;
    }

    static URL encodeURL(URL url) throws MalformedURLException, URISyntaxException {
        String urlString = url.toExternalForm();
        int colon = urlString.indexOf(58);
        int pound = urlString.indexOf(35);
        String fragment = null;
        String part = urlString.substring(colon + 1, pound != -1 ? pound : urlString.length());
        if (pound != -1) {
            fragment = urlString.substring(pound + 1, urlString.length());
        }
        return new URI(url.getProtocol(), part, fragment).toURL();
    }

    public static void remove(JDBCDriver drv) throws IOException {
        String name = drv.getName();
        FileObject fo = FileUtil.getConfigFile((String)DRIVERS_PATH);
        if (fo == null) {
            return;
        }
        DataFolder folder = DataFolder.findFolder((FileObject)fo);
        DataObject[] objects = folder.getChildren();
        for (int i = 0; i < objects.length; ++i) {
            InstanceCookie ic = (InstanceCookie)objects[i].getCookie(InstanceCookie.class);
            if (ic == null) continue;
            try {
                JDBCDriver driver;
                Object obj = ic.instanceCreate();
                if (!(obj instanceof JDBCDriver) || !(driver = (JDBCDriver)obj).getName().equals(name)) continue;
                objects[i].delete();
                break;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
    }

    Lookup getLookup() {
        return this.lookup;
    }

    private static boolean checkClassPathDrivers(String className, URL[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            if (!"file:/".equals(urls[i].toString())) continue;
            try {
                Class.forName(className);
                continue;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        return true;
    }

    static {
        newDriver2DO = new WeakHashMap();
        newFile2Driver = new ConcurrentHashMap<FileObject, JDBCDriver>();
    }

    private static final class Handler
    extends DefaultHandler {
        private static final String ELEMENT_NAME = "name";
        private static final String ELEMENT_DISPLAY_NAME = "display-name";
        private static final String ELEMENT_CLASS = "class";
        private static final String ELEMENT_URL = "url";
        private static final String ATTR_PROPERTY_VALUE = "value";
        String name;
        String displayName;
        String clazz;
        LinkedList urls = new LinkedList();

        private Handler() {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (ELEMENT_NAME.equals(qName)) {
                this.name = attrs.getValue(ATTR_PROPERTY_VALUE);
            } else if (ELEMENT_DISPLAY_NAME.equals(qName)) {
                this.displayName = attrs.getValue(ATTR_PROPERTY_VALUE);
            } else if (ELEMENT_CLASS.equals(qName)) {
                this.clazz = attrs.getValue(ATTR_PROPERTY_VALUE);
            } else if (ELEMENT_URL.equals(qName)) {
                this.urls.add(attrs.getValue(ATTR_PROPERTY_VALUE));
            }
        }
    }

    private static final class AtomicWriter
    implements FileSystem.AtomicAction {
        JDBCDriver instance;
        MultiDataObject holder;
        String fileName;
        DataFolder parent;

        AtomicWriter(JDBCDriver instance, MultiDataObject holder) {
            this.instance = instance;
            this.holder = holder;
        }

        AtomicWriter(JDBCDriver instance, DataFolder parent, String fileName) {
            this.instance = instance;
            this.fileName = fileName;
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            FileLock lck;
            FileObject data;
            if (this.holder != null) {
                data = this.holder.getPrimaryEntry().getFile();
                lck = this.holder.getPrimaryEntry().takeLock();
            } else {
                FileObject folder = this.parent.getPrimaryFile();
                String fn = FileUtil.findFreeFileName((FileObject)folder, (String)this.fileName, (String)"xml");
                data = folder.createData(fn, "xml");
                lck = data.lock();
            }
            try (OutputStream ostm = data.getOutputStream(lck);
                 PrintWriter writer = new PrintWriter(new OutputStreamWriter(ostm, "UTF8"));){
                this.write(writer);
                writer.flush();
            }
            finally {
                lck.releaseLock();
            }
            if (this.holder == null) {
                newFile2Driver.put(data, this.instance);
                this.holder = (MultiDataObject)DataObject.find((FileObject)data);
                this.holder.getCookie(InstanceCookie.class);
                newDriver2DO.put(this.instance, this.holder);
            }
        }

        void write(PrintWriter pw) throws IOException {
            pw.println("<?xml version='1.0'?>");
            pw.println("<!DOCTYPE driver PUBLIC '-//NetBeans//DTD JDBC Driver 1.1//EN' 'http://www.netbeans.org/dtds/jdbc-driver-1_1.dtd'>");
            pw.println("<driver>");
            pw.println("  <name value='" + XMLUtil.toAttributeValue((String)this.instance.getName()) + "'/>");
            pw.println("  <display-name value='" + XMLUtil.toAttributeValue((String)this.instance.getDisplayName()) + "'/>");
            pw.println("  <class value='" + XMLUtil.toAttributeValue((String)this.instance.getClassName()) + "'/>");
            pw.println("  <urls>");
            URL[] urls = this.instance.getURLs();
            for (int i = 0; i < urls.length; ++i) {
                pw.println("    <url value='" + XMLUtil.toAttributeValue((String)urls[i].toString()) + "'/>");
            }
            pw.println("  </urls>");
            pw.println("</driver>");
        }
    }
}

