/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.action.QueryAction;
import org.netbeans.modules.db.explorer.sql.editor.SQLEditorSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ViewDataAction
extends QueryAction {
    private static final RequestProcessor RP = new RequestProcessor(ViewDataAction.class.getName(), 1);

    public String getName() {
        return NbBundle.getMessage(ViewDataAction.class, (String)"ViewData");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ViewDataAction.class);
    }

    public void performAction(final Node[] activatedNodes) {
        final DatabaseConnection connection = (DatabaseConnection)activatedNodes[0].getLookup().lookup(DatabaseConnection.class);
        if (connection != null) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    String expression = null;
                    try {
                        expression = ViewDataAction.this.getDefaultQuery(activatedNodes);
                        SQLEditorSupport.openSQLEditor(connection.getDatabaseConnection(), expression + ";\n", true);
                    }
                    catch (Exception exc) {
                        Logger.getLogger(ViewDataAction.class.getName()).log(Level.INFO, exc.getLocalizedMessage() + " while executing expression " + expression, exc);
                        String message = NbBundle.getMessage(ViewDataAction.class, (String)"ShowDataError", (Object)exc.getMessage());
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                    }
                }
            });
        }
    }
}

