/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.submodule.SubmoduleStatus;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitSubmoduleStatus;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class SubmoduleStatusCommand
extends GitCommand {
    private final File[] roots;
    private final LinkedHashMap<File, GitSubmoduleStatus> statuses;

    public SubmoduleStatusCommand(Repository repository, GitClassFactory classFactory, File[] roots, ProgressMonitor monitor) {
        super(repository, classFactory, monitor);
        this.roots = roots;
        this.statuses = new LinkedHashMap();
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        File workTree = repository.getWorkTree();
        org.eclipse.jgit.api.SubmoduleStatusCommand cmd = new Git(repository).submoduleStatus();
        for (String path : Utils.getRelativePaths(workTree, this.roots)) {
            cmd.addPath(path);
        }
        try {
            Map result = cmd.call();
            GitClassFactory fac = this.getClassFactory();
            for (Map.Entry e : result.entrySet()) {
                File root = new File(workTree, (String)e.getKey());
                this.statuses.put(root, fac.createSubmoduleStatus((SubmoduleStatus)e.getValue(), root));
            }
        }
        catch (GitAPIException | JGitInternalException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git submodule status");
        for (File root : this.roots) {
            sb.append(" ").append(root.getAbsolutePath());
        }
        return sb.toString();
    }

    public Map<File, GitSubmoduleStatus> getStatuses() {
        return this.statuses;
    }
}

