/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.layout;

import org.netbeans.api.visual.widget.Scene;

public abstract class SceneLayout {
    private Scene.SceneListener listener = new LayoutSceneListener();
    private Scene scene;
    private volatile boolean attached;

    protected SceneLayout(Scene scene) {
        assert (scene != null);
        this.scene = scene;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attach() {
        SceneLayout sceneLayout = this;
        synchronized (sceneLayout) {
            if (this.attached) {
                return;
            }
            this.attached = true;
        }
        this.scene.addSceneListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detach() {
        SceneLayout sceneLayout = this;
        synchronized (sceneLayout) {
            if (!this.attached) {
                return;
            }
            this.attached = false;
        }
        this.scene.removeSceneListener(this.listener);
    }

    public final void invokeLayout() {
        this.attach();
        this.scene.revalidate();
    }

    public final void invokeLayoutImmediately() {
        this.attach();
        this.scene.revalidate();
        this.scene.validate();
    }

    protected abstract void performLayout();

    private final class LayoutSceneListener
    implements Scene.SceneListener {
        private LayoutSceneListener() {
        }

        @Override
        public void sceneRepaint() {
        }

        @Override
        public void sceneValidating() {
        }

        @Override
        public void sceneValidated() {
            SceneLayout.this.detach();
            SceneLayout.this.performLayout();
        }
    }
}

