/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.util.GeomUtil;

public final class ConnectionWidgetLayout
implements Layout {
    private final boolean useStacking = true;
    private final HashMap<Widget, Placement> placements = new HashMap();
    private final HashMap<Placement, ArrayList<Widget>> reverse = new HashMap();

    public void setConstraint(Widget childWidget, LayoutFactory.ConnectionWidgetLayoutAlignment alignment, float placementInPercentage) {
        assert (childWidget != null);
        assert (alignment != null);
        this.setConstraint(childWidget, new Placement(alignment, placementInPercentage));
    }

    public void setConstraint(Widget childWidget, LayoutFactory.ConnectionWidgetLayoutAlignment alignment, int placementAtDistance) {
        assert (childWidget != null);
        assert (alignment != null);
        this.setConstraint(childWidget, new Placement(alignment, placementAtDistance));
    }

    public void removeConstraint(Widget childWidget) {
        assert (childWidget != null);
        this.setConstraint(childWidget, null);
    }

    private void setConstraint(Widget childWidget, Placement newPlacement) {
        Placement oldPlacement = newPlacement != null ? this.placements.put(childWidget, newPlacement) : this.placements.remove(childWidget);
        if (oldPlacement != null && !oldPlacement.equals(newPlacement)) {
            this.reverse.get(oldPlacement).remove(childWidget);
        }
        if (newPlacement != null) {
            ArrayList<Widget> list = this.reverse.get(newPlacement);
            if (list == null) {
                list = new ArrayList();
                this.reverse.put(newPlacement, list);
            }
            list.add(childWidget);
        }
    }

    @Override
    public void layout(Widget widget) {
        ConnectionWidget connectionWidget = (ConnectionWidget)widget;
        connectionWidget.calculateRouting();
        List<Point> controlPoints = connectionWidget.getControlPoints();
        boolean empty = controlPoints == null || controlPoints.size() <= 0;
        double totalDistance = 0.0;
        double[] distances = new double[empty ? 0 : controlPoints.size() - 1];
        for (int i = 0; i < distances.length; ++i) {
            distances[i] = totalDistance += GeomUtil.distanceSq(controlPoints.get(i), controlPoints.get(i + 1));
        }
        ArrayList<Widget> childrenToResolve = new ArrayList<Widget>(widget.getChildren());
        for (Map.Entry<Placement, ArrayList<Widget>> entry : this.reverse.entrySet()) {
            int distance;
            float percentage;
            Placement placement = entry.getKey();
            ArrayList<Widget> currentlyResolving = null;
            for (Widget childWidget : entry.getValue()) {
                if (childWidget.getParentWidget() != widget || !childWidget.isVisible()) continue;
                if (currentlyResolving == null) {
                    currentlyResolving = new ArrayList<Widget>();
                }
                currentlyResolving.add(childWidget);
            }
            if (currentlyResolving == null) continue;
            Point point = empty ? new Point() : (placement.isPercentage ? ((double)(percentage = placement.placementInPercentage) <= 0.0 ? connectionWidget.getFirstControlPoint() : ((double)percentage >= 1.0 ? connectionWidget.getLastControlPoint() : this.getLinePointAtPercentage(distances, (int)((double)percentage * totalDistance), controlPoints))) : ((distance = placement.placementAtDistance) < 0 ? this.getLinePointAtPercentage(distances, distance + (int)totalDistance, controlPoints) : this.getLinePointAtPercentage(distances, distance, controlPoints)));
            this.layoutChildrenAt(point, placement.alignment, connectionWidget, currentlyResolving);
            childrenToResolve.removeAll(currentlyResolving);
        }
        if (!childrenToResolve.isEmpty()) {
            this.layoutChildrenAt(new Point(), null, connectionWidget, childrenToResolve);
        }
    }

    @Override
    public boolean requiresJustification(Widget widget) {
        return false;
    }

    @Override
    public void justify(Widget widget) {
    }

    private Point getLinePointAtPercentage(double[] distances, int lineDistance, List<Point> controlPoints) {
        int index = distances.length - 1;
        for (int i = 0; i < distances.length; ++i) {
            if (!((double)lineDistance < distances[i])) continue;
            index = i;
            break;
        }
        double segmentStartDistance = index > 0 ? distances[index - 1] : 0.0;
        double segmentLength = distances[index] - segmentStartDistance;
        double segmentDistance = (double)lineDistance - segmentStartDistance;
        if (segmentLength == 0.0) {
            return controlPoints.get(index);
        }
        Point p1 = controlPoints.get(index);
        Point p2 = controlPoints.get(index + 1);
        double segmentFactor = segmentDistance / segmentLength;
        return new Point((int)((double)p1.x + (double)(p2.x - p1.x) * segmentFactor), (int)((double)p1.y + (double)(p2.y - p1.y) * segmentFactor));
    }

    private void layoutChildrenAt(Point linePoint, LayoutFactory.ConnectionWidgetLayoutAlignment alignment, ConnectionWidget connectionWidget, ArrayList<Widget> children) {
        if (alignment == null) {
            alignment = LayoutFactory.ConnectionWidgetLayoutAlignment.NONE;
        }
        LayoutFactory.ConnectionWidgetLayoutAlignment adjustedAlignment = this.getAdjustedAlignment(alignment, connectionWidget);
        this.layoutStackedChildrenAt(linePoint, adjustedAlignment, connectionWidget, children);
    }

    private void layoutStackedChildrenAt(Point linePoint, LayoutFactory.ConnectionWidgetLayoutAlignment adjustedAlignment, ConnectionWidget connectionWidget, ArrayList<Widget> children) {
        int areaWidth = 0;
        int areaHeight = 0;
        if (adjustedAlignment != LayoutFactory.ConnectionWidgetLayoutAlignment.NONE) {
            for (Widget childWidget : children) {
                Rectangle bounds = childWidget.getPreferredBounds();
                areaWidth = Math.max(areaWidth, bounds.width);
                areaHeight += bounds.height;
            }
        }
        Point referencePoint = this.getReferencePointForAdjustedAlignment(adjustedAlignment, new Rectangle(areaWidth, areaHeight));
        int areaX = linePoint.x - referencePoint.x;
        int areaY = linePoint.y - referencePoint.y;
        int yCursor = 0;
        for (Widget childWidget : children) {
            Rectangle preferredBounds = childWidget.getPreferredBounds();
            Point location = childWidget.getPreferredLocation();
            int x = areaX - preferredBounds.x;
            int y = areaY + yCursor - preferredBounds.y;
            if (location != null) {
                x += location.x;
                y += location.y;
            }
            switch (adjustedAlignment) {
                case CENTER_LEFT: {
                    break;
                }
                case CENTER_RIGHT: {
                    x += areaWidth - preferredBounds.width;
                    break;
                }
                case CENTER: {
                    x += (areaWidth - preferredBounds.width) / 2;
                }
            }
            yCursor += preferredBounds.height;
            childWidget.resolveBounds(new Point(x, y), preferredBounds);
        }
    }

    private void layoutSingleChildAt(Point linePoint, LayoutFactory.ConnectionWidgetLayoutAlignment alignment, ConnectionWidget connectionWidget, Widget childWidget) {
        Rectangle preferredBounds = childWidget.getPreferredBounds();
        Point referencePoint = this.getReferencePointForAdjustedAlignment(alignment, preferredBounds);
        Point location = childWidget.getPreferredLocation();
        if (location != null) {
            referencePoint.translate(-location.x, -location.y);
        }
        childWidget.resolveBounds(new Point(linePoint.x - referencePoint.x, linePoint.y - referencePoint.y), preferredBounds);
    }

    private LayoutFactory.ConnectionWidgetLayoutAlignment getAdjustedHorizontalAlignment(LayoutFactory.ConnectionWidgetLayoutAlignment adjustedAlignment) {
        switch (adjustedAlignment) {
            case CENTER_LEFT: 
            case TOP_LEFT: 
            case BOTTOM_LEFT: {
                return LayoutFactory.ConnectionWidgetLayoutAlignment.CENTER_LEFT;
            }
            case CENTER_RIGHT: 
            case TOP_RIGHT: 
            case BOTTOM_RIGHT: {
                return LayoutFactory.ConnectionWidgetLayoutAlignment.CENTER_RIGHT;
            }
            case CENTER: 
            case TOP_CENTER: 
            case BOTTOM_CENTER: {
                return LayoutFactory.ConnectionWidgetLayoutAlignment.CENTER;
            }
        }
        return LayoutFactory.ConnectionWidgetLayoutAlignment.NONE;
    }

    private Point getReferencePointForAdjustedAlignment(LayoutFactory.ConnectionWidgetLayoutAlignment adjustedAlignment, Rectangle rectangle) {
        switch (adjustedAlignment) {
            case BOTTOM_CENTER: {
                return new Point(GeomUtil.centerX(rectangle), rectangle.y - 1);
            }
            case BOTTOM_LEFT: {
                return new Point(rectangle.x + rectangle.width, rectangle.y - 1);
            }
            case BOTTOM_RIGHT: {
                return new Point(rectangle.x - 1, rectangle.y - 1);
            }
            case CENTER: {
                return GeomUtil.center(rectangle);
            }
            case CENTER_LEFT: {
                return new Point(rectangle.x + rectangle.width, GeomUtil.centerY(rectangle));
            }
            case CENTER_RIGHT: {
                return new Point(rectangle.x - 1, GeomUtil.centerY(rectangle));
            }
            case NONE: {
                return new Point();
            }
            case TOP_CENTER: {
                return new Point(GeomUtil.centerX(rectangle), rectangle.y + rectangle.height);
            }
            case TOP_LEFT: {
                return new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            }
            case TOP_RIGHT: {
                return new Point(rectangle.x - 1, rectangle.y + rectangle.height);
            }
        }
        return new Point();
    }

    private LayoutFactory.ConnectionWidgetLayoutAlignment getAdjustedAlignment(LayoutFactory.ConnectionWidgetLayoutAlignment alignment, ConnectionWidget connectionWidget) {
        LayoutFactory.ConnectionWidgetLayoutAlignment retVal = alignment;
        if (alignment == LayoutFactory.ConnectionWidgetLayoutAlignment.CENTER_SOURCE) {
            Point sourcePt = connectionWidget.getFirstControlPoint();
            Rectangle sourceBounds = this.getSourceBounds(connectionWidget);
            retVal = this.calculateBestCenterAlignment(sourcePt, sourceBounds);
        } else if (alignment == LayoutFactory.ConnectionWidgetLayoutAlignment.CENTER_TARGET) {
            Point targetPt = connectionWidget.getLastControlPoint();
            Rectangle targetBounds = this.getTargetBounds(connectionWidget);
            retVal = this.calculateBestCenterAlignment(targetPt, targetBounds);
        } else if (alignment == LayoutFactory.ConnectionWidgetLayoutAlignment.BOTTOM_SOURCE) {
            Point sourcePt = connectionWidget.getFirstControlPoint();
            Rectangle sourceBounds = this.getSourceBounds(connectionWidget);
            retVal = this.calculateBestBottomAlignment(sourcePt, sourceBounds);
        } else if (alignment == LayoutFactory.ConnectionWidgetLayoutAlignment.BOTTOM_TARGET) {
            Point targetPt = connectionWidget.getLastControlPoint();
            Rectangle targetBounds = this.getTargetBounds(connectionWidget);
            retVal = this.calculateBestBottomAlignment(targetPt, targetBounds);
        } else if (alignment == LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_SOURCE) {
            Point sourcePt = connectionWidget.getFirstControlPoint();
            Rectangle sourceBounds = this.getSourceBounds(connectionWidget);
            retVal = this.calculateBestTopAlignment(sourcePt, sourceBounds);
        } else if (alignment == LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_TARGET) {
            Point targetPt = connectionWidget.getLastControlPoint();
            Rectangle targetBounds = this.getTargetBounds(connectionWidget);
            retVal = this.calculateBestTopAlignment(targetPt, targetBounds);
        }
        return retVal;
    }

    private LayoutFactory.ConnectionWidgetLayoutAlignment calculateBestCenterAlignment(Point point, Rectangle bounds) {
        LayoutFactory.ConnectionWidgetLayoutAlignment retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.NONE;
        if (bounds != null) {
            if (point.x <= bounds.x) {
                retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.CENTER_LEFT;
            } else if (point.x >= bounds.x + bounds.width) {
                retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.CENTER_RIGHT;
            } else if (point.y <= bounds.y) {
                retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_CENTER;
            } else if (point.y >= bounds.y + bounds.height) {
                retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.BOTTOM_CENTER;
            }
        }
        return retVal;
    }

    private LayoutFactory.ConnectionWidgetLayoutAlignment calculateBestBottomAlignment(Point point, Rectangle bounds) {
        LayoutFactory.ConnectionWidgetLayoutAlignment retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.NONE;
        if (point.x <= bounds.x) {
            retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.BOTTOM_LEFT;
        } else if (point.x >= bounds.x + bounds.width) {
            retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.BOTTOM_RIGHT;
        } else if (point.y <= bounds.y) {
            retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_RIGHT;
        } else if (point.y >= bounds.y + bounds.height) {
            retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.BOTTOM_LEFT;
        }
        return retVal;
    }

    private LayoutFactory.ConnectionWidgetLayoutAlignment calculateBestTopAlignment(Point point, Rectangle bounds) {
        LayoutFactory.ConnectionWidgetLayoutAlignment retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.NONE;
        if (point.x <= bounds.x) {
            retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_LEFT;
        } else if (point.x >= bounds.x + bounds.width) {
            retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_RIGHT;
        } else if (point.y <= bounds.y) {
            retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_LEFT;
        } else if (point.y >= bounds.y + bounds.height) {
            retVal = LayoutFactory.ConnectionWidgetLayoutAlignment.BOTTOM_RIGHT;
        }
        return retVal;
    }

    private Rectangle getSourceBounds(ConnectionWidget connectionWidget) {
        Widget source = connectionWidget.getSourceAnchor().getRelatedWidget();
        if (source == null) {
            return null;
        }
        Point sourceLocation = source.getLocation();
        Rectangle clientArea = source.getClientArea();
        return new Rectangle(sourceLocation, clientArea.getSize());
    }

    private Rectangle getTargetBounds(ConnectionWidget connectionWidget) {
        Widget target = connectionWidget.getTargetAnchor().getRelatedWidget();
        if (target == null) {
            return null;
        }
        Point targetLocation = target.getLocation();
        Rectangle targetArea = target.getClientArea();
        return new Rectangle(targetLocation, targetArea.getSize());
    }

    private static class Placement {
        private final LayoutFactory.ConnectionWidgetLayoutAlignment alignment;
        private final boolean isPercentage;
        private final float placementInPercentage;
        private final int placementAtDistance;

        public Placement(LayoutFactory.ConnectionWidgetLayoutAlignment alignment, float placementInPercentage) {
            this.alignment = alignment;
            this.isPercentage = true;
            this.placementInPercentage = placementInPercentage;
            this.placementAtDistance = 0;
        }

        public Placement(LayoutFactory.ConnectionWidgetLayoutAlignment alignment, int placementAtDistance) {
            this.alignment = alignment;
            this.isPercentage = false;
            this.placementInPercentage = 0.0f;
            this.placementAtDistance = placementAtDistance;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Placement other = (Placement)obj;
            if (this.alignment != other.alignment) {
                return false;
            }
            if (this.isPercentage != other.isPercentage) {
                return false;
            }
            if (this.placementInPercentage != other.placementInPercentage) {
                return false;
            }
            return this.placementAtDistance == other.placementAtDistance;
        }

        public int hashCode() {
            int hash = 3;
            hash = 17 * hash + (this.alignment != null ? this.alignment.hashCode() : 0);
            hash = 17 * hash + (this.isPercentage ? 1 : 0);
            hash = 17 * hash + Float.floatToIntBits(this.placementInPercentage);
            hash = 17 * hash + this.placementAtDistance;
            return hash;
        }
    }
}

