/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.progress;

import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.netbeans.modules.progress.spi.RunOffEDTProvider;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class ProgressUtils {
    private static final RunOffEDTProvider PROVIDER = ProgressUtils.getProvider();
    private static final int DISPLAY_DIALOG_MS = 9450;
    private static final int DISPLAY_WAIT_CURSOR_MS = 50;

    private ProgressUtils() {
    }

    private static RunOffEDTProvider getProvider() {
        RunOffEDTProvider p = (RunOffEDTProvider)Lookup.getDefault().lookup(RunOffEDTProvider.class);
        return p != null ? p : new Trivial();
    }

    @Deprecated
    public static void runOffEventDispatchThread(Runnable operation, String operationDescr, AtomicBoolean cancelOperation, boolean waitForCanceled) {
        BaseProgressUtils.runOffEventDispatchThread((Runnable)operation, (String)operationDescr, (AtomicBoolean)cancelOperation, (boolean)waitForCanceled, (int)50, (int)9450);
    }

    @Deprecated
    public static void runOffEventDispatchThread(Runnable operation, String operationDescr, AtomicBoolean cancelOperation, boolean waitForCanceled, int waitCursorAfter, int dialogAfter) {
        BaseProgressUtils.runOffEventDispatchThread((Runnable)operation, (String)operationDescr, (AtomicBoolean)cancelOperation, (boolean)waitForCanceled, (int)waitCursorAfter, (int)dialogAfter);
    }

    @Deprecated
    public static void showProgressDialogAndRun(Runnable operation, ProgressHandle progress, boolean includeDetailLabel) {
        BaseProgressUtils.showProgressDialogAndRun((Runnable)operation, (ProgressHandle)progress, (boolean)includeDetailLabel);
    }

    @Deprecated
    public static void runOffEventThreadWithProgressDialog(Runnable operation, String dialogTitle, ProgressHandle progress, boolean includeDetailLabel, int waitCursorAfter, int dialogAfter) {
        BaseProgressUtils.runOffEventThreadWithProgressDialog((Runnable)operation, (String)dialogTitle, (ProgressHandle)progress, (boolean)includeDetailLabel, (int)waitCursorAfter, (int)dialogAfter);
    }

    @Deprecated
    public static void runOffEventThreadWithCustomDialogContent(Runnable operation, String dialogTitle, JPanel content, int waitCursorAfter, int dialogAfter) {
        if (PROVIDER instanceof RunOffEDTProvider.Progress2) {
            RunOffEDTProvider.Progress2 p = (RunOffEDTProvider.Progress2)PROVIDER;
            p.runOffEventThreadWithCustomDialogContent(operation, dialogTitle, content, waitCursorAfter, dialogAfter);
        } else {
            BaseProgressUtils.runOffEventDispatchThread((Runnable)operation, (String)dialogTitle, (AtomicBoolean)new AtomicBoolean(false), (boolean)true, (int)50, (int)9450);
        }
    }

    @Deprecated
    public static <T> T showProgressDialogAndRun(ProgressRunnable<T> operation, String displayName, boolean includeDetailLabel) {
        return (T)BaseProgressUtils.showProgressDialogAndRun(operation, (String)displayName, (boolean)includeDetailLabel);
    }

    @Deprecated
    public static void showProgressDialogAndRun(Runnable operation, String displayName) {
        BaseProgressUtils.showProgressDialogAndRun((Runnable)operation, (String)displayName);
    }

    @Deprecated
    public static <T> Future<T> showProgressDialogAndRunLater(ProgressRunnable<T> operation, ProgressHandle handle, boolean includeDetailLabel) {
        return BaseProgressUtils.showProgressDialogAndRunLater(operation, (ProgressHandle)handle, (boolean)includeDetailLabel);
    }

    private static class Trivial
    implements RunOffEDTProvider {
        private static final RequestProcessor WORKER = new RequestProcessor(ProgressUtils.class.getName());

        private Trivial() {
        }

        public void runOffEventDispatchThread(Runnable operation, String operationDescr, AtomicBoolean cancelOperation, boolean waitForCanceled, int waitCursorAfter, int dialogAfter) {
            if (SwingUtilities.isEventDispatchThread()) {
                RequestProcessor.Task t = WORKER.post(operation);
                t.waitFinished();
            } else {
                operation.run();
            }
        }
    }
}

