/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.queries;

import java.net.URL;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.openide.util.Lookup;

public class JavadocForBinaryQuery {
    private static final Logger LOG = Logger.getLogger(JavadocForBinaryQuery.class.getName());
    private static final Lookup.Result<? extends JavadocForBinaryQueryImplementation> implementations = Lookup.getDefault().lookupResult(JavadocForBinaryQueryImplementation.class);
    private static final Result EMPTY_RESULT = new EmptyResult();

    private JavadocForBinaryQuery() {
    }

    public static Result findJavadoc(URL binary) {
        ClassPathSupport.createResource((URL)binary);
        LOG.log(Level.FINE, "JFBQ.findJavadoc: {0}", binary);
        for (JavadocForBinaryQueryImplementation impl : implementations.allInstances()) {
            Result r = impl.findJavadoc(binary);
            if (r != null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "  got result {0} from {1}", new Object[]{Arrays.asList(r.getRoots()), impl});
                }
                return r;
            }
            LOG.log(Level.FINE, "  got no result from {0}", impl);
        }
        LOG.fine("  got no results from any impl");
        return EMPTY_RESULT;
    }

    public static interface Result {
        public URL[] getRoots();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }

    private static final class EmptyResult
    implements Result {
        private static final URL[] NO_ROOTS = new URL[0];

        EmptyResult() {
        }

        @Override
        public URL[] getRoots() {
            return NO_ROOTS;
        }

        @Override
        public void addChangeListener(ChangeListener l) {
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
        }
    }
}

