/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.mockito.mock;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.test.mockito.mock.Property;

public class Properties
implements Answer<Object>,
Iterable<String> {
    private final SortedMap<String, Object> propertiesMap = new TreeMap<String, Object>();

    public static Properties properties(Property ... properties) {
        return new Properties(properties);
    }

    public static Properties properties(Map<String, Object> properties) {
        return new Properties(properties);
    }

    private Properties(Property[] properties) {
        for (Property property : properties) {
            this.propertiesMap.put(property.key(), property.value());
        }
    }

    private Properties(Map<String, Object> properties) {
        this.propertiesMap.putAll(properties);
    }

    public Object answer(InvocationOnMock invocation) {
        Object[] arguments = invocation.getArguments();
        Object result = this.propertiesMap.get(arguments[0]);
        if (result == null) {
            if (arguments.length == 2) {
                return arguments[1];
            }
            throw new NotFoundException();
        }
        return result;
    }

    @Override
    public Iterator<String> iterator() {
        return this.propertiesMap.keySet().iterator();
    }

    public SortedMap<String, Object> getProperties() {
        return this.propertiesMap;
    }
}

