/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ExtensionContextException;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.ExceptionUtils;
import org.neo4j.test.extension.SkipThreadLeakageGuard;
import org.neo4j.test.extension.SuppressOutputExtension;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.util.FeatureToggles;

public class ThreadLeakageGuardExtension
implements AfterAllCallback,
BeforeAllCallback {
    private static final boolean PRINT_ONLY = FeatureToggles.flag(ThreadLeakageGuardExtension.class, (String)"PRINT_ONLY", (boolean)false);
    private static final long MAXIMUM_WAIT_TIME_MILLIS = 90000L;
    private static final String KEY = "ThreadLeakageExtension";
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"ThreadLeakageExtension"});
    private final StacktraceHolderException stacktraceHolderException = new StacktraceHolderException();
    private static final List<String> THREAD_NAME_FILTER = Arrays.asList("ForkJoinPool", "Cleaner", "PageCacheRule", "MuninnPageCache", "neo4j.FileIOHelper", "Attach Listener", "process reaper", "neo4j.BoltNetworkIO", "globalEventExecutor", "HttpClient", "Keep-Alive-Timer", "ObjectCleanerThread", "neo4j.StorageMaintenance", "neo4j.TransactionTimeoutMonitor", "neo4j.CheckPoint", "neo4j.IndexSampling", "junit-jupiter-timeout-watcher");

    public void afterAll(ExtensionContext context) throws Exception {
        if (ThreadLeakageGuardExtension.skipThreadLeakageGuard(context)) {
            return;
        }
        ThreadIds beforeThreads = (ThreadIds)ThreadLeakageGuardExtension.getStore(context).remove((Object)KEY, ThreadIds.class);
        ArrayList<String> leakedThreads = new ArrayList<String>();
        long startTime = System.currentTimeMillis();
        for (Thread afterThread : ThreadLeakageGuardExtension.getActiveThreads()) {
            if (beforeThreads.contains(afterThread.getId())) continue;
            long remainingWait = 90000L - (System.currentTimeMillis() - startTime);
            if (afterThread.isAlive() && remainingWait > 0L) {
                afterThread.join(remainingWait);
            }
            if (!afterThread.isAlive()) continue;
            leakedThreads.add(this.describeThread(afterThread));
        }
        beforeThreads.clear();
        if (!leakedThreads.isEmpty()) {
            String message = String.format("%d leaked thread(s) detected:%n%s", leakedThreads.size(), leakedThreads);
            if (PRINT_ONLY) {
                this.printError(context, message);
            } else {
                throw new ExtensionContextException(message);
            }
        }
    }

    private void printError(ExtensionContext context, String message) {
        ExtensionContext.Store store = context.getStore(SuppressOutputExtension.SUPPRESS_OUTPUT_NAMESPACE);
        SuppressOutput suppressOutput = (SuppressOutput)store.get((Object)"suppressOutput", SuppressOutput.class);
        PrintStream errorStream = ThreadLeakageGuardExtension.getErrorStream(suppressOutput);
        errorStream.println(message);
    }

    private static PrintStream getErrorStream(SuppressOutput suppressOutput) {
        PrintStream errStream = System.err;
        if (suppressOutput == null) {
            return errStream;
        }
        SuppressOutput.Voice errorVoice = suppressOutput.getErrorVoice();
        if (errorVoice == null) {
            return errStream;
        }
        Optional<PrintStream> originalStream = errorVoice.originalStream();
        if (originalStream.isPresent()) {
            errStream = originalStream.get();
        }
        return errStream;
    }

    public void beforeAll(ExtensionContext context) {
        if (ThreadLeakageGuardExtension.skipThreadLeakageGuard(context)) {
            return;
        }
        ThreadIds activeThreads = ThreadLeakageGuardExtension.getActiveThreads().stream().map(Thread::getId).collect(Collectors.toCollection(() -> new ThreadIds()));
        ThreadLeakageGuardExtension.getStore(context).put((Object)KEY, (Object)activeThreads);
    }

    private static boolean skipThreadLeakageGuard(ExtensionContext context) {
        return AnnotationSupport.isAnnotated((AnnotatedElement)context.getRequiredTestClass(), SkipThreadLeakageGuard.class) || ThreadLeakageGuardExtension.isConcurrentExecution();
    }

    private static boolean isConcurrentExecution() {
        return "concurrent".equals(System.getProperty("junit.jupiter.execution.parallel.mode.classes.default"));
    }

    private static Set<Thread> getActiveThreads() {
        Thread[] threads;
        ThreadGroup root = Thread.currentThread().getThreadGroup();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        int numThreads = root.activeCount() + 1;
        while ((numThreads = root.enumerate(threads = new Thread[numThreads * 2], true)) >= threads.length) {
        }
        return Arrays.stream(threads).filter(Objects::nonNull).filter(Thread::isAlive).filter(thread -> THREAD_NAME_FILTER.stream().noneMatch(prefix -> thread.getName().startsWith((String)prefix))).collect(Collectors.toSet());
    }

    private String describeThread(Thread thread) {
        String basicInfo = String.format("%s %s (PID:%s, TID:%d, Groups:%s)", new Object[]{thread.getName(), thread.getState(), ManagementFactory.getRuntimeMXBean().getName(), thread.getId(), ThreadLeakageGuardExtension.describeThreadGroupChain(thread)});
        return String.format("%s%n%s%n", basicInfo, this.describeStack(thread));
    }

    private static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(NAMESPACE);
    }

    private String describeStack(Thread thread) {
        StackTraceElement[] stackTraceElements = thread.getStackTrace();
        this.stacktraceHolderException.setStackTrace(stackTraceElements);
        return ExceptionUtils.readStackTrace((Throwable)this.stacktraceHolderException);
    }

    private static String describeThreadGroupChain(Thread thread) {
        ThreadGroup group = thread.getThreadGroup();
        if (group == null) {
            return "<dead>";
        }
        StringBuilder str = new StringBuilder(group.getName());
        while ((group = group.getParent()) != null) {
            str.append(':').append(group.getName());
        }
        return str.toString();
    }

    private static class ThreadIds
    extends HashSet<Long> {
        private ThreadIds() {
        }
    }

    private static class StacktraceHolderException
    extends RuntimeException {
        private StacktraceHolderException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }

        @Override
        public String toString() {
            return "";
        }
    }
}

