/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.assertion;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ObjectAssert;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.function.Suppliers;
import org.neo4j.function.ThrowingAction;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.helpers.Strings;
import org.neo4j.test.conditions.Conditions;

public final class Assert {
    private Assert() {
    }

    public static <E extends Exception> void awaitUntilAsserted(ThrowingAction<E> condition) {
        Assert.awaitUntilAsserted(null, condition);
    }

    public static <E extends Exception> void awaitUntilAsserted(String alias, ThrowingAction<E> condition) {
        Awaitility.await((String)alias).atMost(1L, TimeUnit.MINUTES).pollDelay(Duration.ZERO).pollInterval(50L, TimeUnit.MILLISECONDS).pollInSameThread().untilAsserted(() -> condition.apply());
    }

    public static void assertObjectOrArrayEquals(Object expected, Object actual) {
        Assert.assertObjectOrArrayEquals("", expected, actual);
    }

    public static void assertObjectOrArrayEquals(String message, Object expected, Object actual) {
        if (expected.getClass().isArray() ? !ArrayUtil.equals((Object)expected, (Object)actual) : !Objects.equals(expected, actual)) {
            throw Assert.newAssertionError(message, expected, actual);
        }
    }

    public static <T> void assertEventually(Callable<T> actual, Predicate<? super T> predicate, long timeout, TimeUnit timeUnit) {
        Assert.assertEventually("", actual, Conditions.condition(predicate), timeout, timeUnit);
    }

    public static <T> void assertEventually(Callable<T> actual, Condition<? super T> condition, long timeout, TimeUnit timeUnit) {
        Assert.assertEventually("", actual, condition, timeout, timeUnit);
    }

    public static <T> void assertEventually(String message, Callable<T> actual, Condition<? super T> condition, long timeout, TimeUnit timeUnit) {
        Assert.awaitCondition(message, timeout, timeUnit).untilAsserted(() -> Assertions.assertThat(actual.call()).satisfies(condition));
    }

    public static <T> void assertEventually(String message, Callable<T> actual, Predicate<? super T> predicate, long timeout, TimeUnit timeUnit) {
        Assert.awaitCondition(message, timeout, timeUnit).untilAsserted(() -> Assertions.assertThat(actual.call()).satisfies(Conditions.condition(predicate)));
    }

    public static <T> void assertEventually(Supplier<String> messageSupplier, Callable<T> actual, Condition<? super T> condition, long timeout, TimeUnit timeUnit) {
        Assert.assertEventually((T ignore) -> (String)messageSupplier.get(), actual, condition, timeout, timeUnit);
    }

    public static <T> void assertEventually(Function<T, String> messageGenerator, Callable<T> actual, Condition<? super T> condition, long timeout, TimeUnit timeUnit) {
        Assert.awaitCondition("await condition", timeout, timeUnit).untilAsserted(() -> {
            Object value = actual.call();
            ((ObjectAssert)Assertions.assertThat(value).as((String)messageGenerator.apply(value), new Object[0])).satisfies(condition);
        });
    }

    public static <T extends Throwable> void assertEventuallyThrows(String message, Class<T> expectedType, Executable actual, long timeout, TimeUnit timeUnit) {
        Assert.assertEventuallyThrows(Suppliers.singleton((Object)message), expectedType, actual, timeout, timeUnit);
    }

    public static <T extends Throwable> void assertEventuallyThrows(Supplier<String> messageGenerator, Class<T> expectedType, Executable actual, long timeout, TimeUnit timeUnit) {
        Assert.awaitCondition("should throw", timeout, timeUnit).untilAsserted(() -> org.junit.jupiter.api.Assertions.assertThrows((Class)expectedType, (Executable)actual, (Supplier)messageGenerator));
    }

    public static void assertEventuallyDoesNotThrow(String message, Executable action, long timeout, TimeUnit timeUnit) {
        Assert.awaitCondition("should not throw", timeout, timeUnit).untilAsserted(() -> org.junit.jupiter.api.Assertions.assertDoesNotThrow((Executable)action, (String)message));
    }

    public static void assertEventuallyDoesNotThrow(String message, Executable action, long timeout, TimeUnit timeoutTimeUnit, long delay, TimeUnit delayTimeUnit) {
        Assert.awaitCondition("should not throw", timeout, timeoutTimeUnit, delay, delayTimeUnit).untilAsserted(() -> org.junit.jupiter.api.Assertions.assertDoesNotThrow((Executable)action, (String)message));
    }

    private static ConditionFactory awaitCondition(String alias, long timeout, TimeUnit timeUnit) {
        return Awaitility.await((String)alias).atMost(timeout, timeUnit).pollDelay(10L, TimeUnit.MILLISECONDS).pollInSameThread();
    }

    private static ConditionFactory awaitCondition(String alias, long timeout, TimeUnit timeoutTimeUnit, long delay, TimeUnit delayTimeUnit) {
        return Awaitility.await((String)alias).atMost(timeout, timeoutTimeUnit).pollDelay(delay, delayTimeUnit).pollInSameThread();
    }

    private static AssertionError newAssertionError(String message, Object expected, Object actual) {
        return new AssertionError((Object)((String)(message == null || message.isEmpty() ? "" : message + "\n") + "Expected: " + Strings.prettyPrint((Object)expected) + ", actual: " + Strings.prettyPrint((Object)actual)));
    }
}

