/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.assertion;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;
import org.neo4j.function.ThrowingAction;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.helpers.Strings;

public final class Assert {
    private Assert() {
    }

    public static <E extends Exception> void assertException(ThrowingAction<E> f, Class<?> typeOfException) {
        Assert.assertException(f, typeOfException, (Matcher<String>)((Matcher)null));
    }

    public static <E extends Exception> void assertException(ThrowingAction<E> f, Class<?> typeOfException, String partOfMessage) {
        Assert.assertException(f, typeOfException, (Matcher<String>)(partOfMessage == null ? null : Matchers.containsString((String)partOfMessage)));
    }

    public static <E extends Exception> void assertException(ThrowingAction<E> f, Class<?> typeOfException, Matcher<String> messageMatcher) {
        try {
            f.apply();
            throw new AssertionError((Object)("Expected exception of type " + typeOfException + ", but no exception was thrown"));
        }
        catch (Exception e) {
            if (typeOfException.isInstance(e)) {
                String message;
                if (messageMatcher != null && !messageMatcher.matches((Object)(message = e.getMessage()))) {
                    StringBuilder sb = new StringBuilder();
                    StringDescription description = new StringDescription((Appendable)sb);
                    messageMatcher.describeTo((Description)description);
                    description.appendText(System.lineSeparator());
                    description.appendText("but ");
                    messageMatcher.describeMismatch((Object)message, (Description)description);
                    throw new AssertionError("Exception (attached as cause) did not match expected message '" + sb + "'.", e);
                }
            } else {
                throw new AssertionError("Expected exception of type '" + typeOfException + "', but instead got the attached cause.", e);
            }
            return;
        }
    }

    public static void assertObjectOrArrayEquals(Object expected, Object actual) {
        Assert.assertObjectOrArrayEquals("", expected, actual);
    }

    public static void assertObjectOrArrayEquals(String message, Object expected, Object actual) {
        if (expected.getClass().isArray() ? !ArrayUtil.equals((Object)expected, (Object)actual) : !Objects.equals(expected, actual)) {
            throw Assert.newAssertionError(message, expected, actual);
        }
    }

    public static <T, E extends Exception> void assertEventually(ThrowingSupplier<T, E> actual, Matcher<? super T> matcher, long timeout, TimeUnit timeUnit) throws E, InterruptedException {
        Assert.assertEventually((T ignored) -> "", actual, matcher, timeout, timeUnit);
    }

    public static <T, E extends Exception> void assertEventually(String reason, ThrowingSupplier<T, E> actual, Matcher<? super T> matcher, long timeout, TimeUnit timeUnit) throws E, InterruptedException {
        Assert.assertEventually((T ignored) -> reason, actual, matcher, timeout, timeUnit);
    }

    public static <T, E extends Exception> void assertEventually(Function<T, String> reason, ThrowingSupplier<T, E> actual, Matcher<? super T> matcher, long timeout, TimeUnit timeUnit) throws E, InterruptedException {
        boolean matched;
        Object last;
        long endTimeMillis = System.currentTimeMillis() + timeUnit.toMillis(timeout);
        while (true) {
            long sampleTime = System.currentTimeMillis();
            last = actual.get();
            matched = matcher.matches(last);
            if (matched || sampleTime > endTimeMillis) break;
            Thread.sleep(10L);
        }
        if (!matched) {
            StringDescription description = new StringDescription();
            description.appendText(reason.apply(last)).appendText("\nExpected: ").appendDescriptionOf(matcher).appendText("\n     but: ");
            matcher.describeMismatch(last, (Description)description);
            throw new AssertionError((Object)("Timeout hit (" + timeout + " " + timeUnit.toString().toLowerCase() + ") while waiting for condition to match: " + description.toString()));
        }
    }

    private static AssertionError newAssertionError(String message, Object expected, Object actual) {
        return new AssertionError((Object)((String)(message == null || message.isEmpty() ? "" : message + "\n") + "Expected: " + Strings.prettyPrint((Object)expected) + ", actual: " + Strings.prettyPrint((Object)actual)));
    }
}

