/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.matchers;

import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class NestedThrowableMatcher
extends TypeSafeMatcher<Throwable> {
    private final Class<? extends Throwable> expectedType;

    public NestedThrowableMatcher(Class<? extends Throwable> expectedType) {
        this.expectedType = expectedType;
    }

    public void describeTo(Description description) {
        description.appendText("expect ").appendValue(this.expectedType).appendText(" to be exception cause.");
    }

    protected boolean matchesSafely(Throwable item) {
        Throwable currentThrowable = item;
        do {
            if (!this.expectedType.isInstance(currentThrowable)) continue;
            return true;
        } while ((currentThrowable = currentThrowable.getCause()) != null);
        return false;
    }
}

