/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import java.util.Arrays;
import org.neo4j.configuration.Config;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.storageengine.api.StorageCommand;

public class TestCommand
implements StorageCommand {
    private static final KernelVersion LATEST_VERSION = KernelVersion.getLatestVersion((Configuration)Config.defaults());
    private final byte[] bytes;
    private final KernelVersion kernelVersion;

    public TestCommand() {
        this(LATEST_VERSION);
    }

    public TestCommand(KernelVersion kernelVersion) {
        this(50, kernelVersion);
    }

    public TestCommand(int size) {
        this(size, LATEST_VERSION);
    }

    public TestCommand(int size, KernelVersion kernelVersion) {
        this(new byte[size], kernelVersion);
    }

    public TestCommand(byte[] bytes) {
        this(bytes, LATEST_VERSION);
    }

    public TestCommand(byte[] bytes, KernelVersion kernelVersion) {
        this.bytes = bytes;
        this.kernelVersion = kernelVersion;
    }

    public void serialize(WritableChannel channel) throws IOException {
        channel.putInt(this.bytes.length);
        channel.put(this.bytes, this.bytes.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestCommand that = (TestCommand)o;
        return Arrays.equals(this.bytes, that.bytes);
    }

    public KernelVersion kernelVersion() {
        return this.kernelVersion;
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }
}

