/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.api.TestCommand;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReader;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StorageCommand;

public class TestCommandReaderFactory
implements CommandReaderFactory {
    public static final TestCommandReaderFactory INSTANCE = new TestCommandReaderFactory();

    private TestCommandReaderFactory() {
    }

    public CommandReader get(KernelVersion version) {
        return TestCommandReader.INSTANCE;
    }

    private static class TestCommandReader
    implements CommandReader {
        private static final KernelVersion LATEST_VERSION = KernelVersion.getLatestVersion((Config)Config.defaults());
        static final TestCommandReader INSTANCE = new TestCommandReader();

        private TestCommandReader() {
        }

        public StorageCommand read(ReadableChannel channel, MemoryTracker memoryTracker) throws IOException {
            int length = channel.getInt();
            byte[] bytes = new byte[length];
            channel.get(bytes, length);
            return new TestCommand(bytes);
        }

        public KernelVersion kernelVersion() {
            return LATEST_VERSION;
        }
    }
}

