/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.ListSerializer;
import org.neo4j.server.rest.repr.ListWriter;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.MappingWriter;

public abstract class Serializer {
    private final URI baseUri;

    Serializer(URI baseUri) {
        this.baseUri = baseUri;
    }

    final void serialize(MappingWriter mapping, MappingRepresentation value) {
        value.serialize(new MappingSerializer(mapping, this.baseUri));
        mapping.done();
    }

    final void serialize(ListWriter list, ListRepresentation value) {
        value.serialize(new ListSerializer(list, this.baseUri));
        list.done();
    }

    final String relativeUri(String path) {
        return Serializer.joinBaseWithRelativePath(this.baseUri, path);
    }

    final String relativeTemplate(String path) {
        return Serializer.joinBaseWithRelativePath(this.baseUri, path);
    }

    public static String joinBaseWithRelativePath(URI baseUri, String path) {
        String base = baseUri.toString();
        StringBuilder result = new StringBuilder(base.length() + path.length() + 1).append(base);
        if (base.endsWith("/")) {
            if (path.startsWith("/")) {
                return result.append(path.substring(1)).toString();
            }
        } else if (!path.startsWith("/")) {
            return result.append('/').append(path).toString();
        }
        return result.append(path).toString();
    }

    void checkThatItIsBuiltInType(Object value) {
        if (!"java.lang".equals(value.getClass().getPackage().getName())) {
            throw new IllegalArgumentException("Unsupported number type: " + value.getClass());
        }
    }
}

