/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import org.neo4j.server.rest.repr.ExtensionInjector;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.ListWriter;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.Serializer;

public class ListSerializer
extends Serializer {
    final ListWriter writer;

    ListSerializer(ListWriter writer, URI baseUri, ExtensionInjector extensions) {
        super(baseUri, extensions);
        this.writer = writer;
    }

    public void addUri(String path) {
        this.writer.writeValue(RepresentationType.URI, (Object)this.relativeUri(path));
    }

    public void addUriTemplate(String template) {
        this.writer.writeValue(RepresentationType.TEMPLATE, (Object)this.relativeTemplate(template));
    }

    public void addString(String value) {
        this.writer.writeString(value);
    }

    public void addBoolean(boolean value) {
        this.writer.writeBoolean(value);
    }

    public void addMapping(MappingRepresentation value) {
        this.serialize(this.writer.newMapping(value.type), value);
    }

    public void addList(ListRepresentation value) {
        this.serialize(this.writer.newList(value.type), value);
    }

    public final void addNumber(Number value) {
        if (value instanceof Double || value instanceof Float) {
            this.writer.writeFloatingPointNumber(RepresentationType.valueOf(value.getClass()), value.doubleValue());
        } else {
            if (!"java.lang".equals(value.getClass().getPackage().getName())) {
                throw new IllegalArgumentException("Unsupported number type: " + value.getClass());
            }
            this.writer.writeInteger(RepresentationType.valueOf(value.getClass()), value.longValue());
        }
    }
}

