/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling.procedure.visitors;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.lang.model.util.Types;
import org.neo4j.tooling.procedure.compilerutils.TypeMirrorUtils;
import org.neo4j.tooling.procedure.messages.CompilationMessage;
import org.neo4j.tooling.procedure.messages.ReturnTypeError;
import org.neo4j.tooling.procedure.visitors.ExtensionClassVisitor;
import org.neo4j.tooling.procedure.visitors.ParameterTypeVisitor;
import org.neo4j.tooling.procedure.visitors.ParameterVisitor;
import org.neo4j.tooling.procedure.visitors.PerformsWriteMethodVisitor;
import org.neo4j.tooling.procedure.visitors.RecordTypeVisitor;

public class ProcedureVisitor
extends SimpleElementVisitor8<Stream<CompilationMessage>, Void> {
    private final Types typeUtils;
    private final Elements elementUtils;
    private final ElementVisitor<Stream<CompilationMessage>, Void> classVisitor;
    private final TypeVisitor<Stream<CompilationMessage>, Void> recordVisitor;
    private final ElementVisitor<Stream<CompilationMessage>, Void> parameterVisitor;
    private final ElementVisitor<Stream<CompilationMessage>, Void> performsWriteVisitor;

    public ProcedureVisitor(Types typeUtils, Elements elementUtils, boolean ignoresWarnings) {
        TypeMirrorUtils typeMirrors = new TypeMirrorUtils(typeUtils, elementUtils);
        this.typeUtils = typeUtils;
        this.elementUtils = elementUtils;
        this.classVisitor = new ExtensionClassVisitor(typeUtils, elementUtils, ignoresWarnings);
        this.recordVisitor = new RecordTypeVisitor(typeUtils, typeMirrors);
        this.parameterVisitor = new ParameterVisitor(new ParameterTypeVisitor(typeUtils, typeMirrors));
        this.performsWriteVisitor = new PerformsWriteMethodVisitor();
    }

    @Override
    public Stream<CompilationMessage> visitExecutable(ExecutableElement executableElement, Void ignored) {
        return Stream.of(this.classVisitor.visit(executableElement.getEnclosingElement()), this.validateParameters(executableElement.getParameters()), this.validateReturnType(executableElement), this.validatePerformsWriteUsage(executableElement)).flatMap(Function.identity());
    }

    private Stream<CompilationMessage> validateParameters(List<? extends VariableElement> parameters) {
        return parameters.stream().flatMap(this.parameterVisitor::visit);
    }

    private Stream<CompilationMessage> validateReturnType(ExecutableElement method) {
        String streamClassName = Stream.class.getCanonicalName();
        TypeMirror streamType = this.typeUtils.erasure(this.elementUtils.getTypeElement(streamClassName).asType());
        TypeMirror returnType = method.getReturnType();
        TypeMirror erasedReturnType = this.typeUtils.erasure(returnType);
        NoType voidType = this.typeUtils.getNoType(TypeKind.VOID);
        if (this.typeUtils.isSameType(returnType, voidType)) {
            return Stream.empty();
        }
        if (!this.typeUtils.isSubtype(erasedReturnType, streamType)) {
            return Stream.of(new ReturnTypeError(method, "Return type of %s#%s must be %s", method.getEnclosingElement().getSimpleName(), method.getSimpleName(), streamClassName));
        }
        return this.recordVisitor.visit(returnType);
    }

    private Stream<CompilationMessage> validatePerformsWriteUsage(ExecutableElement executableElement) {
        return this.performsWriteVisitor.visit(executableElement);
    }
}

