/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.migration;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.common.EntityType;
import org.neo4j.common.ProgressReporter;
import org.neo4j.configuration.Config;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.format.CapabilityType;
import org.neo4j.storageengine.migration.AbstractStoreMigrationParticipant;

public class SchemaIndexMigrator
extends AbstractStoreMigrationParticipant {
    private final FileSystemAbstraction fileSystem;
    private final PageCache pageCache;
    private final IndexDirectoryStructure indexDirectoryStructure;
    private final StorageEngineFactory storageEngineFactory;
    private final boolean checkIndexCapabilities;
    private boolean deleteAllIndexes;
    private boolean deleteRelationshipIndexes;

    public SchemaIndexMigrator(String name, FileSystemAbstraction fileSystem, PageCache pageCache, IndexDirectoryStructure indexDirectoryStructure, StorageEngineFactory storageEngineFactory, boolean checkIndexCapabilities) {
        super(name);
        this.fileSystem = fileSystem;
        this.pageCache = pageCache;
        this.indexDirectoryStructure = indexDirectoryStructure;
        this.storageEngineFactory = storageEngineFactory;
        this.checkIndexCapabilities = checkIndexCapabilities;
    }

    @Override
    public void migrate(DatabaseLayout directoryLayout, DatabaseLayout migrationLayout, ProgressReporter progressReporter, String versionToMigrateFrom, String versionToMigrateTo, IndexImporterFactory indexImporterFactory) {
        StoreVersion fromVersion = this.storageEngineFactory.versionInformation(versionToMigrateFrom);
        StoreVersion toVersion = this.storageEngineFactory.versionInformation(versionToMigrateTo);
        this.deleteAllIndexes = this.checkIndexCapabilities && !fromVersion.hasCompatibleCapabilities(toVersion, CapabilityType.INDEX);
        this.deleteRelationshipIndexes = !fromVersion.hasCompatibleCapabilities(toVersion, CapabilityType.FORMAT);
    }

    @Override
    public void moveMigratedFiles(DatabaseLayout migrationLayout, DatabaseLayout directoryLayout, String versionToUpgradeFrom, String versionToMigrateTo) throws IOException {
        Path schemaIndexDirectory = this.indexDirectoryStructure.rootDirectory();
        if (schemaIndexDirectory != null) {
            if (this.deleteAllIndexes) {
                this.deleteIndexes(schemaIndexDirectory);
            } else if (this.deleteRelationshipIndexes) {
                this.deleteRelationshipIndexes(directoryLayout);
            }
        }
    }

    @Override
    public void cleanup(DatabaseLayout migrationLayout) {
    }

    private void deleteIndexes(Path indexRootDirectory) throws IOException {
        this.fileSystem.deleteRecursively(indexRootDirectory);
    }

    private void deleteRelationshipIndexes(DatabaseLayout databaseLayout) throws IOException {
        for (SchemaRule schemaRule : this.storageEngineFactory.loadSchemaRules(this.fileSystem, this.pageCache, Config.defaults(), databaseLayout, CursorContext.NULL)) {
            if (schemaRule.schema().entityType() != EntityType.RELATIONSHIP) continue;
            this.fileSystem.deleteRecursively(this.indexDirectoryStructure.directoryForIndex(schemaRule.getId()));
        }
    }
}

