/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.util.Arrays;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.values.storable.Value;

public class ValueIndexEntryUpdate<INDEX_KEY extends SchemaDescriptorSupplier>
extends IndexEntryUpdate<INDEX_KEY> {
    private final Value[] before;
    private final Value[] values;

    ValueIndexEntryUpdate(long entityId, INDEX_KEY index_key, UpdateMode updateMode, Value[] values) {
        this(entityId, index_key, updateMode, null, values);
    }

    ValueIndexEntryUpdate(long entityId, INDEX_KEY indexKey, UpdateMode updateMode, Value[] before, Value[] values) {
        super(entityId, indexKey, updateMode);
        ValueIndexEntryUpdate.validateValuesLength(indexKey, before, values);
        this.before = before;
        this.values = values;
    }

    public Value[] values() {
        return this.values;
    }

    public Value[] beforeValues() {
        if (this.before == null) {
            throw new UnsupportedOperationException("beforeValues is only valid for `UpdateMode.CHANGED");
        }
        return this.before;
    }

    @Override
    public long roughSizeOfUpdate() {
        return ValueIndexEntryUpdate.heapSizeOf(this.values) + (this.updateMode() == UpdateMode.CHANGED ? ValueIndexEntryUpdate.heapSizeOf(this.before) : 0L);
    }

    @Override
    protected boolean valueEquals(IndexEntryUpdate<?> o) {
        if (!(o instanceof ValueIndexEntryUpdate)) {
            return false;
        }
        ValueIndexEntryUpdate that = (ValueIndexEntryUpdate)o;
        if (!Arrays.equals(this.before, that.before)) {
            return false;
        }
        return Arrays.equals(this.values, that.values);
    }

    @Override
    protected int valueHash() {
        int result = Arrays.hashCode(this.before);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    @Override
    protected String valueToString() {
        return String.format("beforeValues=%s, values=%s", Arrays.toString(this.before), Arrays.toString(this.values));
    }

    public String toString() {
        return "ValueIndexEntryUpdate{entity=" + this.getEntityId() + ", before=" + Arrays.toString(this.before) + ", values=" + Arrays.toString(this.values) + "}";
    }

    private static void validateValuesLength(SchemaDescriptorSupplier indexKey, Value[] before, Value[] values) {
        assert (indexKey.schema().getPropertyIds().length == values.length) : String.format("ValueIndexEntryUpdate values must be of same length as index compositeness. Index on %s, but got values %s", indexKey.schema().toString(), Arrays.toString(values));
        assert (before == null || before.length == values.length);
    }

    private static long heapSizeOf(Value[] values) {
        long size = 0L;
        if (values != null) {
            for (Value value : values) {
                if (value == null) continue;
                size += ValueIndexEntryUpdate.heapSizeOf(value);
            }
        }
        return size;
    }

    private static long heapSizeOf(Value value) {
        return HeapEstimator.sizeOf((Object)value.asObject());
    }
}

