/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.util.Arrays;
import java.util.Comparator;

public class EntityTokenUpdate {
    public static final Comparator<? super EntityTokenUpdate> SORT_BY_ENTITY_ID = Comparator.comparingLong(EntityTokenUpdate::getEntityId);
    private final long entityId;
    private final long[] tokensBefore;
    private final long[] tokensAfter;
    private final long txId;

    private EntityTokenUpdate(long entityId, long[] tokensBefore, long[] tokensAfter, long txId) {
        this.entityId = entityId;
        this.tokensBefore = tokensBefore;
        this.tokensAfter = tokensAfter;
        this.txId = txId;
    }

    public long getEntityId() {
        return this.entityId;
    }

    public long[] getTokensBefore() {
        return this.tokensBefore;
    }

    public long[] getTokensAfter() {
        return this.tokensAfter;
    }

    public long getTxId() {
        return this.txId;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[entity:" + this.entityId + ", tokensBefore:" + Arrays.toString(this.tokensBefore) + ", tokensAfter:" + Arrays.toString(this.tokensAfter) + "]";
    }

    public static EntityTokenUpdate tokenChanges(long entityId, long[] tokensBeforeChange, long[] tokensAfterChange) {
        return EntityTokenUpdate.tokenChanges(entityId, tokensBeforeChange, tokensAfterChange, -1L);
    }

    public static EntityTokenUpdate tokenChanges(long entityId, long[] tokensBeforeChange, long[] tokensAfterChange, long txId) {
        return new EntityTokenUpdate(entityId, tokensBeforeChange, tokensAfterChange, txId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityTokenUpdate that = (EntityTokenUpdate)o;
        if (this.entityId != that.entityId) {
            return false;
        }
        if (!Arrays.equals(this.tokensAfter, that.tokensAfter)) {
            return false;
        }
        return Arrays.equals(this.tokensBefore, that.tokensBefore);
    }

    public int hashCode() {
        int result = (int)(this.entityId ^ this.entityId >>> 32);
        result = 31 * result + (this.tokensBefore != null ? Arrays.hashCode(this.tokensBefore) : 0);
        result = 31 * result + (this.tokensAfter != null ? Arrays.hashCode(this.tokensAfter) : 0);
        return result;
    }
}

