/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.IntPredicate;
import javax.annotation.Nullable;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.transaction.state.storeview.PropertyAwareEntityStoreScan;
import org.neo4j.lock.LockService;
import org.neo4j.lock.LockType;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.EntityTokenUpdate;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;

public class RelationshipStoreScan<FAILURE extends Exception>
extends PropertyAwareEntityStoreScan<StorageRelationshipScanCursor, FAILURE> {
    private final Visitor<EntityTokenUpdate, FAILURE> relationshipTypeUpdateVisitor;
    final int[] relationshipTypeIds;
    private final Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor;

    public RelationshipStoreScan(StorageReader storageReader, LockService locks, @Nullable Visitor<EntityTokenUpdate, FAILURE> relationshipTypeUpdateVisitor, @Nullable Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor, int[] relationshipTypeIds, IntPredicate propertyKeyIdFilter, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        super(storageReader, storageReader.relationshipsGetCount(), propertyKeyIdFilter, id -> locks.acquireRelationshipLock(id, LockType.SHARED), cursorTracer, memoryTracker);
        this.relationshipTypeUpdateVisitor = relationshipTypeUpdateVisitor;
        this.propertyUpdatesVisitor = propertyUpdatesVisitor;
        this.relationshipTypeIds = relationshipTypeIds;
    }

    @Override
    protected StorageRelationshipScanCursor allocateCursor(StorageReader storageReader, PageCursorTracer cursorTracer) {
        return storageReader.allocateRelationshipScanCursor(cursorTracer);
    }

    @Override
    protected boolean process(StorageRelationshipScanCursor cursor) throws FAILURE {
        EntityUpdates.Builder updates;
        int relType = cursor.type();
        if (this.relationshipTypeUpdateVisitor != null) {
            this.relationshipTypeUpdateVisitor.visit((Object)EntityTokenUpdate.tokenChanges((long)cursor.entityReference(), (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{relType}));
        }
        if (this.propertyUpdatesVisitor != null && RelationshipStoreScan.containsAnyEntityToken(this.relationshipTypeIds, relType) && this.hasRelevantProperty(cursor, updates = EntityUpdates.forEntity((long)cursor.entityReference(), (boolean)true).withTokens(new long[]{relType}))) {
            return this.propertyUpdatesVisitor.visit((Object)updates.build());
        }
        return false;
    }
}

