/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexOrderCapability;
import org.neo4j.values.storable.ValueCategory;

class QueryValidator {
    QueryValidator() {
    }

    static void validateOrder(IndexCapability capability, IndexOrder indexOrder, IndexQuery[] predicates) {
        if (indexOrder != IndexOrder.NONE) {
            ValueCategory valueCategory = predicates[0].valueGroup().category();
            IndexOrderCapability orderCapability = capability.orderCapability(new ValueCategory[]{valueCategory});
            if (indexOrder == IndexOrder.ASCENDING && !orderCapability.supportsAsc() || indexOrder == IndexOrder.DESCENDING && !orderCapability.supportsDesc()) {
                throw new UnsupportedOperationException(String.format("Tried to query index with unsupported order %s. For query %s supports ascending: %b, supports descending: %b.", indexOrder, Arrays.toString(predicates), orderCapability.supportsAsc(), orderCapability.supportsDesc()));
            }
        }
    }

    static void validateCompositeQuery(IndexQuery[] predicates) {
        IndexQuery prev = null;
        for (IndexQuery current : predicates) {
            String illegalQueryMessage = "Tried to query index with illegal composite query.";
            if ((current instanceof IndexQuery.StringContainsPredicate || current instanceof IndexQuery.StringSuffixPredicate) && predicates.length > 1) {
                throw new IllegalArgumentException(String.format("%s Suffix or contains predicate are not allowed in composite query. Query was: %s ", illegalQueryMessage, Arrays.toString(predicates)));
            }
            if ((prev instanceof IndexQuery.RangePredicate || prev instanceof IndexQuery.StringPrefixPredicate || prev instanceof IndexQuery.ExistsPredicate) && !(current instanceof IndexQuery.ExistsPredicate)) {
                throw new IllegalArgumentException(String.format("%s Composite query must have decreasing precision. Query was: %s ", illegalQueryMessage, Arrays.toString(predicates)));
            }
            prev = current;
        }
    }
}

