/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Optional;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.database.AbstractSystemGraphComponent;
import org.neo4j.dbms.database.DbmsRuntimeRepository;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;

public class DbmsRuntimeSystemGraphComponent
extends AbstractSystemGraphComponent {
    private static final Label versionLabel = Label.label((String)"Version");
    public static final String COMPONENT_NAME = "dbms-runtime";

    public DbmsRuntimeSystemGraphComponent(Config config) {
        super(config);
    }

    @Override
    public String component() {
        return COMPONENT_NAME;
    }

    @Override
    public SystemGraphComponent.Status detect(Transaction tx) {
        Optional<DbmsRuntimeVersion> version = tx.findNodes(DbmsRuntimeRepository.DBMS_RUNTIME_LABEL).stream().map(node -> (int)((Integer)node.getProperty("version"))).map(DbmsRuntimeVersion::fromVersionNumber).findFirst();
        if (version.isEmpty()) {
            return SystemGraphComponent.Status.UNINITIALIZED;
        }
        if (version.get() != DbmsRuntimeRepository.LATEST_VERSION) {
            return SystemGraphComponent.Status.REQUIRES_UPGRADE;
        }
        return SystemGraphComponent.Status.CURRENT;
    }

    @Override
    protected void initializeSystemGraphModel(Transaction tx) {
        DbmsRuntimeVersion dbmsRuntimeVersion = DbmsRuntimeRepository.LATEST_VERSION;
        if (!((Boolean)this.config.get(GraphDatabaseSettings.allow_single_automatic_upgrade)).booleanValue() && this.is41Database(tx)) {
            dbmsRuntimeVersion = DbmsRuntimeVersion.V4_1;
        }
        tx.createNode(new Label[]{DbmsRuntimeRepository.DBMS_RUNTIME_LABEL}).setProperty("version", (Object)dbmsRuntimeVersion.getVersionNumber());
    }

    @Override
    public void upgradeToCurrent(GraphDatabaseService systemDb) throws Exception {
        SystemGraphComponent.executeWithFullAccess(systemDb, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            Node node = tx.findNodes(DbmsRuntimeRepository.DBMS_RUNTIME_LABEL).stream().findFirst().orElseGet(() -> tx.createNode(new Label[]{DbmsRuntimeRepository.DBMS_RUNTIME_LABEL}));
            node.setProperty("version", (Object)DbmsRuntimeRepository.LATEST_VERSION.getVersionNumber());
        }));
    }

    private boolean is41Database(Transaction tx) {
        boolean result = false;
        ResourceIterator nodes = tx.findNodes(versionLabel);
        if (nodes.hasNext()) {
            result = true;
        }
        nodes.close();
        return result;
    }
}

