/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.IOException;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.EntityStoreUpdaterStep;
import org.neo4j.unsafe.impl.batchimport.InputEntityCacherStep;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.InputIteratorBatcherStep;
import org.neo4j.unsafe.impl.batchimport.LabelScanStorePopulationStep;
import org.neo4j.unsafe.impl.batchimport.NodeEncoderStep;
import org.neo4j.unsafe.impl.batchimport.PropertyEncoderStep;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.InputCache;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;
import org.neo4j.unsafe.impl.batchimport.store.io.IoMonitor;

public class NodeStage
extends Stage {
    private final NodeRelationshipCache cache;
    private final NodeStore nodeStore;

    public NodeStage(Configuration config, IoMonitor writeMonitor, InputIterable<InputNode> nodes, IdMapper idMapper, IdGenerator idGenerator, BatchingNeoStores neoStore, InputCache inputCache, LabelScanStore labelScanStore, EntityStoreUpdaterStep.Monitor storeUpdateMonitor, NodeRelationshipCache cache, StatsProvider memoryUsage) throws IOException {
        super("Nodes", config, 1);
        this.cache = cache;
        this.add(new InputIteratorBatcherStep<InputNode>(this.control(), config, (InputIterator<InputNode>)nodes.iterator(), InputNode.class, t -> true));
        if (!nodes.supportsMultiplePasses()) {
            this.add(new InputEntityCacherStep(this.control(), config, inputCache.cacheNodes("main")));
        }
        this.nodeStore = neoStore.getNodeStore();
        PropertyStore propertyStore = neoStore.getPropertyStore();
        this.add(new NodeEncoderStep(this.control(), config, idMapper, idGenerator, neoStore.getLabelRepository(), this.nodeStore, memoryUsage));
        this.add(new PropertyEncoderStep(this.control(), config, neoStore.getPropertyKeyRepository(), propertyStore));
        this.add(new LabelScanStorePopulationStep(this.control(), config, labelScanStore));
        this.add(new EntityStoreUpdaterStep(this.control(), config, this.nodeStore, propertyStore, writeMonitor, storeUpdateMonitor));
    }

    @Override
    public void close() {
        this.cache.setHighNodeId(this.nodeStore.getHighId());
        super.close();
    }
}

