/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Comparator;

public class NoneStrictMath {
    public static double EPSILON = 1.0E-8;

    public static int compare(double x, double y, double eps) {
        return NoneStrictMath.equals(x, y, eps) ? 0 : (x < y ? -1 : 1);
    }

    public static int compare(double x, double y) {
        return NoneStrictMath.compare(x, y, EPSILON);
    }

    public static boolean equals(double x, double y, double eps) {
        return Math.abs(x - y) <= eps;
    }

    public static boolean equals(double x, double y) {
        return NoneStrictMath.equals(x, y, EPSILON);
    }

    public static class CommonToleranceComparator
    implements Comparator<Double> {
        private final double epsilon;

        public CommonToleranceComparator(double epsilon) {
            this.epsilon = epsilon;
        }

        @Override
        public int compare(Double x, Double y) {
            return NoneStrictMath.compare(x, y, this.epsilon);
        }
    }
}

