/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.util.function.Supplier;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.impl.util.UnsatisfiedDependencyException;

public class DependenciesProxy {
    public static <T> T dependencies(DependencyResolver dependencyResolver, Class<T> dependenciesInterface) {
        return (T)Proxy.newProxyInstance(dependenciesInterface.getClassLoader(), new Class[]{dependenciesInterface}, (InvocationHandler)new ProxyHandler(dependencyResolver));
    }

    private static class ProxyHandler
    implements InvocationHandler {
        private DependencyResolver dependencyResolver;

        ProxyHandler(DependencyResolver dependencyResolver) {
            this.dependencyResolver = dependencyResolver;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if (method.getReturnType().equals(Supplier.class)) {
                    return this.dependencyResolver.provideDependency((Class)((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[0]);
                }
                return this.dependencyResolver.resolveDependency(method.getReturnType());
            }
            catch (IllegalArgumentException e) {
                throw new UnsatisfiedDependencyException(e);
            }
        }
    }
}

