/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.transaction.state.storeview.LabelScanViewNodeStoreScan;
import org.neo4j.storageengine.api.schema.LabelScanReader;

class LabelScanViewIdIterator
implements PrimitiveLongResourceIterator {
    private LabelScanViewNodeStoreScan labelScanViewNodeStoreScan;
    private LabelScanReader labelScanReader;
    private PrimitiveLongIterator idIterator;
    private LabelScanStore labelScanStore;
    private int[] labelIds;
    private long currentId = -1L;

    LabelScanViewIdIterator(LabelScanViewNodeStoreScan labelScanViewNodeStoreScan, LabelScanStore labelScanStore, int[] labelIds) {
        this.labelScanViewNodeStoreScan = labelScanViewNodeStoreScan;
        this.labelScanStore = labelScanStore;
        this.labelIds = labelIds;
        this.idIterator = this.openIdIterator(labelScanStore, labelIds);
    }

    public void close() {
        this.labelScanReader.close();
    }

    public boolean hasNext() {
        this.checkNodeIdIterator();
        return this.idIterator.hasNext();
    }

    public long next() {
        this.currentId = this.idIterator.next();
        return this.currentId;
    }

    private void checkNodeIdIterator() {
        if (this.labelScanViewNodeStoreScan.isOutdated()) {
            this.close();
            this.idIterator = this.openIdIterator(this.labelScanStore, this.labelIds);
            this.labelScanViewNodeStoreScan.clearOutdatedFlag();
        }
    }

    private PrimitiveLongIterator openIdIterator(LabelScanStore labelScanStore, int[] labelIds) {
        this.labelScanReader = labelScanStore.newReader();
        return new LabeledNodesIdIterator(this.labelScanReader.nodesWithAnyOfLabels(labelIds), this.currentId);
    }

    private class LabeledNodesIdIterator
    extends PrimitiveLongCollections.PrimitiveLongFilteringIterator {
        private long observedId;

        LabeledNodesIdIterator(PrimitiveLongIterator source, long observedId) {
            super(source);
            this.observedId = observedId;
        }

        public boolean test(long testId) {
            return this.observedId < testId;
        }
    }
}

