/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import org.neo4j.helpers.Clock;
import org.neo4j.kernel.impl.transaction.log.checkpoint.AbstractCheckPointThreshold;

public class TimeCheckPointThreshold
extends AbstractCheckPointThreshold {
    private volatile long lastCheckPointedTransactionId;
    private volatile long nextCheckPointTime;
    private final long timeMillisThreshold;
    private final Clock clock;

    public TimeCheckPointThreshold(long timeMillisThreshold, Clock clock) {
        this.timeMillisThreshold = timeMillisThreshold;
        this.clock = clock;
        this.nextCheckPointTime = clock.currentTimeMillis() + timeMillisThreshold;
    }

    @Override
    public void initialize(long transactionId) {
        this.lastCheckPointedTransactionId = transactionId;
    }

    @Override
    protected boolean thresholdReached(long lastCommittedTransactionId) {
        return lastCommittedTransactionId > this.lastCheckPointedTransactionId && this.clock.currentTimeMillis() >= this.nextCheckPointTime;
    }

    @Override
    protected String description() {
        return "time threshold";
    }

    @Override
    public void checkPointHappened(long transactionId) {
        this.nextCheckPointTime = this.clock.currentTimeMillis() + this.timeMillisThreshold;
        this.lastCheckPointedTransactionId = transactionId;
    }
}

