/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.neo4j.function.Predicates;
import org.neo4j.function.Supplier;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class CheckPointScheduler
extends LifecycleAdapter {
    private final CheckPointer checkPointer;
    private final JobScheduler scheduler;
    private final long recurringPeriodMillis;
    private final Runnable job = new Runnable(){

        @Override
        public void run() {
            try {
                CheckPointScheduler.this.checkPointing = true;
                if (CheckPointScheduler.this.stopped) {
                    return;
                }
                CheckPointScheduler.this.checkPointer.checkPointIfNeeded(new SimpleTriggerInfo("scheduler"));
            }
            catch (IOException e) {
                throw new UnderlyingStorageException(e);
            }
            finally {
                CheckPointScheduler.this.checkPointing = false;
            }
            if (!CheckPointScheduler.this.stopped) {
                CheckPointScheduler.this.handle = CheckPointScheduler.this.scheduler.schedule(JobScheduler.Groups.checkPoint, CheckPointScheduler.this.job, CheckPointScheduler.this.recurringPeriodMillis, TimeUnit.MILLISECONDS);
            }
        }
    };
    private volatile JobScheduler.JobHandle handle;
    private volatile boolean stopped;
    private volatile boolean checkPointing;
    private final Supplier<Boolean> checkPointingCondition = new Supplier<Boolean>(){

        public Boolean get() {
            return !CheckPointScheduler.this.checkPointing;
        }
    };

    public CheckPointScheduler(CheckPointer checkPointer, JobScheduler scheduler, long recurringPeriodMillis) {
        this.checkPointer = checkPointer;
        this.scheduler = scheduler;
        this.recurringPeriodMillis = recurringPeriodMillis;
    }

    @Override
    public void start() throws Throwable {
        this.handle = this.scheduler.schedule(JobScheduler.Groups.checkPoint, this.job, this.recurringPeriodMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() throws Throwable {
        this.stopped = true;
        if (this.handle != null) {
            this.handle.cancel(false);
        }
        Predicates.awaitForever(this.checkPointingCondition, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
    }
}

