/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacylogs;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.function.Function;
import org.neo4j.helpers.Pair;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.storemigration.legacylogs.LogEntrySortingCursor;
import org.neo4j.kernel.impl.transaction.log.IOCursor;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableVersionableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;

class LegacyLogEntryReader {
    private final FileSystemAbstraction fs;
    private final Function<LogHeader, LogEntryReader<ReadableVersionableLogChannel>> readerFactory;

    LegacyLogEntryReader(FileSystemAbstraction fs, Function<LogHeader, LogEntryReader<ReadableVersionableLogChannel>> readerFactory) {
        this.fs = fs;
        this.readerFactory = readerFactory;
    }

    LegacyLogEntryReader(FileSystemAbstraction fs) {
        this(fs, new Function<LogHeader, LogEntryReader<ReadableVersionableLogChannel>>(){

            public LogEntryReader<ReadableVersionableLogChannel> apply(LogHeader from) throws RuntimeException {
                return new VersionAwareLogEntryReader<ReadableVersionableLogChannel>(from.logFormatVersion);
            }
        });
    }

    public Pair<LogHeader, IOCursor<LogEntry>> openReadableChannel(File logFile) throws IOException {
        StoreChannel rawChannel = this.fs.open(logFile, "r");
        ByteBuffer buffer = ByteBuffer.allocate(16);
        LogHeader header = LogHeaderReader.readLogHeader(buffer, (ReadableByteChannel)rawChannel, false);
        LogEntryReader reader = (LogEntryReader)this.readerFactory.apply((Object)header);
        long lastCommittedTxId = Math.max(1L, header.lastCommittedTxId);
        PhysicalLogVersionedStoreChannel channel = new PhysicalLogVersionedStoreChannel(rawChannel, header.logVersion, header.logFormatVersion);
        ReadAheadLogChannel readableChannel = new ReadAheadLogChannel(channel, LogVersionBridge.NO_MORE_CHANNELS, 4096);
        LogEntrySortingCursor cursor = new LogEntrySortingCursor(reader, readableChannel);
        return Pair.of(new LogHeader(6, header.logVersion, lastCommittedTxId), cursor);
    }
}

