/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.RecordSerializer;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.logging.LogProvider;

public class SchemaStore
extends AbstractDynamicStore
implements Iterable<SchemaRule> {
    public static final String TYPE_DESCRIPTOR = "SchemaStore";
    public static final int BLOCK_SIZE = 56;

    public SchemaStore(File fileName, Config conf, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider) {
        super(fileName, conf, idType, idGeneratorFactory, pageCache, logProvider, 56);
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, DynamicRecord record) throws FAILURE {
        processor.processSchema(this, record);
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    public Collection<DynamicRecord> allocateFrom(SchemaRule rule) {
        RecordSerializer serializer = new RecordSerializer();
        serializer = serializer.append(rule);
        ArrayList<DynamicRecord> records = new ArrayList<DynamicRecord>();
        SchemaStore.allocateRecordsFromBytes(records, serializer.serialize(), IteratorUtil.iterator(this.forceGetRecord(rule.getId())), this);
        return records;
    }

    public Iterator<SchemaRule> loadAllSchemaRules() {
        return new SchemaStorage(this).loadAllSchemaRules();
    }

    @Override
    public Iterator<SchemaRule> iterator() {
        return this.loadAllSchemaRules();
    }

    static SchemaRule readSchemaRule(long id, Collection<DynamicRecord> records, byte[] buffer) throws MalformedSchemaRuleException {
        ByteBuffer scratchBuffer = SchemaStore.concatData(records, buffer);
        return SchemaRule.Kind.deserialize(id, scratchBuffer);
    }
}

