/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.impl.cache.MeasureDoNothing;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;

public class MonitorGc
implements Lifecycle {
    private final Config config;
    private final Log log;
    private volatile MeasureDoNothing monitorGc;

    public MonitorGc(Config config, Log log) {
        this.config = config;
        this.log = log;
    }

    @Override
    public void init() throws Throwable {
    }

    @Override
    public void start() throws Throwable {
        this.monitorGc = new MeasureDoNothing("neo4j.PauseMonitor", this.log, this.config.get(Configuration.gc_monitor_wait_time), (long)this.config.get(Configuration.gc_monitor_threshold));
        this.monitorGc.start();
    }

    @Override
    public void stop() throws Throwable {
        this.monitorGc.stopMeasuring();
        this.monitorGc = null;
    }

    @Override
    public void shutdown() throws Throwable {
    }

    public static class Configuration {
        public static final Setting<Long> gc_monitor_wait_time = Settings.setting("gc_monitor_wait_time", Settings.DURATION, "100ms");
        public static final Setting<Long> gc_monitor_threshold = Settings.setting("gc_monitor_threshold", Settings.DURATION, "200ms");
    }
}

