/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.core.TokenHolder;

public class NonTransactionalTokenNameLookup
implements TokenNameLookup {
    private final LabelTokenHolder labelTokenHolder;
    private final RelationshipTypeTokenHolder relationshipTypeTokenHolder;
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;

    public NonTransactionalTokenNameLookup(LabelTokenHolder labelTokenHolder, RelationshipTypeTokenHolder relationshipTypeTokenHolder, PropertyKeyTokenHolder propertyKeyTokenHolder) {
        this.labelTokenHolder = labelTokenHolder;
        this.relationshipTypeTokenHolder = relationshipTypeTokenHolder;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
    }

    @Override
    public String labelGetName(int labelId) {
        return NonTransactionalTokenNameLookup.tokenById(this.labelTokenHolder, labelId, "label");
    }

    @Override
    public String relationshipTypeGetName(int relTypeId) {
        return NonTransactionalTokenNameLookup.tokenById(this.relationshipTypeTokenHolder, relTypeId, "relationshipType");
    }

    @Override
    public String propertyKeyGetName(int propertyKeyId) {
        return NonTransactionalTokenNameLookup.tokenById(this.propertyKeyTokenHolder, propertyKeyId, "property");
    }

    private static String tokenById(TokenHolder tokenHolder, int tokenId, String tokenName) {
        try {
            Object token = tokenHolder.getTokenByIdOrNull(tokenId);
            if (token != null) {
                return ((Token)token).name();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return String.format("%s[%d]", tokenName, tokenId);
    }
}

