/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.collection.pool.LinkedQueuePool;
import org.neo4j.collection.pool.MarshlandPool;
import org.neo4j.collection.pool.Pool;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.helpers.Clock;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.LegacyIndexProviderLookup;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.LegacyIndexTransactionStateImpl;
import org.neo4j.kernel.impl.api.store.ProcedureCache;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.state.IntegrityValidator;
import org.neo4j.kernel.impl.transaction.state.NeoStoreTransactionContext;
import org.neo4j.kernel.impl.transaction.state.NeoStoreTransactionContextFactory;
import org.neo4j.kernel.impl.transaction.state.TransactionRecordState;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.tracing.Tracers;

public class KernelTransactions
extends LifecycleAdapter
implements Factory<KernelTransaction> {
    private final NeoStoreTransactionContextFactory neoStoreTransactionContextFactory;
    private final NeoStores neoStores;
    private final Locks locks;
    private final IntegrityValidator integrityValidator;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final IndexingService indexingService;
    private final LabelScanStore labelScanStore;
    private final StatementOperationParts statementOperations;
    private final UpdateableSchemaState updateableSchemaState;
    private final SchemaWriteGuard schemaWriteGuard;
    private final SchemaIndexProviderMap providerMap;
    private final TransactionHeaderInformationFactory transactionHeaderInformationFactory;
    private final StoreReadLayer storeLayer;
    private final TransactionCommitProcess transactionCommitProcess;
    private final IndexConfigStore indexConfigStore;
    private final LegacyIndexProviderLookup legacyIndexProviderLookup;
    private final TransactionHooks hooks;
    private final ConstraintSemantics constraintSemantics;
    private final TransactionMonitor transactionMonitor;
    private final LifeSupport dataSourceLife;
    private final ProcedureCache procedureCache;
    private final Tracers tracers;
    private final Set<KernelTransactionImplementation> allTransactions = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Factory<KernelTransactionImplementation> factory = new Factory<KernelTransactionImplementation>(){

        public KernelTransactionImplementation newInstance() {
            NeoStoreTransactionContext context = KernelTransactions.this.neoStoreTransactionContextFactory.newInstance();
            TransactionRecordState recordState = new TransactionRecordState(KernelTransactions.this.neoStores, KernelTransactions.this.integrityValidator, context);
            LegacyIndexTransactionStateImpl legacyIndexTransactionState = new LegacyIndexTransactionStateImpl(KernelTransactions.this.indexConfigStore, KernelTransactions.this.legacyIndexProviderLookup);
            KernelTransactionImplementation tx = new KernelTransactionImplementation(KernelTransactions.this.statementOperations, KernelTransactions.this.schemaWriteGuard, KernelTransactions.this.labelScanStore, KernelTransactions.this.indexingService, KernelTransactions.this.updateableSchemaState, recordState, KernelTransactions.this.providerMap, KernelTransactions.this.neoStores, KernelTransactions.this.locks, KernelTransactions.this.hooks, KernelTransactions.this.constraintIndexCreator, KernelTransactions.this.transactionHeaderInformationFactory, KernelTransactions.this.transactionCommitProcess, KernelTransactions.this.transactionMonitor, KernelTransactions.this.storeLayer, legacyIndexTransactionState, (Pool<KernelTransactionImplementation>)KernelTransactions.this.localTxPool, KernelTransactions.this.constraintSemantics, Clock.SYSTEM_CLOCK, ((KernelTransactions)KernelTransactions.this).tracers.transactionTracer, KernelTransactions.this.procedureCache, context);
            KernelTransactions.this.allTransactions.add(tx);
            return tx;
        }
    };
    private final LinkedQueuePool<KernelTransactionImplementation> globalTxPool = new LinkedQueuePool<KernelTransactionImplementation>(8, this.factory){

        protected void dispose(KernelTransactionImplementation tx) {
            KernelTransactions.this.allTransactions.remove(tx);
            tx.dispose();
            super.dispose((Object)tx);
        }
    };
    private final MarshlandPool<KernelTransactionImplementation> localTxPool = new MarshlandPool(this.globalTxPool);

    public KernelTransactions(NeoStoreTransactionContextFactory neoStoreTransactionContextFactory, NeoStores neoStores, Locks locks, IntegrityValidator integrityValidator, ConstraintIndexCreator constraintIndexCreator, IndexingService indexingService, LabelScanStore labelScanStore, StatementOperationParts statementOperations, UpdateableSchemaState updateableSchemaState, SchemaWriteGuard schemaWriteGuard, SchemaIndexProviderMap providerMap, TransactionHeaderInformationFactory txHeaderFactory, StoreReadLayer storeLayer, TransactionCommitProcess transactionCommitProcess, IndexConfigStore indexConfigStore, LegacyIndexProviderLookup legacyIndexProviderLookup, TransactionHooks hooks, ConstraintSemantics constraintSemantics, TransactionMonitor transactionMonitor, LifeSupport dataSourceLife, ProcedureCache procedureCache, Tracers tracers) {
        this.neoStoreTransactionContextFactory = neoStoreTransactionContextFactory;
        this.neoStores = neoStores;
        this.locks = locks;
        this.integrityValidator = integrityValidator;
        this.constraintIndexCreator = constraintIndexCreator;
        this.indexingService = indexingService;
        this.labelScanStore = labelScanStore;
        this.statementOperations = statementOperations;
        this.updateableSchemaState = updateableSchemaState;
        this.schemaWriteGuard = schemaWriteGuard;
        this.providerMap = providerMap;
        this.transactionHeaderInformationFactory = txHeaderFactory;
        this.storeLayer = storeLayer;
        this.transactionCommitProcess = transactionCommitProcess;
        this.indexConfigStore = indexConfigStore;
        this.legacyIndexProviderLookup = legacyIndexProviderLookup;
        this.hooks = hooks;
        this.constraintSemantics = constraintSemantics;
        this.transactionMonitor = transactionMonitor;
        this.dataSourceLife = dataSourceLife;
        this.procedureCache = procedureCache;
        this.tracers = tracers;
    }

    public KernelTransaction newInstance() {
        this.assertDatabaseIsRunning();
        return ((KernelTransactionImplementation)this.localTxPool.acquire()).initialize(this.neoStores.getMetaDataStore().getLastCommittedTransactionId());
    }

    public List<KernelTransaction> activeTransactions() {
        ArrayList<KernelTransaction> output = new ArrayList<KernelTransaction>();
        for (KernelTransactionImplementation tx : this.allTransactions) {
            if (!tx.isOpen()) continue;
            output.add(tx);
        }
        return output;
    }

    public void disposeAll() {
        for (KernelTransactionImplementation tx : this.allTransactions) {
            tx.markForTermination();
        }
        this.localTxPool.disposeAll();
        this.globalTxPool.disposeAll();
    }

    @Override
    public void shutdown() throws Throwable {
        this.disposeAll();
    }

    private void assertDatabaseIsRunning() {
        if (!this.dataSourceLife.isRunning()) {
            throw new DatabaseShutdownException();
        }
    }
}

